/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.system.initialize;

import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.core.Family;
import gaiasky.scene.Mapper;
import gaiasky.scene.component.Body;
import gaiasky.scene.component.Label;
import gaiasky.scene.component.Model;
import gaiasky.scene.component.SolidAngle;
import gaiasky.scene.component.Volume;
import gaiasky.scene.system.initialize.AbstractInitSystem;
import gaiasky.scene.system.render.draw.model.ModelEntityRenderSystem;
import gaiasky.scene.system.render.draw.text.LabelEntityRenderSystem;
import gaiasky.scene.view.LabelView;
import gaiasky.util.Constants;
import gaiasky.util.Settings;

public class VolumeInitializer
extends AbstractInitSystem {
    public VolumeInitializer(boolean setUp, Family family, int priority) {
        super(setUp, family, priority);
    }

    @Override
    public void initializeEntity(Entity entity) {
        Model model = (Model)Mapper.model.get(entity);
        Volume volume = (Volume)Mapper.volume.get(entity);
        if (volume.fragmentShader != null && volume.vertexShader != null) {
            volume.key = (volume.fragmentShader + volume.vertexShader).hashCode();
        }
        model.renderConsumer = ModelEntityRenderSystem::renderVolume;
    }

    @Override
    public void setUpEntity(Entity entity) {
        Body body = (Body)Mapper.body.get(entity);
        Model model = (Model)Mapper.model.get(entity);
        Label label = (Label)Mapper.label.get(entity);
        SolidAngle sa = (SolidAngle)Mapper.sa.get(entity);
        model.model.setUnits(Constants.KM_TO_U);
        model.model.updateSize(body.size);
        sa.thresholdLabel = Math.toRadians(1.0E-6) / (double)Settings.settings.scene.label.number * 5000.0;
        label.textScale = 0.2f;
        label.labelMax = 6.0E-4f;
        if (label.labelFactor == 0.0f) {
            label.labelFactor = 5.0E-4f;
        }
        label.renderConsumer = LabelEntityRenderSystem::renderCelestial;
        label.renderFunction = LabelView::renderTextBase;
    }
}

