/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.system.render;

import com.badlogic.ashley.core.Entity;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.glutils.FrameBuffer;
import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.GdxRuntimeException;
import gaiasky.GaiaSky;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.event.IObserver;
import gaiasky.render.ComponentTypes;
import gaiasky.render.GaiaSkyShaderCompileException;
import gaiasky.render.RenderAssets;
import gaiasky.render.RenderGroup;
import gaiasky.render.RenderingContext;
import gaiasky.render.api.IPostProcessor;
import gaiasky.render.api.IRenderMode;
import gaiasky.render.api.IRenderable;
import gaiasky.render.api.ISceneRenderer;
import gaiasky.render.api.StubRenderable;
import gaiasky.render.postprocess.util.PingPongBuffer;
import gaiasky.render.process.RenderModeCubemapProjections;
import gaiasky.render.process.RenderModeMain;
import gaiasky.render.process.RenderModeOpenXR;
import gaiasky.render.process.RenderModeStereoscopic;
import gaiasky.render.system.AbstractRenderSystem;
import gaiasky.render.system.IRenderSystem;
import gaiasky.render.util.GaiaSkyFrameBuffer;
import gaiasky.scene.Mapper;
import gaiasky.scene.camera.CameraManager;
import gaiasky.scene.camera.ICamera;
import gaiasky.scene.component.Render;
import gaiasky.scene.system.render.VolumeRenderer;
import gaiasky.scene.system.render.draw.BillboardRenderer;
import gaiasky.scene.system.render.draw.BillboardSetRenderer;
import gaiasky.scene.system.render.draw.ElementsRenderer;
import gaiasky.scene.system.render.draw.ElementsSetRenderer;
import gaiasky.scene.system.render.draw.LinePrimitiveRenderer;
import gaiasky.scene.system.render.draw.LineQuadstripRenderer;
import gaiasky.scene.system.render.draw.ModelRenderer;
import gaiasky.scene.system.render.draw.ParticleEffectsRenderer;
import gaiasky.scene.system.render.draw.ParticleSetInstancedRenderer;
import gaiasky.scene.system.render.draw.ParticleSetPointRenderer;
import gaiasky.scene.system.render.draw.PointPrimitiveRenderSystem;
import gaiasky.scene.system.render.draw.PrimitiveVertexRenderSystem;
import gaiasky.scene.system.render.draw.SingleStarQuadRenderer;
import gaiasky.scene.system.render.draw.SpriteRenderer;
import gaiasky.scene.system.render.draw.StarSetInstancedRenderer;
import gaiasky.scene.system.render.draw.StarSetPointRenderer;
import gaiasky.scene.system.render.draw.TessellationRenderer;
import gaiasky.scene.system.render.draw.TextRenderer;
import gaiasky.scene.system.render.draw.VariableSetInstancedRenderer;
import gaiasky.scene.system.render.draw.VariableSetPointRenderer;
import gaiasky.scene.system.render.draw.model.ModelEntityRenderSystem;
import gaiasky.scene.system.render.pass.CascadedShadowMapRenderPass;
import gaiasky.scene.system.render.pass.LightGlowRenderPass;
import gaiasky.scene.system.render.pass.RenderPass;
import gaiasky.scene.system.render.pass.SVTRenderPass;
import gaiasky.scene.system.render.pass.ShadowMapRenderPass;
import gaiasky.util.GlobalResources;
import gaiasky.util.Logger;
import gaiasky.util.Settings;
import gaiasky.util.gdx.IntModelBatch;
import gaiasky.util.gdx.shader.ExtShaderProgram;
import gaiasky.util.math.MathUtilsDouble;
import gaiasky.vr.openxr.XrDriver;
import gaiasky.vr.openxr.input.XrControllerDevice;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import net.jafama.FastMath;
import org.lwjgl.opengl.GL30;
import org.lwjgl.opengl.GL32;
import org.lwjgl.opengl.GL40;

public class SceneRenderer
implements ISceneRenderer,
IObserver {
    private static final Logger.Log logger = Logger.getLogger(SceneRenderer.class);
    private final int SGR_DEFAULT_IDX = 0;
    private final int SGR_STEREO_IDX = 1;
    private final int SGR_CUBEMAP_IDX = 2;
    private final int SGR_OPENXR_IDX = 3;
    private final XrDriver xrDriver;
    private final GlobalResources globalResources;
    private final AtomicBoolean rendering;
    private final RenderAssets renderAssets;
    public ComponentTypes visible;
    public long[] times;
    public float[] alphas;
    private final ModelEntityRenderSystem modelEntityRenderSystem = new ModelEntityRenderSystem(this);
    private List<List<IRenderable>> renderLists;
    private Map<RenderGroup, IRenderSystem> renderSystems;
    private List<RenderGroup> renderGroups;
    private AbstractRenderSystem.RenderSystemRunnable depthTestR;
    private AbstractRenderSystem.RenderSystemRunnable additiveBlendR;
    private AbstractRenderSystem.RenderSystemRunnable noDepthTestR;
    private AbstractRenderSystem.RenderSystemRunnable regularBlendR;
    private AbstractRenderSystem.RenderSystemRunnable depthTestNoWritesR;
    private AbstractRenderSystem.RenderSystemRunnable noDepthWritesR;
    private AbstractRenderSystem.RenderSystemRunnable depthWritesR;
    private AbstractRenderSystem.RenderSystemRunnable clearDepthR;
    private IRenderMode renderMode;
    private IRenderMode[] sgrList;
    private Map<Integer, FrameBuffer> frameBufferMap;
    private final ShadowMapRenderPass shadowMapPass;
    private final LightGlowRenderPass lightGlowPass;
    private final List<RenderPass> renderPasses;
    private final RenderGroup[] autonomousGroups = new RenderGroup[]{RenderGroup.PARTICLE_EFFECTS};
    private final IRenderable stubRenderable = new StubRenderable();

    public SceneRenderer(XrDriver xrDriver, GlobalResources globalResources) {
        this.xrDriver = xrDriver;
        this.globalResources = globalResources;
        this.rendering = new AtomicBoolean(false);
        this.renderAssets = new RenderAssets(globalResources);
        this.shadowMapPass = new ShadowMapRenderPass(this);
        CascadedShadowMapRenderPass cascadedShadowMapRenderPass = new CascadedShadowMapRenderPass(this);
        this.lightGlowPass = new LightGlowRenderPass(this);
        SVTRenderPass svtPass = new SVTRenderPass(this);
        this.shadowMapPass.setCondition(() -> Settings.settings.scene.renderer.shadow.active);
        cascadedShadowMapRenderPass.setCondition(() -> Settings.settings.scene.renderer.shadow.active);
        cascadedShadowMapRenderPass.setEnabled(false);
        this.renderPasses = new ArrayList<RenderPass>();
        this.renderPasses.add(this.shadowMapPass);
        this.renderPasses.add(cascadedShadowMapRenderPass);
        this.renderPasses.add(this.lightGlowPass);
        this.renderPasses.add(svtPass);
    }

    @Override
    public void initialize(AssetManager manager) {
        this.frameBufferMap = new HashMap<Integer, FrameBuffer>();
        this.renderAssets.initialize(manager);
        this.renderSystems = new HashMap<RenderGroup, IRenderSystem>();
        this.renderGroups = new ArrayList<RenderGroup>();
        this.renderGroups.addAll(Arrays.asList(RenderGroup.values()));
        this.renderGroups.sort(Comparator.comparingInt(rg -> rg.priority));
        this.noDepthTestR = (renderSystem, renderList, camera) -> {
            Gdx.gl.glDisable(2929);
            Gdx.gl.glDepthMask(false);
        };
        this.depthTestR = (renderSystem, renderList, camera) -> {
            Gdx.gl.glEnable(2929);
            Gdx.gl.glDepthMask(true);
        };
        this.depthTestNoWritesR = (renderSystem, renderList, camera) -> {
            Gdx.gl.glEnable(2929);
            Gdx.gl.glDepthMask(false);
        };
        this.noDepthWritesR = (renderSystem, renderList, camera) -> Gdx.gl.glDepthMask(false);
        this.depthWritesR = (renderSystem, renderList, camera) -> Gdx.gl.glDepthMask(true);
        this.additiveBlendR = (renderSystem, renderList, camera) -> {
            Gdx.gl.glEnable(3042);
            GL40.glBlendFunc((int)1, (int)1);
        };
        this.regularBlendR = (renderSystem, renderList, camera) -> {
            Gdx.gl.glEnable(3042);
            GL40.glBlendFunc((int)770, (int)771);
        };
        this.clearDepthR = (renderSystem, renderList, camera) -> Gdx.gl.glClear(256);
        for (RenderPass renderPass : this.renderPasses) {
            renderPass.initialize();
        }
    }

    @Override
    public void doneLoading(AssetManager manager) {
        this.renderAssets.doneLoading(manager);
        for (RenderPass renderPass : this.renderPasses) {
            renderPass.doneLoading(manager);
        }
        RenderGroup[] renderGroups = RenderGroup.values();
        this.renderLists = new ArrayList<List<IRenderable>>(renderGroups.length);
        for (int i = 0; i < renderGroups.length; ++i) {
            this.renderLists.add(new ArrayList(20));
        }
        this.visible = new ComponentTypes();
        ComponentTypes.ComponentType[] types = ComponentTypes.ComponentType.values();
        for (int i = 0; i < Settings.settings.scene.visibility.size(); ++i) {
            if (!Settings.settings.scene.visibility.get(types[i].toString()).booleanValue()) continue;
            this.visible.set(ComponentTypes.ComponentType.values()[i].ordinal());
        }
        this.visible.set(ComponentTypes.ComponentType.Invisible.ordinal());
        ComponentTypes.ComponentType[] comps = ComponentTypes.ComponentType.values();
        this.times = new long[comps.length];
        this.alphas = new float[comps.length];
        for (int i = 0; i < comps.length; ++i) {
            this.times[i] = -20000L;
            this.alphas[i] = 0.0f;
        }
        this.sgrList = new IRenderMode[4];
        this.sgrList[0] = new RenderModeMain();
        this.sgrList[1] = new RenderModeStereoscopic(this.globalResources.getSpriteBatch());
        this.sgrList[2] = new RenderModeCubemapProjections();
        this.sgrList[3] = new RenderModeOpenXR(GaiaSky.instance.scene, this.xrDriver, this.globalResources.getExtSpriteBatch());
        this.renderMode = null;
        GL30.glClampColor((int)35100, (int)0);
        EventManager.instance.subscribe((IObserver)this, Event.TOGGLE_VISIBILITY_CMD, Event.LINE_RENDERER_UPDATE, Event.STEREOSCOPIC_CMD, Event.CAMERA_MODE_CMD, Event.CUBEMAP_CMD, Event.REBUILD_SHADOW_MAP_DATA_CMD, Event.LIGHT_GLOW_CMD);
    }

    private AbstractRenderSystem initializeRenderSystem(RenderGroup rg) {
        AbstractRenderSystem system = null;
        switch (rg) {
            case SKYBOX: {
                system = new ModelRenderer(this, RenderGroup.SKYBOX, this.alphas, this.renderAssets.mbSkybox);
                break;
            }
            case MODEL_BG: {
                system = new ModelRenderer(this, RenderGroup.MODEL_BG, this.alphas, this.renderAssets.mbVertexDiffuse);
                break;
            }
            case POINT_STAR: {
                system = new SingleStarQuadRenderer(this, RenderGroup.POINT_STAR, this.alphas, this.renderAssets.starGroupShaders, ComponentTypes.ComponentType.Stars);
                system.addPreRunnables(this.additiveBlendR, this.noDepthTestR);
                break;
            }
            case MODEL_VERT_GRID: {
                system = new ModelRenderer(this, RenderGroup.MODEL_VERT_GRID, this.alphas, this.renderAssets.mbVertexLightingGrid);
                system.addPostRunnables(this.clearDepthR);
                break;
            }
            case MODEL_VERT_RECGRID: {
                system = new ModelRenderer(this, RenderGroup.MODEL_VERT_RECGRID, this.alphas, this.renderAssets.mbVertexLightingRecGrid);
                system.addPreRunnables(this.regularBlendR, this.depthTestR);
                break;
            }
            case LINE: {
                system = this.getLineCPURenderSystem();
                break;
            }
            case LINE_GPU: {
                system = this.getLineGPURenderSystem();
                break;
            }
            case POINT: {
                system = new PointPrimitiveRenderSystem(this, RenderGroup.POINT, this.alphas, this.renderAssets.pointShaders);
                break;
            }
            case POINT_GPU: {
                system = new PrimitiveVertexRenderSystem(this, RenderGroup.POINT_GPU, this.alphas, this.renderAssets.primitiveGpuShaders, false);
                system.addPreRunnables(this.regularBlendR, this.depthTestR);
                break;
            }
            case MODEL_PIX_DUST: {
                system = new ModelRenderer(this, RenderGroup.MODEL_PIX_DUST, this.alphas, this.renderAssets.mbPixelLightingDust);
                break;
            }
            case MODEL_VERT_ADDITIVE: {
                system = new ModelRenderer(this, RenderGroup.MODEL_VERT_ADDITIVE, this.alphas, this.renderAssets.mbVertexLightingAdditive);
                break;
            }
            case MODEL_PIX_EARLY: {
                system = new ModelRenderer(this, RenderGroup.MODEL_PIX_EARLY, this.alphas, this.renderAssets.mbPixelLighting);
                break;
            }
            case MODEL_VERT_EARLY: {
                system = new ModelRenderer(this, RenderGroup.MODEL_VERT_EARLY, this.alphas, this.renderAssets.mbVertexLighting);
                break;
            }
            case MODEL_DIFFUSE: {
                system = new ModelRenderer(this, RenderGroup.MODEL_DIFFUSE, this.alphas, this.renderAssets.mbVertexDiffuse);
                break;
            }
            case MODEL_PIX: {
                system = new ModelRenderer(this, RenderGroup.MODEL_PIX, this.alphas, this.renderAssets.mbPixelLighting);
                break;
            }
            case MODEL_PIX_TESS: {
                system = new TessellationRenderer(this, RenderGroup.MODEL_PIX_TESS, this.alphas, this.renderAssets.mbPixelLightingTessellation);
                system.addPreRunnables(this.regularBlendR, this.depthTestR);
                break;
            }
            case BILLBOARD_GROUP: {
                system = new BillboardSetRenderer(this, RenderGroup.BILLBOARD_GROUP, this.alphas, this.renderAssets.billboardGroupShaders);
                break;
            }
            case PARTICLE_GROUP: {
                Settings.PointCloudMode pointCloudModeParticles = Settings.settings.scene.renderer.pointCloud;
                system = switch (pointCloudModeParticles) {
                    default -> throw new MatchException(null, null);
                    case Settings.PointCloudMode.TRIANGLES -> new ParticleSetInstancedRenderer(this, RenderGroup.PARTICLE_GROUP, this.alphas, this.renderAssets.particleGroupShaders);
                    case Settings.PointCloudMode.POINTS -> new ParticleSetPointRenderer(this, RenderGroup.PARTICLE_GROUP, this.alphas, this.renderAssets.particleGroupShaders);
                };
                system.addPreRunnables(this.additiveBlendR, this.depthTestR, this.noDepthWritesR);
                system.addPostRunnables(this.regularBlendR, this.depthWritesR);
                break;
            }
            case PARTICLE_GROUP_EXT_BILLBOARD: {
                system = new ParticleSetInstancedRenderer(this, RenderGroup.PARTICLE_GROUP_EXT_BILLBOARD, this.alphas, this.renderAssets.particleGroupExtBillboardShaders);
                system.addPreRunnables(this.additiveBlendR, this.depthTestR, this.noDepthWritesR);
                system.addPostRunnables(this.regularBlendR, this.depthWritesR);
                break;
            }
            case PARTICLE_GROUP_EXT_MODEL: {
                system = new ParticleSetInstancedRenderer(this, RenderGroup.PARTICLE_GROUP_EXT_MODEL, this.alphas, this.renderAssets.particleGroupExtModelShaders);
                system.addPreRunnables(this.additiveBlendR, this.depthTestR, this.noDepthWritesR);
                system.addPostRunnables(this.regularBlendR, this.depthWritesR);
                break;
            }
            case STAR_GROUP: {
                Settings.PointCloudMode pointCloudMode = Settings.settings.scene.renderer.pointCloud;
                system = switch (pointCloudMode) {
                    default -> throw new MatchException(null, null);
                    case Settings.PointCloudMode.TRIANGLES -> new StarSetInstancedRenderer(this, RenderGroup.STAR_GROUP, this.alphas, this.renderAssets.starGroupShaders);
                    case Settings.PointCloudMode.POINTS -> new StarSetPointRenderer(this, RenderGroup.STAR_GROUP, this.alphas, this.renderAssets.starGroupShaders);
                };
                system.addPreRunnables(this.additiveBlendR, this.depthTestR, this.noDepthWritesR);
                system.addPostRunnables(this.regularBlendR, this.depthWritesR);
                break;
            }
            case VARIABLE_GROUP: {
                Settings.PointCloudMode pointCloudMode = Settings.settings.scene.renderer.pointCloud;
                system = switch (pointCloudMode) {
                    default -> throw new MatchException(null, null);
                    case Settings.PointCloudMode.TRIANGLES -> new VariableSetInstancedRenderer(this, RenderGroup.VARIABLE_GROUP, this.alphas, this.renderAssets.variableGroupShaders);
                    case Settings.PointCloudMode.POINTS -> new VariableSetPointRenderer(this, RenderGroup.VARIABLE_GROUP, this.alphas, this.renderAssets.variableGroupShaders);
                };
                system.addPreRunnables(this.additiveBlendR, this.depthTestR, this.noDepthWritesR);
                system.addPostRunnables(this.regularBlendR, this.depthWritesR);
                break;
            }
            case ORBITAL_ELEMENTS_PARTICLE: {
                system = new ElementsRenderer(this, RenderGroup.ORBITAL_ELEMENTS_PARTICLE, this.alphas, this.renderAssets.orbitElemShaders);
                system.addPreRunnables(this.additiveBlendR, this.depthTestR, this.noDepthWritesR);
                system.addPostRunnables(this.regularBlendR, this.depthWritesR);
                break;
            }
            case ORBITAL_ELEMENTS_GROUP: {
                system = new ElementsSetRenderer(this, RenderGroup.ORBITAL_ELEMENTS_GROUP, this.alphas, this.renderAssets.orbitElemShaders);
                system.addPreRunnables(this.additiveBlendR, this.depthTestR, this.noDepthWritesR);
                system.addPostRunnables(this.regularBlendR, this.depthWritesR);
                break;
            }
            case MODEL_VERT_STAR: {
                system = new ModelRenderer(this, RenderGroup.MODEL_VERT_STAR, this.alphas, this.renderAssets.mbVertexLightingStarSurface);
                break;
            }
            case FONT_LABEL: {
                system = new TextRenderer(this, RenderGroup.FONT_LABEL, this.alphas, this.renderAssets.fontBatch, this.renderAssets.distanceFieldFontShader, this.renderAssets.fontDistanceFiled);
                break;
            }
            case BILLBOARD_SSO: {
                system = new BillboardRenderer(this, RenderGroup.BILLBOARD_SSO, this.alphas, this.renderAssets.billboardShaders, "$data/tex/base/sso.png", false);
                system.addPreRunnables(this.additiveBlendR, this.depthTestNoWritesR);
                break;
            }
            case BILLBOARD_STAR: {
                system = new BillboardRenderer(this, RenderGroup.BILLBOARD_STAR, this.alphas, this.renderAssets.billboardShaders, Settings.settings.scene.star.getStarTexture(), true);
                system.addPreRunnables(this.additiveBlendR, this.depthTestNoWritesR);
                system.addPostRunnables(this.lightGlowPass.getLpu());
                break;
            }
            case BILLBOARD_GAL: {
                system = new BillboardRenderer(this, RenderGroup.BILLBOARD_GAL, this.alphas, this.renderAssets.galShaders, "$data/tex/base/static.jpg", false);
                system.addPreRunnables(this.additiveBlendR, this.depthTestNoWritesR);
                break;
            }
            case BILLBOARD_SPRITE: {
                system = new BillboardRenderer(this, RenderGroup.BILLBOARD_SPRITE, this.alphas, this.renderAssets.spriteShaders, null, false);
                system.addPreRunnables(this.additiveBlendR, this.depthTestNoWritesR);
                break;
            }
            case MODEL_ATM: {
                system = new ModelRenderer(this, this, RenderGroup.MODEL_ATM, this.alphas, this.renderAssets.mbAtmosphere){

                    @Override
                    public float getAlpha(IRenderable s) {
                        return this.alphas[ComponentTypes.ComponentType.Atmospheres.ordinal()] * (float)FastMath.pow((double)this.alphas[s.getComponentType().getFirstOrdinal()], (double)2.0);
                    }

                    @Override
                    protected boolean mustRender() {
                        return this.alphas[ComponentTypes.ComponentType.Atmospheres.ordinal()] * this.alphas[ComponentTypes.ComponentType.Planets.ordinal()] > 0.0f;
                    }
                };
                break;
            }
            case MODEL_CLOUD: {
                system = new ModelRenderer(this, RenderGroup.MODEL_CLOUD, this.alphas, this.renderAssets.mbCloud);
                break;
            }
            case MODEL_PIX_TRANSPARENT: {
                system = new ModelRenderer(this, RenderGroup.MODEL_PIX_TRANSPARENT, this.alphas, this.renderAssets.mbPixelLighting);
                break;
            }
            case LINE_LATE: {
                system = new LinePrimitiveRenderer(this, RenderGroup.LINE_LATE, this.alphas, this.renderAssets.lineCpuShaders);
                system.addPreRunnables(this.regularBlendR, this.depthTestR, this.noDepthWritesR);
                break;
            }
            case VOLUME: {
                system = new VolumeRenderer(this, RenderGroup.VOLUME, this.alphas);
                break;
            }
            case PARTICLE_EFFECTS: {
                system = new ParticleEffectsRenderer(this, RenderGroup.PARTICLE_EFFECTS, this.alphas, this.renderAssets.particleEffectShaders);
                system.addPreRunnables(this.additiveBlendR, this.noDepthTestR);
                system.addPostRunnables(this.regularBlendR);
                break;
            }
            case SPRITE: {
                system = new SpriteRenderer(this, RenderGroup.SPRITE, this.alphas, this.globalResources.getSpriteShader());
                system.addPreRunnables(this.regularBlendR, this.noDepthTestR);
            }
        }
        if (system != null) {
            this.addRenderSystem(system);
        }
        return system;
    }

    private void addRenderSystem(IRenderSystem renderSystem) {
        this.renderSystems.put(renderSystem.getRenderGroup(), renderSystem);
    }

    public synchronized void setRendering(boolean rendering) {
        this.rendering.set(rendering);
    }

    @Override
    public List<List<IRenderable>> getRenderLists() {
        return this.renderLists;
    }

    private void initRenderMode(ICamera camera) {
        this.renderMode = Settings.settings.runtime.openXr ? this.sgrList[3] : (Settings.settings.program.modeStereo.active ? this.sgrList[1] : (Settings.settings.program.modeCubemap.active ? this.sgrList[2] : this.sgrList[0]));
    }

    public void renderModel(IRenderable r, IntModelBatch batch) {
        if (r instanceof Render) {
            Render render = (Render)r;
            if (Mapper.model.has(render.entity)) {
                this.modelEntityRenderSystem.renderOpaque(render.entity, batch, 1.0f, false);
            }
        }
    }

    public void clearScreen() {
        Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        GL32.glClearDepth((double)1000000.0);
        Gdx.gl.glClear(16640);
    }

    public void render(ICamera camera, double t, int rw, int rh, int tw, int th, FrameBuffer fb, IPostProcessor.PostProcessBean ppb) {
        if (this.rendering.get()) {
            if (this.renderMode == null) {
                this.initRenderMode(camera);
            }
            for (RenderPass renderPass : this.renderPasses) {
                renderPass.render(camera, new Object[0]);
            }
            this.renderMode.render(this, camera, t, rw, rh, tw, th, fb, ppb);
        }
    }

    @Override
    public IRenderMode getRenderProcess() {
        return this.renderMode;
    }

    @Override
    public FrameBuffer getGlowFrameBuffer() {
        return this.lightGlowPass.getOcclusionFrameBuffer();
    }

    public IRenderSystem getOrInitializeRenderSystem(RenderGroup rg) {
        IRenderSystem renderSystem = this.renderSystems.get((Object)rg);
        if (renderSystem == null) {
            renderSystem = this.initializeRenderSystem(rg);
        }
        return renderSystem;
    }

    @Override
    public void renderScene(ICamera camera, double t, RenderingContext renderContext) {
        try {
            for (ComponentTypes.ComponentType ct : ComponentTypes.ComponentType.values()) {
                this.alphas[ct.ordinal()] = this.calculateAlpha(ct, t);
            }
            for (RenderGroup renderGroup : this.renderGroups) {
                IRenderSystem renderSystem;
                List<IRenderable> l = this.renderLists.get(renderGroup.ordinal());
                if (l == null || l.isEmpty() || (renderSystem = this.getOrInitializeRenderSystem(renderGroup)) == null) continue;
                renderSystem.render(l, camera, t, renderContext);
            }
        }
        catch (GdxRuntimeException | GaiaSkyShaderCompileException gre) {
            throw gre;
        }
        catch (Exception e) {
            logger.error(e);
        }
    }

    public void swapRenderLists() {
        for (RenderGroup rg : RenderGroup.values()) {
            this.renderLists.get(rg.ordinal()).clear();
        }
        for (RenderGroup rg : this.autonomousGroups) {
            this.renderLists.get(rg.ordinal()).add(this.stubRenderable);
        }
    }

    @Override
    public boolean isOn(ComponentTypes.ComponentType comp) {
        return this.visible.get(comp.ordinal()) || this.alphas[comp.ordinal()] > 0.0f;
    }

    @Override
    public boolean allOn(ComponentTypes comp) {
        boolean allOn;
        boolean bl = allOn = comp.isEmpty() || comp.allSetLike(this.visible);
        if (!allOn) {
            allOn = true;
            int i = comp.nextSetBit(0);
            while (i >= 0) {
                boolean bl2 = allOn = allOn && this.alphas[i] > 0.0f;
                if (i == Integer.MAX_VALUE) break;
                i = comp.nextSetBit(i + 1);
            }
        }
        return allOn;
    }

    public float alpha(ComponentTypes comp) {
        float alpha = 1.0f;
        int i = comp.nextSetBit(0);
        while (i >= 0) {
            alpha *= this.alphas[i];
            i = comp.nextSetBit(i + 1);
        }
        return alpha;
    }

    public boolean isOn(int ordinal) {
        return this.visible.get(ordinal) || this.alphas[ordinal] > 0.0f;
    }

    public boolean isVR() {
        return this.xrDriver != null;
    }

    @Override
    public void notify(Event event, Object source, Object ... data) {
        switch (event) {
            case TOGGLE_VISIBILITY_CMD: {
                ComponentTypes.ComponentType ct = ComponentTypes.ComponentType.getFromKey((String)data[0]);
                if (ct == null) break;
                int idx = ct.ordinal();
                if (data.length == 2) {
                    boolean newVisibility;
                    boolean currentVisibility = this.visible.get(ct.ordinal());
                    if (currentVisibility == (newVisibility = ((Boolean)data[1]).booleanValue())) break;
                    if (newVisibility) {
                        this.visible.set(ct.ordinal());
                    } else {
                        this.visible.clear(ct.ordinal());
                    }
                    this.times[idx] = (long)(GaiaSky.instance.getT() * 1000.0);
                    break;
                }
                this.visible.flip(ct.ordinal());
                this.times[idx] = (long)(GaiaSky.instance.getT() * 1000.0);
                break;
            }
            case LINE_RENDERER_UPDATE: {
                GaiaSky.postRunnable(this::updateLineRenderSystems);
                break;
            }
            case STEREOSCOPIC_CMD: {
                if (this.isVR()) break;
                boolean stereo = (Boolean)data[0];
                if (stereo) {
                    this.renderMode = this.sgrList[1];
                    break;
                }
                if (Settings.settings.runtime.openXr) {
                    this.renderMode = this.sgrList[3];
                    break;
                }
                this.renderMode = this.sgrList[0];
                break;
            }
            case CUBEMAP_CMD: {
                boolean cubemap;
                boolean bl = cubemap = (Boolean)data[0] != false && !Settings.settings.runtime.openXr;
                if (cubemap) {
                    this.renderMode = this.sgrList[2];
                    break;
                }
                if (Settings.settings.runtime.openXr) {
                    this.renderMode = this.sgrList[3];
                    break;
                }
                this.renderMode = this.sgrList[0];
                break;
            }
            case CAMERA_MODE_CMD: {
                CameraManager.CameraMode cm = (CameraManager.CameraMode)((Object)data[0]);
                if (Settings.settings.runtime.openXr) {
                    this.renderMode = this.sgrList[3];
                    break;
                }
                if (Settings.settings.program.modeStereo.active) {
                    this.renderMode = this.sgrList[1];
                    break;
                }
                if (Settings.settings.program.modeCubemap.active) {
                    this.renderMode = this.sgrList[2];
                    break;
                }
                this.renderMode = this.sgrList[0];
                break;
            }
            case REBUILD_SHADOW_MAP_DATA_CMD: {
                this.shadowMapPass.buildShadowMapData();
                break;
            }
            case LIGHT_GLOW_CMD: {
                boolean glow = (Boolean)data[0];
                if (!glow) break;
                this.lightGlowPass.buildLightGlowData();
                break;
            }
        }
    }

    private float calculateAlpha(ComponentTypes.ComponentType type, double t) {
        int ordinal = type.ordinal();
        long diff = (long)(t * 1000.0) - this.times[ordinal];
        if (diff > Settings.settings.scene.fadeMs) {
            this.alphas[ordinal] = this.visible.get(ordinal) ? 1.0f : 0.0f;
            return this.alphas[ordinal];
        }
        return this.visible.get(ordinal) ? MathUtilsDouble.lint(diff, 0L, Settings.settings.scene.fadeMs, 0.0f, 1.0f) : MathUtilsDouble.lint(diff, 0L, Settings.settings.scene.fadeMs, 1.0f, 0.0f);
    }

    public void resize(int tw, int th, int rw, int rh) {
        this.resize(tw, th, rw, rh, false);
    }

    public void resize(int tw, int th, int rw, int rh, boolean resizeRenderSys) {
        if (resizeRenderSys) {
            this.resizeRenderSystems(tw, th);
        }
        for (IRenderMode sgr : this.sgrList) {
            sgr.resize(rw, rh, tw, th);
        }
    }

    public void resizeRenderSystems(int tw, int th) {
        Collection<IRenderSystem> systems = this.renderSystems.values();
        for (IRenderSystem rendSys : systems) {
            rendSys.resize(tw, th);
        }
    }

    public void dispose() {
        if (this.renderSystems != null) {
            Collection<IRenderSystem> systems = this.renderSystems.values();
            for (IRenderSystem rendSys : systems) {
                rendSys.dispose();
            }
            this.renderSystems.clear();
        }
        if (this.sgrList != null) {
            Arrays.stream(this.sgrList).forEach(Disposable::dispose);
            this.sgrList = null;
        }
        if (this.renderPasses != null) {
            this.renderPasses.forEach(Disposable::dispose);
        }
    }

    public void updateLineRenderSystems() {
        IRenderSystem currentGPU;
        IRenderSystem currentCPU = this.renderSystems.get((Object)RenderGroup.LINE);
        if (currentCPU != null) {
            this.renderSystems.remove((Object)currentCPU.getRenderGroup());
            AbstractRenderSystem lineSys = this.getLineCPURenderSystem();
            this.renderSystems.put(lineSys.getRenderGroup(), lineSys);
            currentCPU.dispose();
        }
        if ((currentGPU = this.renderSystems.get((Object)RenderGroup.LINE_GPU)) != null) {
            this.renderSystems.remove((Object)currentGPU.getRenderGroup());
            AbstractRenderSystem lineSys = this.getLineGPURenderSystem();
            this.renderSystems.put(lineSys.getRenderGroup(), lineSys);
            currentGPU.dispose();
        }
    }

    private AbstractRenderSystem getLineGPURenderSystem() {
        ExtShaderProgram[] lineGpuShaders = Settings.settings.scene.renderer.line.isNormalLineRenderer() || Gdx.graphics.getGLVersion().getMajorVersion() < 4 || Settings.settings.program.safeMode ? this.renderAssets.primitiveGpuShaders : this.renderAssets.lineQuadGpuShaders;
        PrimitiveVertexRenderSystem sys = new PrimitiveVertexRenderSystem(this, RenderGroup.LINE_GPU, this.alphas, lineGpuShaders, true);
        sys.addPreRunnables(this.additiveBlendR, this.depthTestR, this.noDepthWritesR);
        return sys;
    }

    private AbstractRenderSystem getLineCPURenderSystem() {
        LinePrimitiveRenderer sys;
        if (Settings.settings.scene.renderer.line.isNormalLineRenderer() || Gdx.graphics.getGLVersion().getMajorVersion() < 4 || Settings.settings.program.safeMode) {
            sys = new LinePrimitiveRenderer(this, RenderGroup.LINE, this.alphas, this.renderAssets.lineCpuShaders);
            sys.addPreRunnables(this.regularBlendR, this.depthTestR, this.noDepthWritesR);
        } else {
            sys = new LineQuadstripRenderer(this, RenderGroup.LINE, this.alphas, this.renderAssets.lineQuadCpuShaders);
            sys.addPreRunnables(this.additiveBlendR, this.depthTestR, this.noDepthWritesR);
        }
        return sys;
    }

    public RenderAssets getRenderAssets() {
        return this.renderAssets;
    }

    @Override
    public LightGlowRenderPass getLightGlowPass() {
        return this.lightGlowPass;
    }

    public void resetRenderSystemFlags() {
        Collection<IRenderSystem> systems = this.renderSystems.values();
        for (IRenderSystem system : systems) {
            if (!(system instanceof AbstractRenderSystem)) continue;
            ((AbstractRenderSystem)system).resetFlags();
        }
    }

    public RenderModeOpenXR getRenderModeOpenXR() {
        return (RenderModeOpenXR)this.sgrList[3];
    }

    public XrDriver getVrContext() {
        return this.xrDriver;
    }

    public FrameBuffer getFrameBuffer(int w, int h) {
        int key = this.getKey(w, h);
        if (!this.frameBufferMap.containsKey(key)) {
            GaiaSkyFrameBuffer fb = PingPongBuffer.createMainFrameBuffer(w, h, true, true, true, Pixmap.Format.RGB888, true);
            this.frameBufferMap.put(key, fb);
        }
        return this.frameBufferMap.get(key);
    }

    private int getKey(int w, int h) {
        return 31 * h + w;
    }

    public ModelEntityRenderSystem getModelRenderSystem() {
        return this.modelEntityRenderSystem;
    }

    public Map<XrControllerDevice, Entity> getXRControllerToModel() {
        return this.getRenderModeOpenXR().getXRControllerToModel();
    }

    public boolean isCubemapRenderMode() {
        return this.renderMode != null && this.sgrList != null && this.renderMode == this.sgrList[2];
    }
}

