/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.system.render;

import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.utils.IntMap;
import gaiasky.GaiaSky;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.event.IObserver;
import gaiasky.render.RenderGroup;
import gaiasky.render.api.IRenderable;
import gaiasky.render.system.AbstractRenderSystem;
import gaiasky.scene.Mapper;
import gaiasky.scene.camera.ICamera;
import gaiasky.scene.component.Render;
import gaiasky.scene.component.Volume;
import gaiasky.scene.system.render.SceneRenderer;
import gaiasky.scene.system.render.draw.model.ModelEntityRenderSystem;
import gaiasky.util.gdx.IntModelBatch;
import gaiasky.util.gdx.shader.loader.ShaderTemplatingLoader;
import gaiasky.util.gdx.shader.provider.RelativisticShaderProvider;
import java.util.List;

public class VolumeRenderer
extends AbstractRenderSystem
implements IObserver {
    private final ModelEntityRenderSystem renderObject;
    protected final IntMap<IntModelBatch> batches = new IntMap();

    public VolumeRenderer(SceneRenderer sceneRenderer, RenderGroup rg, float[] alphas) {
        super(sceneRenderer, rg, alphas, null);
        this.renderObject = new ModelEntityRenderSystem(sceneRenderer);
        EventManager.instance.subscribe((IObserver)this, Event.SHADER_RELOAD_CMD);
    }

    @Override
    public void renderStud(List<IRenderable> renderables, ICamera camera, double t) {
        if (this.mustRender()) {
            renderables.forEach(r -> {
                Render render = (Render)r;
                Volume volume = (Volume)Mapper.volume.get(render.entity);
                IntModelBatch batch = this.getBatch(volume);
                try {
                    batch.begin((Camera)camera.getCamera());
                    this.renderObject.render(render.entity, batch, camera, this.getAlpha(render.entity), t, this.rc, this.getRenderGroup(), false);
                }
                catch (Exception e) {
                    batch.cancel();
                    throw e;
                }
                batch.end();
            });
        }
    }

    private IntModelBatch getBatch(Volume volume) {
        IntModelBatch batch = (IntModelBatch)this.batches.get(volume.key);
        if (batch == null) {
            String vertexCode = ShaderTemplatingLoader.load(volume.vertexShader);
            String fragmentCode = ShaderTemplatingLoader.load(volume.fragmentShader);
            RelativisticShaderProvider provider = new RelativisticShaderProvider(volume.vertexShader, volume.fragmentShader, vertexCode, fragmentCode);
            batch = new IntModelBatch(provider);
            this.batches.put(volume.key, (Object)batch);
        }
        return batch;
    }

    protected boolean mustRender() {
        return true;
    }

    @Override
    public void notify(Event event, Object source, Object ... data) {
        if (event == Event.SHADER_RELOAD_CMD) {
            GaiaSky.postRunnable(() -> {
                for (IntMap.Entry batch : this.batches) {
                    ((IntModelBatch)batch.value).dispose();
                }
                this.batches.clear();
            });
        }
    }
}

