/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.system.render.draw;

import com.badlogic.ashley.core.Entity;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.VertexAttribute;
import gaiasky.GaiaSky;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.event.IObserver;
import gaiasky.render.RenderGroup;
import gaiasky.render.api.IRenderable;
import gaiasky.render.system.AbstractRenderSystem;
import gaiasky.scene.camera.ICamera;
import gaiasky.scene.component.Render;
import gaiasky.scene.system.render.SceneRenderer;
import gaiasky.scene.system.render.draw.billboard.BillboardEntityRenderSystem;
import gaiasky.scene.view.BillboardView;
import gaiasky.util.Settings;
import gaiasky.util.comp.DistanceEntityComparator;
import gaiasky.util.gdx.mesh.IntMesh;
import gaiasky.util.gdx.shader.ExtShaderProgram;
import java.util.List;

public class BillboardRenderer
extends AbstractRenderSystem
implements IObserver {
    private final BillboardView view;
    private final BillboardEntityRenderSystem renderSystem;
    private IntMesh mesh;
    private Texture billboardTexture;

    public BillboardRenderer(SceneRenderer sceneRenderer, RenderGroup rg, float[] alphas, ExtShaderProgram[] programs, String texturePath, float w, float h, boolean starTextureListener) {
        super(sceneRenderer, rg, alphas, programs);
        this.init(texturePath, w, h, starTextureListener);
        this.view = new BillboardView();
        this.renderSystem = new BillboardEntityRenderSystem();
    }

    public BillboardRenderer(SceneRenderer sceneRenderer, RenderGroup rg, float[] alphas, ExtShaderProgram[] shaderPrograms, String texturePath, boolean starTextureListener) {
        this(sceneRenderer, rg, alphas, shaderPrograms, texturePath, 2.0f, 2.0f, starTextureListener);
    }

    private void init(String tex0, float w, float h, boolean starTextureListener) {
        this.setBillboardTexture(tex0);
        this.comp = new DistanceEntityComparator();
        float[] vertices = new float[20];
        this.fillVertices(vertices, w, h);
        this.mesh = new IntMesh(true, 4, 6, new VertexAttribute[]{new VertexAttribute(1, 2, "a_position"), new VertexAttribute(4, 4, "a_color"), new VertexAttribute(16, 2, "a_texCoord0")});
        this.mesh.setVertices(vertices, 0, vertices.length);
        this.mesh.getIndicesBuffer().position(0);
        this.mesh.getIndicesBuffer().limit(6);
        int[] indices = new int[]{0, 1, 2, 0, 2, 3};
        this.mesh.setIndices(indices);
        if (starTextureListener) {
            EventManager.instance.subscribe((IObserver)this, Event.BILLBOARD_TEXTURE_IDX_CMD);
        }
    }

    public void setBillboardTexture(String texturePath) {
        if (texturePath != null) {
            this.billboardTexture = new Texture(Settings.settings.data.dataFileHandle(texturePath), true);
            this.billboardTexture.setFilter(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear);
        }
    }

    private void fillVertices(float[] vertices, float w, float h) {
        float x = w / 2.0f;
        float y = h / 2.0f;
        float width = -w;
        float height = -h;
        float fx2 = x + width;
        float fy2 = y + height;
        float u = 1.0f;
        float v = 1.0f;
        float u2 = 0.0f;
        float v2 = 0.0f;
        float color = Color.WHITE.toFloatBits();
        int idx = 0;
        vertices[idx++] = x;
        vertices[idx++] = y;
        vertices[idx++] = color;
        vertices[idx++] = 1.0f;
        vertices[idx++] = 1.0f;
        vertices[idx++] = x;
        vertices[idx++] = fy2;
        vertices[idx++] = color;
        vertices[idx++] = 1.0f;
        vertices[idx++] = 0.0f;
        vertices[idx++] = fx2;
        vertices[idx++] = fy2;
        vertices[idx++] = color;
        vertices[idx++] = 0.0f;
        vertices[idx++] = 0.0f;
        vertices[idx++] = fx2;
        vertices[idx++] = y;
        vertices[idx++] = color;
        vertices[idx++] = 0.0f;
        vertices[idx] = 1.0f;
    }

    @Override
    public void renderStud(List<IRenderable> renderables, ICamera camera, double t) {
        renderables.sort(this.comp);
        ExtShaderProgram shaderProgram = this.getShaderProgram();
        shaderProgram.begin();
        if (this.billboardTexture != null) {
            this.billboardTexture.bind(0);
        }
        this.addCameraUpCubemapMode(shaderProgram, camera);
        shaderProgram.setUniformMatrix("u_projView", camera.getCamera().combined);
        shaderProgram.setUniformf("u_time", (float)t);
        this.addEffectsUniforms(shaderProgram, camera);
        renderables.forEach(r -> {
            Entity entity = ((Render)r).entity;
            this.render(entity, shaderProgram, this.mesh, camera);
        });
        shaderProgram.end();
    }

    public void render(Entity entity, ExtShaderProgram shader, IntMesh mesh, ICamera camera) {
        this.view.setEntity(entity);
        float alpha = this.getAlpha(this.view.base.ct);
        this.view.billboard.renderConsumer.apply(this.renderSystem, this.view, Float.valueOf(alpha), shader, mesh, camera);
    }

    @Override
    public void notify(Event event, Object source, Object ... data) {
        if (event == Event.BILLBOARD_TEXTURE_IDX_CMD) {
            GaiaSky.postRunnable(() -> this.setBillboardTexture(Settings.settings.scene.star.getStarTexture()));
        }
    }
}

