/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.system.render.draw;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.TextureArray;
import com.badlogic.gdx.graphics.VertexAttribute;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.utils.Array;
import gaiasky.GaiaSky;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.event.IObserver;
import gaiasky.render.RenderGroup;
import gaiasky.render.api.IRenderable;
import gaiasky.render.system.ImmediateModeRenderSystem;
import gaiasky.render.system.PointCloudTriRenderSystem;
import gaiasky.scene.Mapper;
import gaiasky.scene.api.IParticleRecord;
import gaiasky.scene.camera.ICamera;
import gaiasky.scene.component.AffineTransformations;
import gaiasky.scene.component.Base;
import gaiasky.scene.component.BillboardSet;
import gaiasky.scene.component.Fade;
import gaiasky.scene.component.Render;
import gaiasky.scene.record.BillboardDataset;
import gaiasky.scene.record.ParticleVector;
import gaiasky.scene.system.render.SceneRenderer;
import gaiasky.util.GlobalResources;
import gaiasky.util.Logger;
import gaiasky.util.Settings;
import gaiasky.util.gdx.mesh.IntMesh;
import gaiasky.util.gdx.shader.ExtShaderProgram;
import gaiasky.util.math.MathUtilsDouble;
import gaiasky.util.math.StdRandom;
import gaiasky.util.tree.LoadStatus;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.jafama.FastMath;

public class BillboardSetRenderer
extends PointCloudTriRenderSystem
implements IObserver {
    protected static final Logger.Log logger = Logger.getLogger(BillboardSetRenderer.class);
    private static final String texFolder = "$data/galaxy/sprites/";
    private final Map<Render, MeshDataWrap[]> meshes;
    private final Map<Render, GpuData[]> gpus;
    private final Map<Render, Integer> loadIndices;
    private TextureArray ta;
    private final ColorGenerator starColorGenerator;
    private final ColorGenerator dustColorGenerator;
    private final Matrix4 auxMat = new Matrix4();
    float deg = 0.0f;

    public BillboardSetRenderer(SceneRenderer sceneRenderer, RenderGroup rg, float[] alphas, ExtShaderProgram[] shaders) {
        super(sceneRenderer, rg, alphas, shaders);
        this.starColorGenerator = new StarColorGenerator();
        this.dustColorGenerator = new DustColorGenerator();
        this.meshes = new HashMap<Render, MeshDataWrap[]>();
        this.gpus = new HashMap<Render, GpuData[]>();
        this.loadIndices = new HashMap<Render, Integer>();
        EventManager.instance.subscribe((IObserver)this, Event.GPU_DISPOSE_BILLBOARD_DATASET);
    }

    @Override
    protected void initShaderProgram() {
        for (ExtShaderProgram shaderProgram : this.programs) {
            if (!shaderProgram.isCompiled()) continue;
            shaderProgram.begin();
            shaderProgram.setUniformf("u_pointAlphaMin", 0.1f);
            shaderProgram.setUniformf("u_pointAlphaMax", 1.0f);
            shaderProgram.end();
        }
        this.initializeTextureArray(Settings.settings.graphics.quality);
    }

    private void initializeTextureArray(Settings.GraphicsQuality gq) {
        FileHandle s00 = this.unpack("star-00%#QUAL#%.png", gq);
        FileHandle s01 = this.unpack("star-01%#QUAL#%.png", gq);
        FileHandle d00 = this.unpack("dust-00%#QUAL#%.png", gq);
        FileHandle d01 = this.unpack("dust-01%#QUAL#%.png", gq);
        FileHandle d02 = this.unpack("dust-02%#QUAL#%.png", gq);
        FileHandle d03 = this.unpack("dust-03%#QUAL#%.png", gq);
        FileHandle d04 = this.unpack("dust-04%#QUAL#%.png", gq);
        FileHandle d05 = this.unpack("dust-05%#QUAL#%.png", gq);
        if (this.ta == null) {
            this.ta = new TextureArray(true, Pixmap.Format.RGBA8888, new FileHandle[]{s00, s01, d00, d01, d02, d03, d04, d05});
            this.ta.setFilter(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear);
        }
    }

    private FileHandle unpack(String texName, Settings.GraphicsQuality gq) {
        return Settings.settings.data.dataFileHandle(GlobalResources.unpackAssetPath(texFolder + texName, gq));
    }

    private void disposeTextureArray() {
        if (this.ta != null) {
            this.ta.dispose();
        }
    }

    private void disposeMeshes(Render key) {
        MeshDataWrap[] m;
        if (this.meshes != null && this.meshes.containsKey(key) && (m = this.meshes.get(key)) != null && m.length > 0) {
            for (MeshDataWrap meshDataWrap : m) {
                if (meshDataWrap == null || meshDataWrap.meshData == null) continue;
                meshDataWrap.meshData.dispose();
            }
            this.meshes.remove(key);
            this.gpus.remove(key);
        }
    }

    private void disposeMeshes() {
        Set<Render> keys = this.meshes.keySet();
        for (Render key : keys) {
            this.disposeMeshes(key);
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.disposeMeshes();
        this.disposeTextureArray();
    }

    @Override
    protected void initVertices() {
    }

    private MeshDataWrap toMeshData(GpuData ad, MeshDataWrap mdw) {
        if (ad != null && ad.vertices != null) {
            if (mdw != null && mdw.meshData != null) {
                mdw.meshData.dispose();
            }
            mdw = new MeshDataWrap();
            ImmediateModeRenderSystem.MeshData md = new ImmediateModeRenderSystem.MeshData();
            VertexAttribute[] attributes = this.buildVertexAttributes();
            md.mesh = new IntMesh(true, ad.vertices.length / 6, ad.indices.length, attributes);
            md.vertexSize = md.mesh.getVertexAttributes().vertexSize / 4;
            md.colorOffset = md.mesh.getVertexAttribute(4) != null ? md.mesh.getVertexAttribute((int)4).offset / 4 : 0;
            md.vertexIdx = ad.vertexIdx;
            md.mesh.setVertices(ad.vertices, 0, ad.vertices.length);
            md.mesh.setIndices(ad.indices, 0, ad.indices.length);
            mdw.meshData = md;
            mdw.dataset = ad.dataset;
            ad.vertices = null;
            ad.indices = null;
            return mdw;
        }
        return null;
    }

    private GpuData convertDataToGpu(BillboardDataset bd, ColorGenerator cg) {
        StdRandom.setSeed(11447799L);
        GpuData ad = new GpuData();
        ad.dataset = bd;
        int vertexSize = 11;
        int posOffset = 0;
        int colorOffset = 2;
        int uvOffset = 3;
        int particlePosOffset = 5;
        int additionalOffset = 8;
        float completion = bd.completion == null ? 1.0f : bd.completion[Settings.settings.graphics.quality.ordinal()];
        List<IParticleRecord> data = bd.data;
        ad.vertices = new float[data.size() * vertexSize * 4];
        ad.indices = new int[data.size() * 6];
        int nLayers = bd.layers.length;
        for (IParticleRecord particle : data) {
            if (completion != 1.0f && !(StdRandom.uniform() <= (double)completion)) continue;
            int layer = StdRandom.uniform(nLayers);
            for (int vert = 0; vert < 4; ++vert) {
                float[] fArray;
                ParticleVector pv = (ParticleVector)particle;
                ad.vertices[ad.vertexIdx + posOffset] = ((Float)this.vertPos[vert].getFirst()).floatValue();
                ad.vertices[ad.vertexIdx + posOffset + 1] = ((Float)this.vertPos[vert].getSecond()).floatValue();
                double[] doubleData = pv.data();
                if (doubleData.length >= 7) {
                    float[] fArray2 = new float[3];
                    fArray2[0] = (float)doubleData[4];
                    fArray2[1] = (float)doubleData[5];
                    fArray = fArray2;
                    fArray2[2] = (float)doubleData[6];
                } else {
                    fArray = cg.generateColor();
                }
                float[] col = fArray;
                col[0] = MathUtilsDouble.clamp(col[0], 0.0f, 1.0f);
                col[1] = MathUtilsDouble.clamp(col[1], 0.0f, 1.0f);
                col[2] = MathUtilsDouble.clamp(col[2], 0.0f, 1.0f);
                ad.vertices[ad.vertexIdx + colorOffset] = Color.toFloatBits((float)col[0], (float)col[1], (float)col[2], (float)cg.generateAlpha());
                ad.vertices[ad.vertexIdx + uvOffset] = ((Float)this.vertUV[vert].getFirst()).floatValue();
                ad.vertices[ad.vertexIdx + uvOffset + 1] = ((Float)this.vertUV[vert].getSecond()).floatValue();
                double starSize = particle.size();
                ad.vertices[ad.vertexIdx + additionalOffset] = (float)starSize;
                ad.vertices[ad.vertexIdx + additionalOffset + 1] = bd.type.ordinal();
                ad.vertices[ad.vertexIdx + additionalOffset + 2] = bd.layers[layer];
                int idx = ad.vertexIdx;
                ad.vertices[idx + particlePosOffset] = (float)particle.x();
                ad.vertices[idx + particlePosOffset + 1] = (float)particle.y();
                ad.vertices[idx + particlePosOffset + 2] = (float)particle.z();
                ad.vertexIdx += vertexSize;
                ++ad.numVertices;
            }
            ad.quadIndices();
        }
        return ad;
    }

    private ColorGenerator getColorGenerator(BillboardDataset.ParticleType type) {
        return type == BillboardDataset.ParticleType.DUST ? this.dustColorGenerator : this.starColorGenerator;
    }

    private void convertDataToGpuFormat(Render render, Base base, BillboardSet set) {
        logger.info("Converting billboard data to VRAM format: " + base.getLocalizedName());
        BillboardDataset[] datasets = set.datasets;
        GpuData[] g = new GpuData[datasets.length];
        for (int i = 0; i < g.length; ++i) {
            g[i] = this.convertDataToGpu(datasets[i], this.getColorGenerator(datasets[i].type));
        }
        this.gpus.put(render, g);
    }

    private boolean streamToGpu(Render render, Base base) {
        GpuData[] g = this.gpus.get(render);
        if (g != null) {
            MeshDataWrap[] m;
            int index;
            if (!this.loadIndices.containsKey(render)) {
                this.loadIndices.put(render, 0);
                index = 0;
            } else {
                index = this.loadIndices.get(render) + 1;
                this.loadIndices.put(render, index);
            }
            if (!this.meshes.containsKey(render)) {
                m = new MeshDataWrap[g.length];
                this.meshes.put(render, m);
            } else {
                m = this.meshes.get(render);
            }
            if (index >= m.length) {
                this.gpus.remove(render);
                return true;
            }
            logger.info(String.format("Streaming dataset to GPU (%d/%d): %s", index + 1, m.length, base.getLocalizedName()));
            m[index] = this.toMeshData(g[index], m[index]);
            return false;
        }
        return false;
    }

    @Override
    public void renderStud(List<IRenderable> renderables, ICamera camera, double t) {
        for (IRenderable renderable : renderables) {
            Render render = (Render)renderable;
            Base base = (Base)Mapper.base.get(render.entity);
            BillboardSet set = (BillboardSet)Mapper.billboardSet.get(render.entity);
            switch (set.status.get()) {
                case NOT_LOADED: {
                    set.setStatus(LoadStatus.LOADING);
                    GaiaSky.instance.getExecutorService().execute(() -> {
                        this.convertDataToGpuFormat(render, base, set);
                        set.setStatus(LoadStatus.READY);
                    });
                    break;
                }
                case READY: 
                case PARTIALLY_LOADED: {
                    if (this.streamToGpu(render, base)) {
                        set.setStatus(LoadStatus.LOADED);
                    } else {
                        set.setStatus(LoadStatus.PARTIALLY_LOADED);
                    }
                    this.render(renderable, render, camera);
                    break;
                }
                case LOADED: {
                    this.render(renderable, render, camera);
                }
            }
        }
    }

    private void render(IRenderable renderable, Render render, ICamera camera) {
        float alpha = this.getAlpha(renderable);
        if (alpha > 0.0f) {
            MeshDataWrap[] m;
            Fade fade = (Fade)Mapper.fade.get(render.entity);
            AffineTransformations affine = (AffineTransformations)Mapper.affine.get(render.entity);
            ExtShaderProgram shaderProgram = this.getShaderProgram();
            shaderProgram.begin();
            if (this.ta != null) {
                this.ta.bind(0);
            }
            shaderProgram.setUniformMatrix("u_projView", camera.getCamera().combined);
            shaderProgram.setUniformf("u_camPos", camera.getPos());
            this.addCameraUpCubemapMode(shaderProgram, camera);
            shaderProgram.setUniformf("u_alpha", renderable.getOpacity() * alpha * 1.5f);
            shaderProgram.setUniformf("u_edges", (float)fade.fadeIn.y, (float)fade.fadeOut.y);
            this.addAffineTransformUniforms(shaderProgram, affine);
            this.addEffectsUniforms(shaderProgram, camera);
            int qualityIndex = Settings.settings.graphics.quality.ordinal();
            Gdx.gl20.glEnable(2929);
            Gdx.gl20.glEnable(3042);
            for (MeshDataWrap meshDataWrap : m = this.meshes.get(render)) {
                if (meshDataWrap == null) continue;
                ImmediateModeRenderSystem.MeshData meshData = meshDataWrap.meshData;
                BillboardDataset dataset = meshDataWrap.dataset;
                switch (dataset.blending) {
                    case ALPHA: {
                        Gdx.gl20.glBlendFunc(770, 771);
                        break;
                    }
                    case ADDITIVE: {
                        Gdx.gl20.glBlendFunc(1, 1);
                    }
                }
                Gdx.gl20.glDepthMask(dataset.depthMask);
                double pointScaleFactor = 1.8E7;
                shaderProgram.setUniformf("u_maxPointSize", (float)dataset.maxSizes[qualityIndex]);
                shaderProgram.setUniformf("u_sizeFactor", (float)((double)dataset.size * pointScaleFactor));
                shaderProgram.setUniformf("u_intensity", dataset.intensity);
                meshData.mesh.render(shaderProgram, 4);
            }
            shaderProgram.end();
        }
    }

    @Override
    protected void addVertexAttributes(Array<VertexAttribute> attributes) {
        attributes.add((Object)new VertexAttribute(1, 2, "a_position"));
        attributes.add((Object)new VertexAttribute(4, 4, "a_color"));
        attributes.add((Object)new VertexAttribute(16, 2, "a_texCoord"));
        attributes.add((Object)new VertexAttribute(8192, 3, "a_particlePos"));
        attributes.add((Object)new VertexAttribute(20000, 3, "a_additional"));
    }

    @Override
    protected void offsets(ImmediateModeRenderSystem.MeshData curr) {
    }

    @Override
    public void notify(Event event, Object source, Object ... data) {
        if (event == Event.GPU_DISPOSE_BILLBOARD_DATASET && source instanceof Render) {
            this.disposeMeshes((Render)source);
        }
    }

    private static class StarColorGenerator
    implements ColorGenerator {
        private StarColorGenerator() {
        }

        @Override
        public float[] generateColor() {
            float r = (float)StdRandom.gaussian() * 0.15f;
            if (StdRandom.uniform(2) == 0) {
                return new float[]{0.95f - r, 0.8f - r, 0.6f};
            }
            return new float[]{0.95f, 0.8f - r, 0.6f - r};
        }

        @Override
        public float generateAlpha() {
            return 1.0f;
        }
    }

    private static interface ColorGenerator {
        public float[] generateColor();

        public float generateAlpha();
    }

    private static class DustColorGenerator
    implements ColorGenerator {
        private DustColorGenerator() {
        }

        @Override
        public float[] generateColor() {
            float r = (float)FastMath.abs((double)(StdRandom.uniform() * 0.2 + 0.07));
            return new float[]{r, r, r};
        }

        @Override
        public float generateAlpha() {
            return 0.6f;
        }
    }

    private static class MeshDataWrap {
        public ImmediateModeRenderSystem.MeshData meshData;
        public BillboardDataset dataset;

        private MeshDataWrap() {
        }
    }

    private static class GpuData {
        float[] vertices;
        int[] indices;
        int vertexIdx;
        int indexIdx;
        int numVertices;
        BillboardDataset dataset;

        private GpuData() {
        }

        public void quadIndices() {
            this.index(this.numVertices - 4);
            this.index(this.numVertices - 3);
            this.index(this.numVertices - 2);
            this.index(this.numVertices - 2);
            this.index(this.numVertices - 1);
            this.index(this.numVertices - 4);
        }

        private void index(int idx) {
            this.indices[this.indexIdx++] = idx;
        }
    }
}

