/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.system.render.draw;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.VertexAttribute;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.Array;
import gaiasky.GaiaSky;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.event.IObserver;
import gaiasky.render.RenderGroup;
import gaiasky.render.api.IRenderable;
import gaiasky.render.system.ImmediateModeRenderSystem;
import gaiasky.render.system.PointCloudTriRenderSystem;
import gaiasky.scene.Mapper;
import gaiasky.scene.camera.ICamera;
import gaiasky.scene.component.Base;
import gaiasky.scene.component.RefSysTransform;
import gaiasky.scene.component.Render;
import gaiasky.scene.component.Trajectory;
import gaiasky.scene.record.OrbitComponent;
import gaiasky.scene.system.render.SceneRenderer;
import gaiasky.util.Constants;
import gaiasky.util.Logger;
import gaiasky.util.Settings;
import gaiasky.util.coord.AstroUtils;
import gaiasky.util.gdx.shader.ExtShaderProgram;
import gaiasky.util.math.Matrix4D;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.jafama.FastMath;

public class ElementsRenderer
extends PointCloudTriRenderSystem
implements IObserver {
    protected static final Logger.Log logger = Logger.getLogger(ElementsRenderer.class);
    private final Vector3 aux1;
    private final Matrix4 maux;
    private final Matrix4 refSysTransformF;
    private int posOffset;
    private int uvOffset;
    private int elems01Offset;
    private int elems02Offset;
    private int sizeOffset;
    private int textureIndexOffset;
    private boolean forceAdd = false;
    private final double[] particleSizeLimits = new double[]{Math.tan(Math.toRadians(0.05)), FastMath.tan((double)Math.toRadians(1.0))};

    public ElementsRenderer(SceneRenderer sceneRenderer, RenderGroup rg, float[] alphas, ExtShaderProgram[] shaders) {
        super(sceneRenderer, rg, alphas, shaders);
        this.aux1 = new Vector3();
        this.maux = new Matrix4();
        this.refSysTransformF = new Matrix4();
        EventManager.instance.subscribe((IObserver)this, Event.GPU_DISPOSE_ORBITAL_ELEMENTS);
    }

    @Override
    protected void addVertexAttributes(Array<VertexAttribute> attributes) {
        attributes.add((Object)new VertexAttribute(1, 2, "a_position"));
        attributes.add((Object)new VertexAttribute(16, 2, "a_texCoord"));
        attributes.add((Object)new VertexAttribute(4, 4, "a_color"));
        attributes.add((Object)new VertexAttribute(21000, 4, "a_orbitelems01"));
        attributes.add((Object)new VertexAttribute(22000, 4, "a_orbitelems02"));
        attributes.add((Object)new VertexAttribute(512, 1, "a_size"));
        attributes.add((Object)new VertexAttribute(612, 1, "a_textureIndex"));
    }

    @Override
    protected void offsets(ImmediateModeRenderSystem.MeshData curr) {
        this.posOffset = curr.mesh.getVertexAttribute(1) != null ? curr.mesh.getVertexAttribute((int)1).offset / 4 : 0;
        this.uvOffset = curr.mesh.getVertexAttribute(16) != null ? curr.mesh.getVertexAttribute((int)16).offset / 4 : 0;
        curr.colorOffset = curr.mesh.getVertexAttribute(4) != null ? curr.mesh.getVertexAttribute((int)4).offset / 4 : 0;
        this.elems01Offset = curr.mesh.getVertexAttribute(21000) != null ? curr.mesh.getVertexAttribute((int)21000).offset / 4 : 0;
        this.elems02Offset = curr.mesh.getVertexAttribute(22000) != null ? curr.mesh.getVertexAttribute((int)22000).offset / 4 : 0;
        this.sizeOffset = curr.mesh.getVertexAttribute(512) != null ? curr.mesh.getVertexAttribute((int)512).offset / 4 : 0;
        this.textureIndexOffset = curr.mesh.getVertexAttribute(612) != null ? curr.mesh.getVertexAttribute((int)612).offset / 4 : 0;
    }

    @Override
    public void renderStud(List<IRenderable> renderables, ICamera camera, double t) {
        int n = renderables.size();
        if (n > 0 && renderables.get(0).getOpacity() > 0.0f) {
            Render first = (Render)renderables.get(0);
            Base base = (Base)Mapper.base.get(first.entity);
            if (this.forceAdd || !this.inGpu(first)) {
                this.forceAdd = false;
                this.curr = (ImmediateModeRenderSystem.MeshData)this.meshes.get(this.addMeshData(n * 4, n * 6));
                this.ensureTempVertsSize(n * 4 * this.curr.vertexSize);
                this.ensureTempIndicesSize(n * 6);
                AtomicInteger numVerticesAdded = new AtomicInteger(0);
                AtomicInteger numParticlesAdded = new AtomicInteger(0);
                renderables.forEach(renderable -> {
                    Render render = (Render)renderable;
                    if (!this.inGpu(render)) {
                        Trajectory trajectory = (Trajectory)Mapper.trajectory.get(render.entity);
                        if (trajectory.bodyRepresentation.isBody()) {
                            OrbitComponent oc = trajectory.oc;
                            for (int vert = 0; vert < 4; ++vert) {
                                this.tempVerts[this.curr.vertexIdx + this.posOffset] = ((Float)this.vertPos[vert].getFirst()).floatValue();
                                this.tempVerts[this.curr.vertexIdx + this.posOffset + 1] = ((Float)this.vertPos[vert].getSecond()).floatValue();
                                this.tempVerts[this.curr.vertexIdx + this.uvOffset] = ((Float)this.vertUV[vert].getFirst()).floatValue();
                                this.tempVerts[this.curr.vertexIdx + this.uvOffset + 1] = ((Float)this.vertUV[vert].getSecond()).floatValue();
                                this.tempVerts[this.curr.vertexIdx + this.curr.colorOffset] = Color.toFloatBits((float)trajectory.bodyColor[0], (float)trajectory.bodyColor[1], (float)trajectory.bodyColor[2], (float)trajectory.bodyColor[3]);
                                this.tempVerts[this.curr.vertexIdx + this.elems01Offset] = (float)FastMath.sqrt((double)(oc.mu / FastMath.pow((double)(oc.semiMajorAxis * 1000.0), (double)3.0)));
                                this.tempVerts[this.curr.vertexIdx + this.elems01Offset + 1] = (float)oc.epoch;
                                this.tempVerts[this.curr.vertexIdx + this.elems01Offset + 2] = (float)(oc.semiMajorAxis * 1000.0);
                                this.tempVerts[this.curr.vertexIdx + this.elems01Offset + 3] = (float)oc.e;
                                this.tempVerts[this.curr.vertexIdx + this.elems02Offset] = (float)(oc.i * (Math.PI / 180));
                                this.tempVerts[this.curr.vertexIdx + this.elems02Offset + 1] = (float)(oc.ascendingNode * (Math.PI / 180));
                                this.tempVerts[this.curr.vertexIdx + this.elems02Offset + 2] = (float)(oc.argOfPericenter * (Math.PI / 180));
                                this.tempVerts[this.curr.vertexIdx + this.elems02Offset + 3] = (float)(oc.meanAnomaly * (Math.PI / 180));
                                this.tempVerts[this.curr.vertexIdx + this.sizeOffset] = trajectory.pointSize;
                                this.tempVerts[this.curr.vertexIdx + this.textureIndexOffset] = -1.0f;
                                this.curr.vertexIdx += this.curr.vertexSize;
                                ++this.curr.numVertices;
                                numVerticesAdded.incrementAndGet();
                            }
                            this.quadIndices(this.curr);
                            numParticlesAdded.incrementAndGet();
                            this.setInGpu(render, true);
                        }
                    }
                });
                int count = numVerticesAdded.get() * this.curr.vertexSize;
                this.curr.mesh.setVertices(this.tempVerts, 0, count);
                this.curr.mesh.setIndices(this.tempIndices, 0, numParticlesAdded.get() * 6);
            }
            if (this.curr != null) {
                Matrix4D refSysTransform;
                ExtShaderProgram shaderProgram = this.getShaderProgram();
                shaderProgram.begin();
                shaderProgram.setUniformMatrix("u_projView", camera.getCamera().combined);
                shaderProgram.setUniformf("u_camPos", camera.getPos());
                this.addCameraUpCubemapMode(shaderProgram, camera);
                shaderProgram.setUniformf("u_alpha", this.alphas[base.ct.getFirstOrdinal()] * first.getOpacity());
                shaderProgram.setUniformf("u_falloff", 2.5f);
                shaderProgram.setUniformf("u_sizeFactor", Settings.settings.scene.star.pointSize * 0.08f);
                shaderProgram.setUniformf("u_sizeLimits", (float)this.particleSizeLimits[0], (float)this.particleSizeLimits[1]);
                shaderProgram.setUniformf("u_vrScale", (float)Constants.DISTANCE_SCALE_FACTOR);
                double curRt = AstroUtils.getJulianDate(GaiaSky.instance.time.getTime());
                float curRt1 = (float)curRt;
                float curRt2 = (float)(curRt - (double)curRt1);
                shaderProgram.setUniformf("u_t", curRt1, curRt2);
                RefSysTransform trans = (RefSysTransform)Mapper.transform.get(first.entity);
                Trajectory trajectory = (Trajectory)Mapper.trajectory.get(first.entity);
                Matrix4D matrix4D = refSysTransform = trans.matrix != null ? trans.matrix : null;
                if (refSysTransform != null) {
                    if (trajectory.model.isExtrasolar()) {
                        refSysTransform.putIn(this.maux).inv();
                        this.refSysTransformF.setToRotation(0.0f, 1.0f, 0.0f, -90.0f).mul(this.maux);
                    } else {
                        refSysTransform.putIn(this.refSysTransformF).inv();
                    }
                }
                shaderProgram.setUniformMatrix("u_refSysTransform", this.refSysTransformF);
                this.addEffectsUniforms(shaderProgram, camera);
                try {
                    this.curr.mesh.render(shaderProgram, 4);
                }
                catch (IllegalArgumentException e) {
                    logger.error(e, "Render exception");
                }
                shaderProgram.end();
            }
        }
    }

    public void reset() {
        this.clearMeshes();
        this.curr = null;
        this.forceAdd = true;
    }

    @Override
    public void notify(Event event, Object source, Object ... data) {
        if (event.equals((Object)Event.GPU_DISPOSE_ORBITAL_ELEMENTS) && source instanceof Render) {
            GaiaSky.postRunnable(this::reset);
        }
    }
}

