/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.system.render.draw;

import com.badlogic.ashley.core.Entity;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.math.Vector3;
import gaiasky.render.RenderGroup;
import gaiasky.render.api.ILineRenderable;
import gaiasky.render.api.IRenderable;
import gaiasky.render.system.ImmediateModeRenderSystem;
import gaiasky.render.system.LineRenderSystem;
import gaiasky.scene.Mapper;
import gaiasky.scene.camera.ICamera;
import gaiasky.scene.component.Render;
import gaiasky.scene.component.Verts;
import gaiasky.scene.system.render.SceneRenderer;
import gaiasky.scene.view.LineView;
import gaiasky.util.Logger;
import gaiasky.util.Settings;
import gaiasky.util.gdx.shader.ExtShaderProgram;
import java.util.List;

public class LinePrimitiveRenderer
extends LineRenderSystem {
    protected static final Logger.Log logger = Logger.getLogger(LinePrimitiveRenderer.class);
    protected ICamera camera;
    protected Vector3 aux2;
    protected LineView view = new LineView();
    protected ExtShaderProgram shaderProgram;

    public LinePrimitiveRenderer(SceneRenderer sceneRenderer, RenderGroup rg, float[] alphas, ExtShaderProgram[] shaders) {
        super(sceneRenderer, rg, alphas, shaders);
        this.aux2 = new Vector3();
    }

    @Override
    public void renderStud(List<IRenderable> renderables, ICamera camera, double t) {
        this.shaderProgram = this.getShaderProgram();
        this.shaderProgram.begin();
        this.shaderProgram.setUniformMatrix("u_projView", camera.getCamera().combined);
        this.shaderProgram.setUniformf("u_alpha", 1.0f);
        this.addEffectsUniforms(this.shaderProgram, camera);
        this.camera = camera;
        renderables.forEach(r -> {
            Render render = (Render)r;
            this.view.setEntity(render.entity);
            this.view.render(this, camera, this.getAlpha(render));
            Gdx.gl.glLineWidth(this.view.getLineWidth() * 1.5f * Settings.settings.scene.renderer.line.width * camera.getFovFactor() + Settings.settings.scene.renderer.line.glWidthBias);
            for (int md = 0; md < this.meshIdx; ++md) {
                ImmediateModeRenderSystem.MeshData meshDouble = (ImmediateModeRenderSystem.MeshData)this.meshes.get(md);
                meshDouble.mesh.setVertices(meshDouble.vertices, 0, meshDouble.vertexIdx);
                meshDouble.mesh.render(this.shaderProgram, this.getGLPrimitive(render));
                meshDouble.clear();
            }
        });
        this.shaderProgram.end();
        this.meshIdx = 1;
        this.curr = (ImmediateModeRenderSystem.MeshData)this.meshes.get(0);
    }

    protected int getGLPrimitive(Render r) {
        if (Mapper.verts.has(r.entity)) {
            return ((Verts)Mapper.verts.get((Entity)r.entity)).glPrimitive;
        }
        return 1;
    }

    public void addLine(ILineRenderable lr, double x0, double y0, double z0, double x1, double y1, double z1, double r0, double g0, double b0, double a0, double r1, double g1, double b1, double a1) {
        this.addLinePostproc(x0, y0, z0, x1, y1, z1, r0, g0, b0, a0, r1, g1, b1, a1);
    }
}

