/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.system.render.draw;

import gaiasky.render.RenderGroup;
import gaiasky.render.api.IRenderable;
import gaiasky.render.system.ImmediateModeRenderSystem;
import gaiasky.scene.camera.ICamera;
import gaiasky.scene.component.Render;
import gaiasky.scene.system.render.SceneRenderer;
import gaiasky.scene.system.render.draw.LinePrimitiveRenderer;
import gaiasky.util.Logger;
import gaiasky.util.Settings;
import gaiasky.util.gdx.shader.ExtShaderProgram;
import gaiasky.util.tree.OctreeNode;
import java.util.List;
import net.jafama.FastMath;

public class LineQuadstripRenderer
extends LinePrimitiveRenderer {
    protected static final Logger.Log logger = Logger.getLogger(LinePrimitiveRenderer.class);
    static final double baseWidthAngle = FastMath.toRadians((double)0.13);
    static final double baseWidthAngleTan = FastMath.tan((double)baseWidthAngle);
    protected ICamera camera;

    public LineQuadstripRenderer(SceneRenderer sceneRenderer, RenderGroup rg, float[] alphas, ExtShaderProgram[] shaders) {
        super(sceneRenderer, rg, alphas, shaders);
    }

    @Override
    public void renderStud(List<IRenderable> renderables, ICamera camera, double t) {
        this.shaderProgram = this.getShaderProgram();
        this.shaderProgram.begin();
        this.shaderProgram.setUniformMatrix("u_projView", camera.getCamera().combined);
        this.shaderProgram.setUniformf("u_alpha", 1.0f);
        this.addEffectsUniforms(this.shaderProgram, camera);
        this.camera = camera;
        renderables.forEach(r -> {
            int primitive = 1;
            if (r instanceof Render) {
                Render render = (Render)r;
                this.view.setEntity(render.entity);
                this.view.render(this, camera, this.getAlpha(render));
                primitive = this.getGLPrimitive(render);
            } else if (r instanceof OctreeNode) {
                OctreeNode octant = (OctreeNode)r;
                octant.render(this, camera, this.getAlpha(octant));
            }
            this.shaderProgram.setUniformf("u_lineWidthTan", (float)((double)(this.view.getLineWidth() * 0.8f) * baseWidthAngleTan * (double)Settings.settings.scene.renderer.line.width * (double)camera.getFovFactor()));
            for (int md = 0; md < this.meshIdx; ++md) {
                ImmediateModeRenderSystem.MeshData meshDouble = (ImmediateModeRenderSystem.MeshData)this.meshes.get(md);
                meshDouble.mesh.setVertices(meshDouble.vertices, 0, meshDouble.vertexIdx);
                meshDouble.mesh.render(this.shaderProgram, primitive);
                meshDouble.clear();
            }
        });
        this.shaderProgram.end();
        this.meshIdx = 1;
        this.curr = (ImmediateModeRenderSystem.MeshData)this.meshes.get(0);
    }
}

