/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.system.render.draw;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Camera;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.event.IObserver;
import gaiasky.render.RenderGroup;
import gaiasky.render.api.IRenderable;
import gaiasky.render.system.AbstractRenderSystem;
import gaiasky.scene.Mapper;
import gaiasky.scene.camera.ICamera;
import gaiasky.scene.component.Render;
import gaiasky.scene.system.render.SceneRenderer;
import gaiasky.scene.system.render.draw.model.ModelEntityRenderSystem;
import gaiasky.util.gdx.IntModelBatch;
import gaiasky.util.gdx.shader.provider.RelativisticShaderProvider;
import java.util.List;

public class ModelRenderer
extends AbstractRenderSystem
implements IObserver {
    private final ModelEntityRenderSystem renderObject;
    protected IntModelBatch batch;

    public ModelRenderer(SceneRenderer sceneRenderer, RenderGroup rg, float[] alphas, IntModelBatch batch) {
        super(sceneRenderer, rg, alphas, null);
        this.batch = batch;
        this.renderObject = new ModelEntityRenderSystem(sceneRenderer);
        EventManager.instance.subscribe((IObserver)this, Event.SHADER_RELOAD_CMD);
    }

    @Override
    public void renderStud(List<IRenderable> renderables, ICamera camera, double t) {
        if (this.mustRender()) {
            this.batch.begin((Camera)camera.getCamera());
            try {
                renderables.forEach(r -> {
                    Render render = (Render)r;
                    this.renderObject.render(render.entity, this.batch, camera, this.getAlpha(render.entity), t, this.rc, this.getRenderGroup(), !Mapper.tagBillboard.has(render.entity));
                });
            }
            catch (Exception e) {
                this.batch.cancel();
                throw e;
            }
            this.batch.end();
        }
    }

    protected boolean mustRender() {
        return true;
    }

    @Override
    public void notify(Event event, Object source, Object ... data) {
        if (event == Event.SHADER_RELOAD_CMD && this.batch != null && this.getRenderGroup() == RenderGroup.MODEL_VERT_STAR) {
            this.batch.dispose();
            RelativisticShaderProvider shaderProvider = new RelativisticShaderProvider(Gdx.files.internal("shader/starsurface.vertex.glsl"), Gdx.files.internal("shader/starsurface.fragment.glsl"));
            this.batch = new IntModelBatch(shaderProvider);
        }
    }
}

