/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.system.render.draw;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.VertexAttribute;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.Array;
import gaiasky.render.ComponentTypes;
import gaiasky.render.RenderGroup;
import gaiasky.render.RenderingContext;
import gaiasky.render.api.IRenderable;
import gaiasky.render.system.AbstractRenderSystem;
import gaiasky.render.system.ImmediateModeRenderSystem;
import gaiasky.scene.camera.ICamera;
import gaiasky.scene.system.render.SceneRenderer;
import gaiasky.util.Constants;
import gaiasky.util.Settings;
import gaiasky.util.gdx.mesh.IntMesh;
import gaiasky.util.gdx.shader.ExtShaderProgram;
import gaiasky.util.math.MathUtilsDouble;
import gaiasky.util.math.Vector3D;
import gaiasky.util.math.Vector3Q;
import java.util.List;
import java.util.Random;
import net.jafama.FastMath;

public class ParticleEffectsRenderer
extends ImmediateModeRenderSystem {
    private static final int N_PARTICLES = (Settings.settings.graphics.quality.ordinal() + 1) * 100;
    private final Random rand;
    private final Vector3D aux1 = new Vector3D();
    private final Vector3D aux2 = new Vector3D();
    private final Vector3D aux5 = new Vector3D();
    private final Vector3Q aux1b = new Vector3Q();
    private final ComponentTypes ct;
    private final Vector3[] positions;
    private final Vector3[] additional;
    private final Vector3D[] camPositions;
    private final long baseTime;
    private int sizeOffset;
    private int tOffset;

    public ParticleEffectsRenderer(SceneRenderer sceneRenderer, RenderGroup rg, float[] alphas, ExtShaderProgram[] programs) {
        super(sceneRenderer, rg, alphas, programs);
        this.rand = new Random(123L);
        this.baseTime = System.currentTimeMillis();
        this.ct = new ComponentTypes(ComponentTypes.ComponentType.valueOf("Effects"));
        this.positions = new Vector3[N_PARTICLES * 2];
        this.additional = new Vector3[N_PARTICLES * 2];
        this.camPositions = new Vector3D[N_PARTICLES];
        float colFade = Color.toFloatBits((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        float ctm = (float)System.currentTimeMillis() / 1000.0f;
        for (int i = 0; i < N_PARTICLES * 2; ++i) {
            if (i % 2 == 0) {
                this.positions[i] = new Vector3((float)((double)this.rand.nextFloat() * Constants.PC_TO_U), 0.0f, (float)((double)this.rand.nextFloat() * Constants.PC_TO_U));
                this.additional[i] = new Vector3(Color.toFloatBits((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f), (float)(3 + this.rand.nextInt() % 8), ctm);
                this.camPositions[i / 2] = new Vector3D();
                continue;
            }
            this.positions[i] = new Vector3(this.positions[i - 1]);
            this.additional[i] = new Vector3(colFade, this.additional[i - 1].y, ctm);
        }
    }

    private float getT() {
        return (float)((double)(System.currentTimeMillis() - this.baseTime) / 1000.0);
    }

    @Override
    protected void initShaderProgram() {
        Gdx.gl.glEnable(2848);
        Gdx.gl.glHint(3154, 4354);
        this.getShaderProgram().begin();
        this.getShaderProgram().setUniformf("u_ttl", 1.0f);
        this.getShaderProgram().end();
    }

    private double getFactor(double cspeed) {
        if (cspeed <= 0.4) {
            return 1.0;
        }
        if (cspeed <= 1.0) {
            return MathUtilsDouble.flint(cspeed, 0.4, 1.0, 1.0, 0.5);
        }
        if (cspeed <= 2.0) {
            return MathUtilsDouble.flint(cspeed, 1.0, 2.0, 0.5, 0.3);
        }
        if (cspeed <= 3.0) {
            return 0.3;
        }
        return MathUtilsDouble.flint(cspeed, 3.0, 5.0, 0.3, 0.1);
    }

    private void updatePositions(ICamera cam) {
        double tu = cam.getCurrent().speedScaling();
        double distLimit = 3500000.0 * tu * Constants.KM_TO_U * this.getFactor(Settings.settings.scene.camera.speed);
        double dist = distLimit * 0.8;
        distLimit *= distLimit;
        if (cam.getMode().isFocus()) {
            double cutDistKm;
            double distToSol = cam.getFocus().getAbsolutePosition(this.aux1b).lenDouble() * Constants.U_TO_KM;
            double focusDistKm = cam.getFocus().getDistToCamera() * Constants.U_TO_KM;
            if (focusDistKm < (cutDistKm = 1.171415E16 + -1.17141499999981E16 / (1.0 + FastMath.pow((double)(distToSol / 9.330226999999999E19), (double)1.541734)))) {
                return;
            }
        }
        Vector3D campos = this.aux1.set(cam.getPos());
        for (int i = 0; i < N_PARTICLES * 2; ++i) {
            Vector3D pos = this.aux5.set(this.positions[i]);
            if (i % 2 == 0) {
                if (!(pos.dst2(campos) > distLimit)) continue;
                pos.set(this.rand.nextDouble() - 0.5, this.rand.nextDouble() - 0.5, this.rand.nextDouble() - 0.5).scl(dist).add(campos);
                pos.put(this.positions[i]);
                this.additional[i].z = this.getT();
                this.camPositions[i / 2].set(campos);
                continue;
            }
            Vector3D prev_campos = this.camPositions[(i - 1) / 2];
            Vector3D camdiff = this.aux2.set(campos).sub(prev_campos);
            pos.set(this.positions[i - 1]).add(camdiff);
            pos.put(this.positions[i]);
        }
    }

    @Override
    protected void initVertices() {
        this.meshes = new Array();
        this.addMeshData(N_PARTICLES * 2);
    }

    private void addMeshData(int nVertices) {
        int mdi = this.createMeshData();
        this.curr = (ImmediateModeRenderSystem.MeshData)this.meshes.get(mdi);
        VertexAttribute[] attributes = this.buildVertexAttributes();
        this.curr.mesh = new IntMesh(false, nVertices, 0, attributes);
        this.curr.vertices = new float[nVertices * (this.curr.mesh.getVertexAttributes().vertexSize / 4)];
        this.curr.vertexSize = this.curr.mesh.getVertexAttributes().vertexSize / 4;
        this.curr.colorOffset = this.curr.mesh.getVertexAttribute(4) != null ? this.curr.mesh.getVertexAttribute((int)4).offset / 4 : 0;
        this.sizeOffset = this.curr.mesh.getVertexAttribute(32) != null ? this.curr.mesh.getVertexAttribute((int)32).offset / 4 : 0;
        this.tOffset = this.curr.mesh.getVertexAttribute(128) != null ? this.curr.mesh.getVertexAttribute((int)128).offset / 4 : 0;
    }

    protected VertexAttribute[] buildVertexAttributes() {
        Array attributes = new Array();
        attributes.add((Object)new VertexAttribute(1, 3, "a_position"));
        attributes.add((Object)new VertexAttribute(4, 4, "a_color"));
        attributes.add((Object)new VertexAttribute(32, 1, "a_size"));
        attributes.add((Object)new VertexAttribute(128, 1, "a_t"));
        VertexAttribute[] array = new VertexAttribute[attributes.size];
        for (int i = 0; i < attributes.size; ++i) {
            array[i] = (VertexAttribute)attributes.get(i);
        }
        return array;
    }

    @Override
    public void render(List<IRenderable> renderables, ICamera camera, double t, RenderingContext rc) {
        this.rc = rc;
        this.run((Array<AbstractRenderSystem.RenderSystemRunnable>)this.preRunners, renderables, camera);
        this.renderStud(renderables, camera, t);
        this.run((Array<AbstractRenderSystem.RenderSystemRunnable>)this.postRunners, renderables, camera);
    }

    @Override
    public void renderStud(List<IRenderable> renderables, ICamera camera, double t) {
        float alpha = this.getAlpha(this.ct);
        if (alpha > 0.0f) {
            this.updatePositions(camera);
            Gdx.gl.glLineWidth(2.0f + Settings.settings.scene.renderer.line.glWidthBias);
            if (this.curr != null) {
                this.curr.vertexIdx = 0;
                this.curr.numVertices = N_PARTICLES * 2;
                for (int i = 0; i < N_PARTICLES * 2; ++i) {
                    this.curr.vertices[this.curr.vertexIdx + this.curr.colorOffset] = this.additional[i].x;
                    this.curr.vertices[this.curr.vertexIdx + this.sizeOffset] = this.additional[i].y;
                    this.curr.vertices[this.curr.vertexIdx + this.tOffset] = this.additional[i].z;
                    this.curr.vertices[this.curr.vertexIdx] = this.positions[i].x;
                    this.curr.vertices[this.curr.vertexIdx + 1] = this.positions[i].y;
                    this.curr.vertices[this.curr.vertexIdx + 2] = this.positions[i].z;
                    this.curr.vertexIdx += this.curr.vertexSize;
                }
                ExtShaderProgram shaderProgram = this.getShaderProgram();
                shaderProgram.begin();
                shaderProgram.setUniformMatrix("u_projView", camera.getCamera().combined);
                shaderProgram.setUniformf("u_camPos", camera.getCurrent().getPos());
                shaderProgram.setUniformf("u_alpha", alpha * 0.6f);
                shaderProgram.setUniformf("u_sizeFactor", this.rc.scaleFactor);
                shaderProgram.setUniformf("u_t", this.getT());
                shaderProgram.setUniformf("u_ttl", 0.5f);
                this.addEffectsUniforms(shaderProgram, camera);
                this.curr.mesh.setVertices(this.curr.vertices, 0, N_PARTICLES * 2 * this.curr.vertexSize);
                this.curr.mesh.render(shaderProgram, 1);
                shaderProgram.end();
            }
        }
    }
}

