/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.system.render.draw;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.VertexAttribute;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.utils.Array;
import gaiasky.GaiaSky;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.event.IObserver;
import gaiasky.render.RenderGroup;
import gaiasky.render.api.IRenderable;
import gaiasky.render.system.ImmediateModeRenderSystem;
import gaiasky.render.system.InstancedRenderSystem;
import gaiasky.scene.Mapper;
import gaiasky.scene.api.IParticleRecord;
import gaiasky.scene.camera.ICamera;
import gaiasky.scene.component.AffineTransformations;
import gaiasky.scene.component.Base;
import gaiasky.scene.component.Body;
import gaiasky.scene.component.DatasetDescription;
import gaiasky.scene.component.Highlight;
import gaiasky.scene.component.ParticleSet;
import gaiasky.scene.component.Render;
import gaiasky.scene.system.render.SceneRenderer;
import gaiasky.util.Constants;
import gaiasky.util.Logger;
import gaiasky.util.Settings;
import gaiasky.util.color.Colormap;
import gaiasky.util.coord.AstroUtils;
import gaiasky.util.gdx.shader.ExtShaderProgram;
import gaiasky.util.math.StdRandom;
import gaiasky.util.parse.Parser;
import java.util.Random;
import net.jafama.FastMath;

public class ParticleSetInstancedRenderer
extends InstancedRenderSystem
implements IObserver {
    protected static final Logger.Log logger = Logger.getLogger(ParticleSetInstancedRenderer.class);
    private final boolean extended;
    private final Random rand;
    private final Colormap cmap;

    public ParticleSetInstancedRenderer(SceneRenderer sceneRenderer, RenderGroup rg, float[] alphas, ExtShaderProgram[] shaders) {
        super(sceneRenderer, rg, alphas, shaders);
        this.extended = rg.toString().contains("PARTICLE_GROUP_EXT");
        this.rand = new Random(123L);
        this.cmap = new Colormap();
        EventManager.instance.subscribe((IObserver)this, Event.GPU_DISPOSE_PARTICLE_GROUP);
    }

    @Override
    protected void addAttributesDivisor1(Array<VertexAttribute> attributes, int primitive) {
        attributes.add((Object)new VertexAttribute(4, 4, "a_color"));
        attributes.add((Object)new VertexAttribute(8192, 3, "a_particlePos"));
        if (this.extended) {
            attributes.add((Object)new VertexAttribute(16384, 3, "a_pm"));
        }
        attributes.add((Object)new VertexAttribute(512, 1, "a_size"));
        attributes.add((Object)new VertexAttribute(612, 1, "a_textureIndex"));
    }

    @Override
    protected void offsets0(ImmediateModeRenderSystem.MeshData curr, InstancedRenderSystem.InstancedModel model) {
    }

    @Override
    protected void offsets1(ImmediateModeRenderSystem.MeshData curr, InstancedRenderSystem.InstancedModel model) {
        curr.colorOffset = curr.mesh.getInstancedAttribute(4) != null ? curr.mesh.getInstancedAttribute((int)4).offset / 4 : 0;
        model.sizeOffset = curr.mesh.getInstancedAttribute(512) != null ? curr.mesh.getInstancedAttribute((int)512).offset / 4 : 0;
        model.textureIndexOffset = curr.mesh.getInstancedAttribute(612) != null ? curr.mesh.getInstancedAttribute((int)612).offset / 4 : 0;
        int n = model.particlePosOffset = curr.mesh.getInstancedAttribute(8192) != null ? curr.mesh.getInstancedAttribute((int)8192).offset / 4 : 0;
        if (this.extended) {
            model.properMotionOffset = curr.mesh.getInstancedAttribute(16384) != null ? curr.mesh.getInstancedAttribute((int)16384).offset / 4 : 0;
        }
    }

    @Override
    protected void preRenderObjects(ExtShaderProgram shaderProgram, ICamera camera) {
        shaderProgram.setUniformMatrix("u_projView", camera.getCamera().combined);
        shaderProgram.setUniformf("u_camPos", camera.getPos());
        this.addMotionTrailsUniforms(shaderProgram, camera);
        this.addCameraUpCubemapMode(shaderProgram, camera);
        this.addEffectsUniforms(shaderProgram, camera);
    }

    @Override
    protected void renderObject(ExtShaderProgram shaderProgram, IRenderable renderable) {
        Render render = (Render)renderable;
        Base base = (Base)Mapper.base.get(render.entity);
        Body body = (Body)Mapper.body.get(render.entity);
        ParticleSet set = (ParticleSet)Mapper.particleSet.get(render.entity);
        Highlight hl = (Highlight)Mapper.highlight.get(render.entity);
        DatasetDescription desc = (DatasetDescription)Mapper.datasetDescription.get(render.entity);
        float sizeFactor = this.utils.getDatasetSizeFactor(render.entity, hl, desc);
        if (!set.disposed) {
            int offset;
            boolean hlCmap = hl.isHighlighted() && !hl.isHlplain();
            int n = set.pointData.size();
            InstancedRenderSystem.InstancedModel model = this.getModel(set, this.getOffset(render));
            if (!this.inGpu(render)) {
                offset = this.addMeshData(model, model.numVertices, n, model.numIndices, set.modelFile, set.modelType, set.modelPrimitive);
                this.setModel(offset, model);
                this.setOffset(render, offset);
                this.curr = (ImmediateModeRenderSystem.MeshData)this.meshes.get(offset);
                model.ensureInstanceAttribsSize(n * this.curr.instanceSize);
                float[] c = this.utils.getColor(body, hl);
                float[] colorMin = set.getColorMin();
                float[] colorMax = set.getColorMax();
                double minDistance = set.getMinDistance();
                double maxDistance = set.getMaxDistance();
                int numParticlesAdded = 0;
                for (int i = 0; i < n; ++i) {
                    if (!this.utils.filter(i, set, desc) || !set.isVisible(i)) continue;
                    IParticleRecord particle = set.get(i);
                    double x = particle.x();
                    double y = particle.y();
                    double z = particle.z();
                    model.instanceAttributes[this.curr.instanceIdx + model.sizeOffset] = this.extended && particle.hasSize() ? particle.size() : body.size + (float)(this.rand.nextGaussian() * (double)body.size / 5.0);
                    float textureIndex = -1.0f;
                    if (set.textureArray != null && !set.isWireframe()) {
                        int nTextures = set.textureArray.getDepth();
                        if (set.textureAttribute != null && particle.hasExtra(set.textureAttribute)) {
                            Object value = particle.getExtra(set.textureAttribute);
                            if (value instanceof Number) {
                                Number num = (Number)value;
                                textureIndex = MathUtils.clamp((int)(num.intValue() - 1), (int)0, (int)(nTextures - 1));
                            } else if (value instanceof String) {
                                String str = (String)value;
                                try {
                                    textureIndex = MathUtils.clamp((int)((int)Parser.parseDoubleException(str) - 1), (int)0, (int)(nTextures - 1));
                                }
                                catch (NumberFormatException ignored) {
                                    textureIndex = value.hashCode() % nTextures;
                                }
                            } else {
                                textureIndex = value.hashCode() % nTextures;
                            }
                        } else {
                            textureIndex = this.rand.nextInt(nTextures);
                        }
                    }
                    model.instanceAttributes[this.curr.instanceIdx + model.textureIndexOffset] = textureIndex;
                    if (hl.isHighlighted()) {
                        if (hlCmap) {
                            double[] color = this.cmap.colormap(hl.getHlcmi(), hl.getHlcma().getNumber(particle), hl.getHlcmmin(), hl.getHlcmmax());
                            model.instanceAttributes[this.curr.instanceIdx + this.curr.colorOffset] = Color.toFloatBits((float)((float)color[0]), (float)((float)color[1]), (float)((float)color[2]), (float)hl.getHlcmAlpha());
                        } else {
                            model.instanceAttributes[this.curr.instanceIdx + this.curr.colorOffset] = Color.toFloatBits((float)c[0], (float)c[1], (float)c[2], (float)c[3]);
                        }
                    } else if (this.extended && particle.hasColor() && Float.isFinite(particle.color())) {
                        model.instanceAttributes[this.curr.instanceIdx + this.curr.colorOffset] = particle.color();
                    } else if (set.colorFromTexture && set.textureArray != null && textureIndex >= 0.0f) {
                        float r = 0.0f;
                        float g = 0.0f;
                        float b = 0.0f;
                        if (set.colorNoise != 0.0f) {
                            StdRandom.setSeed((long)textureIndex);
                            r = (float)((StdRandom.uniform() - 0.5) * 2.0 * (double)set.colorNoise);
                            g = (float)((StdRandom.uniform() - 0.5) * 2.0 * (double)set.colorNoise);
                            b = (float)((StdRandom.uniform() - 0.5) * 2.0 * (double)set.colorNoise);
                        }
                        model.instanceAttributes[this.curr.instanceIdx + this.curr.colorOffset] = Color.toFloatBits((float)MathUtils.clamp((float)(c[0] + r), (float)0.0f, (float)1.0f), (float)MathUtils.clamp((float)(c[1] + g), (float)0.0f, (float)1.0f), (float)MathUtils.clamp((float)(c[2] + b), (float)0.0f, (float)1.0f), (float)MathUtils.clamp((float)c[3], (float)0.0f, (float)1.0f));
                    } else {
                        if (colorMin != null && colorMax != null) {
                            double dist = FastMath.sqrt((double)(x * x + y * y + z * z));
                            double fac = (dist - minDistance) / (maxDistance - minDistance);
                            this.interpolateColor(colorMin, colorMax, c, fac);
                        }
                        float r = 0.0f;
                        float g = 0.0f;
                        float b = 0.0f;
                        if (set.colorNoise != 0.0f) {
                            r = (float)((StdRandom.uniform() - 0.5) * 2.0 * (double)set.colorNoise);
                            g = (float)((StdRandom.uniform() - 0.5) * 2.0 * (double)set.colorNoise);
                            b = (float)((StdRandom.uniform() - 0.5) * 2.0 * (double)set.colorNoise);
                        }
                        model.instanceAttributes[this.curr.instanceIdx + this.curr.colorOffset] = Color.toFloatBits((float)MathUtils.clamp((float)(c[0] + r), (float)0.0f, (float)1.0f), (float)MathUtils.clamp((float)(c[1] + g), (float)0.0f, (float)1.0f), (float)MathUtils.clamp((float)(c[2] + b), (float)0.0f, (float)1.0f), (float)MathUtils.clamp((float)c[3], (float)0.0f, (float)1.0f));
                    }
                    model.instanceAttributes[this.curr.instanceIdx + model.particlePosOffset] = (float)x;
                    model.instanceAttributes[this.curr.instanceIdx + model.particlePosOffset + 1] = (float)y;
                    model.instanceAttributes[this.curr.instanceIdx + model.particlePosOffset + 2] = (float)z;
                    if (this.extended) {
                        if (particle.hasProperMotion()) {
                            model.instanceAttributes[this.curr.instanceIdx + model.properMotionOffset] = particle.vx();
                            model.instanceAttributes[this.curr.instanceIdx + model.properMotionOffset + 1] = particle.vy();
                            model.instanceAttributes[this.curr.instanceIdx + model.properMotionOffset + 2] = particle.vz();
                        } else {
                            model.instanceAttributes[this.curr.instanceIdx + model.properMotionOffset] = 0.0f;
                            model.instanceAttributes[this.curr.instanceIdx + model.properMotionOffset + 1] = 0.0f;
                            model.instanceAttributes[this.curr.instanceIdx + model.properMotionOffset + 2] = 0.0f;
                        }
                    }
                    this.curr.instanceIdx += this.curr.instanceSize;
                    ++this.curr.numVertices;
                    ++numParticlesAdded;
                }
                this.curr.mesh.setVertices(model.vertices, 0, model.numVertices * model.modelVertexSize);
                if (model.numIndices > 0) {
                    this.curr.mesh.setIndices(model.indices, 0, model.numIndices);
                }
                int count = numParticlesAdded * this.curr.instanceSize;
                this.setCount(render, numParticlesAdded);
                this.curr.mesh.setInstanceAttribs(model.instanceAttributes, 0, count);
                model.instanceAttributes = null;
                this.setInGpu(render, true);
            }
            offset = this.getOffset(render);
            this.curr = (ImmediateModeRenderSystem.MeshData)this.meshes.get(offset);
            if (this.curr != null) {
                if (set.textureArray != null && !set.isWireframe()) {
                    set.textureArray.bind(0);
                }
                if (this.extended) {
                    double curRt = AstroUtils.getDaysSince(GaiaSky.instance.time.getTime(), set.epochJd);
                    float curRt2 = (float)(curRt - (double)((float)curRt));
                    shaderProgram.setUniformf("u_t", (float)curRt, curRt2);
                }
                shaderProgram.setUniformf("u_appTime", (float)GaiaSky.instance.getRunTimeSeconds());
                shaderProgram.setUniformi("u_shadingStyle", set.shadingStyle.ordinal());
                float meanDist = (float)set.getMeanDistance();
                shaderProgram.setUniformf("u_alpha", this.alphas[base.ct.getFirstOrdinal()] * base.opacity);
                shaderProgram.setUniformf("u_falloff", set.profileDecay);
                shaderProgram.setUniformf("u_sizeLimits", (float)(set.particleSizeLimits[0] * (double)sizeFactor), (float)(set.particleSizeLimits[1] * (double)sizeFactor));
                if (this.extended) {
                    shaderProgram.setUniformf("u_sizeFactor", (float)((double)sizeFactor / Constants.DISTANCE_SCALE_FACTOR));
                } else {
                    double s = 3.0E-5f;
                    shaderProgram.setUniformf("u_sizeFactor", (float)((double)Settings.SceneSettings.StarSettings.getStarPointSize() * s * (double)sizeFactor * (double)meanDist / Constants.DISTANCE_SCALE_FACTOR));
                }
                shaderProgram.setUniformf("u_proximityThreshold", (float)set.proximityThreshold);
                this.addAffineTransformUniforms(shaderProgram, (AffineTransformations)Mapper.affine.get(render.entity));
                if (!set.allowStreaks) {
                    shaderProgram.setUniformf("u_camVel", 0.0f, 0.0f, 0.0f);
                }
                try {
                    Gdx.gl30.glEnable(2884);
                    Gdx.gl30.glCullFace(1029);
                    int count = this.curr.mesh.getNumIndices() > 0 ? this.curr.mesh.getNumIndices() : this.curr.mesh.getNumVertices();
                    this.curr.mesh.render(shaderProgram, set.modelPrimitive, 0, count, this.getCount(render));
                    Gdx.gl30.glDisable(2884);
                }
                catch (IllegalArgumentException e) {
                    logger.error(e, "Render exception");
                }
            }
        } else {
            throw new RuntimeException("No suitable model found for type '" + set.modelType + "' and primitive '" + set.modelPrimitive + "'");
        }
    }

    private void interpolateColor(float[] c0, float[] c1, float[] result, double factor) {
        float f = (float)factor;
        result[0] = (1.0f - f) * c0[0] + f * c1[0];
        result[1] = (1.0f - f) * c0[1] + f * c1[1];
        result[2] = (1.0f - f) * c0[2] + f * c1[2];
        result[3] = (1.0f - f) * c0[3] + f * c1[3];
    }

    @Override
    protected void setInGpu(IRenderable renderable, boolean state) {
        if (this.inGpu != null) {
            if (this.inGpu.contains(renderable) && !state) {
                EventManager.publish(Event.GPU_DISPOSE_PARTICLE_GROUP, renderable, new Object[0]);
            }
            super.setInGpu(renderable, state);
        }
    }

    @Override
    public void notify(Event event, Object source, Object ... data) {
        if (event == Event.GPU_DISPOSE_PARTICLE_GROUP) {
            IRenderable renderable = (IRenderable)source;
            int offset = this.getOffset(renderable);
            if (offset >= 0) {
                this.clearMeshData(offset);
                this.models.set(offset, null);
            }
            if (this.inGpu != null) {
                this.inGpu.remove(renderable);
            }
        }
    }
}

