/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.system.render.draw;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.VertexAttribute;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.utils.Array;
import gaiasky.GaiaSky;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.event.IObserver;
import gaiasky.render.RenderGroup;
import gaiasky.render.api.IRenderable;
import gaiasky.render.system.ImmediateModeRenderSystem;
import gaiasky.scene.Mapper;
import gaiasky.scene.api.IParticleRecord;
import gaiasky.scene.camera.ICamera;
import gaiasky.scene.component.AffineTransformations;
import gaiasky.scene.component.Base;
import gaiasky.scene.component.Body;
import gaiasky.scene.component.DatasetDescription;
import gaiasky.scene.component.Highlight;
import gaiasky.scene.component.ParticleSet;
import gaiasky.scene.component.Render;
import gaiasky.scene.entity.ParticleUtils;
import gaiasky.scene.system.render.SceneRenderer;
import gaiasky.scene.system.render.draw.PointCloudRenderer;
import gaiasky.util.Constants;
import gaiasky.util.Settings;
import gaiasky.util.color.Colormap;
import gaiasky.util.gdx.shader.ExtShaderProgram;
import gaiasky.util.math.StdRandom;
import gaiasky.util.parse.Parser;
import java.util.Random;
import net.jafama.FastMath;

public class ParticleSetPointRenderer
extends PointCloudRenderer
implements IObserver {
    private final Random rand;
    private final Colormap cmap;
    private final ParticleUtils utils = new ParticleUtils();
    private int additionalOffset;
    private int textureIndexOffset;
    private ICamera camera;
    private boolean stereoHalfWidth;

    public ParticleSetPointRenderer(SceneRenderer sceneRenderer, RenderGroup rg, float[] alphas, ExtShaderProgram[] shaders) {
        super(sceneRenderer, rg, alphas, shaders);
        this.cmap = new Colormap();
        this.rand = new Random(123L);
        EventManager.instance.subscribe((IObserver)this, Event.GPU_DISPOSE_PARTICLE_GROUP);
    }

    @Override
    protected void initShaderProgram() {
        Gdx.gl.glEnable(34370);
    }

    @Override
    protected void offsets(ImmediateModeRenderSystem.MeshData curr) {
        curr.colorOffset = curr.mesh.getVertexAttribute(4) != null ? curr.mesh.getVertexAttribute((int)4).offset / 4 : 0;
        this.additionalOffset = curr.mesh.getVertexAttribute(20000) != null ? curr.mesh.getVertexAttribute((int)20000).offset / 4 : 0;
        this.textureIndexOffset = curr.mesh.getVertexAttribute(612) != null ? curr.mesh.getVertexAttribute((int)612).offset / 4 : 0;
    }

    @Override
    protected void addVertexAttributes(Array<VertexAttribute> attributes) {
        attributes.add((Object)new VertexAttribute(1, 3, "a_position"));
        attributes.add((Object)new VertexAttribute(4, 4, "a_color"));
        attributes.add((Object)new VertexAttribute(20000, 2, "a_additional"));
        attributes.add((Object)new VertexAttribute(612, 1, "a_textureIndex"));
    }

    @Override
    protected void preRenderObjects(ExtShaderProgram shaderProgram, ICamera camera) {
        this.stereoHalfWidth = Settings.settings.program.modeStereo.isStereoHalfWidth();
        this.camera = camera;
        shaderProgram.setUniformMatrix("u_projView", camera.getCamera().combined);
        shaderProgram.setUniformf("u_ar", this.stereoHalfWidth ? 2.0f : 1.0f);
        shaderProgram.setUniformf("u_camPos", camera.getCurrent().getPos());
        shaderProgram.setUniformf("u_camDir", camera.getCurrent().getCamera().direction);
        shaderProgram.setUniformi("u_cubemap", Settings.settings.program.modeCubemap.active ? 1 : 0);
        this.addEffectsUniforms(shaderProgram, camera);
    }

    @Override
    protected void renderObject(ExtShaderProgram shaderProgram, IRenderable renderable) {
        Render render = (Render)renderable;
        Base base = (Base)Mapper.base.get(render.entity);
        Body body = (Body)Mapper.body.get(render.entity);
        ParticleSet set = (ParticleSet)Mapper.particleSet.get(render.entity);
        Highlight hl = (Highlight)Mapper.highlight.get(render.entity);
        DatasetDescription desc = (DatasetDescription)Mapper.datasetDescription.get(render.entity);
        float sizeFactor = this.utils.getDatasetSizeFactor(render.entity, hl, desc);
        if (!set.disposed) {
            boolean hlCmap;
            boolean bl = hlCmap = hl.isHighlighted() && !hl.isHlplain();
            if (!this.inGpu(render)) {
                int offset = this.addMeshData(set.pointData.size());
                this.setOffset(render, offset);
                this.curr = (ImmediateModeRenderSystem.MeshData)this.meshes.get(offset);
                float[] c = this.utils.getColor(body, hl);
                float[] colorMin = set.getColorMin();
                float[] colorMax = set.getColorMax();
                double minDistance = set.getMinDistance();
                double maxDistance = set.getMaxDistance();
                this.ensureTempVertsSize(set.pointData.size() * this.curr.vertexSize);
                int n = set.pointData.size();
                int numAdded = 0;
                for (int i = 0; i < n; ++i) {
                    if (!this.utils.filter(i, set, desc) || !set.isVisible(i)) continue;
                    IParticleRecord pb = set.get(i);
                    double x = pb.x();
                    double y = pb.y();
                    double z = pb.z();
                    this.tempVerts[this.curr.vertexIdx + this.additionalOffset] = (body.size + (float)(this.rand.nextGaussian() * (double)body.size / 5.0)) * sizeFactor * (float)Constants.DISTANCE_SCALE_FACTOR;
                    float textureIndex = -1.0f;
                    if (set.textureArray != null) {
                        int nTextures = set.textureArray.getDepth();
                        if (set.textureAttribute != null && pb.hasExtra(set.textureAttribute)) {
                            Object value = pb.getExtra(set.textureAttribute);
                            if (value instanceof Number) {
                                Number num = (Number)value;
                                textureIndex = MathUtils.clamp((int)(num.intValue() - 1), (int)0, (int)(nTextures - 1));
                            } else if (value instanceof String) {
                                String str = (String)value;
                                try {
                                    textureIndex = MathUtils.clamp((int)((int)Parser.parseDoubleException(str) - 1), (int)0, (int)(nTextures - 1));
                                }
                                catch (NumberFormatException ignored) {
                                    textureIndex = value.hashCode() % nTextures;
                                }
                            } else {
                                textureIndex = value.hashCode() % nTextures;
                            }
                        } else {
                            textureIndex = this.rand.nextInt(nTextures);
                        }
                    }
                    this.tempVerts[this.curr.vertexIdx + this.textureIndexOffset] = textureIndex;
                    if (hl.isHighlighted()) {
                        if (hlCmap) {
                            double[] color = this.cmap.colormap(hl.getHlcmi(), hl.getHlcma().getNumber(pb), hl.getHlcmmin(), hl.getHlcmmax());
                            this.tempVerts[this.curr.vertexIdx + this.curr.colorOffset] = Color.toFloatBits((float)((float)color[0]), (float)((float)color[1]), (float)((float)color[2]), (float)hl.getHlcmAlpha());
                        } else {
                            this.tempVerts[this.curr.vertexIdx + this.curr.colorOffset] = Color.toFloatBits((float)c[0], (float)c[1], (float)c[2], (float)c[3]);
                        }
                    } else if (set.colorFromTexture && set.textureArray != null && textureIndex >= 0.0f) {
                        float r = 0.0f;
                        float g = 0.0f;
                        float b = 0.0f;
                        if (set.colorNoise != 0.0f) {
                            StdRandom.setSeed((long)textureIndex);
                            r = (float)((StdRandom.uniform() - 0.5) * 2.0 * (double)set.colorNoise);
                            g = (float)((StdRandom.uniform() - 0.5) * 2.0 * (double)set.colorNoise);
                            b = (float)((StdRandom.uniform() - 0.5) * 2.0 * (double)set.colorNoise);
                        }
                        this.tempVerts[this.curr.vertexIdx + this.curr.colorOffset] = Color.toFloatBits((float)MathUtils.clamp((float)(c[0] + r), (float)0.0f, (float)1.0f), (float)MathUtils.clamp((float)(c[1] + g), (float)0.0f, (float)1.0f), (float)MathUtils.clamp((float)(c[2] + b), (float)0.0f, (float)1.0f), (float)MathUtils.clamp((float)c[3], (float)0.0f, (float)1.0f));
                    } else {
                        if (colorMin != null && colorMax != null) {
                            double dist = FastMath.sqrt((double)(x * x + y * y + z * z));
                            double fac = (dist - minDistance) / (maxDistance - minDistance);
                            this.interpolateColor(colorMin, colorMax, c, fac);
                        }
                        float r = 0.0f;
                        float g = 0.0f;
                        float b = 0.0f;
                        if (set.colorNoise != 0.0f) {
                            r = (float)((StdRandom.uniform() - 0.5) * 2.0 * (double)set.colorNoise);
                            g = (float)((StdRandom.uniform() - 0.5) * 2.0 * (double)set.colorNoise);
                            b = (float)((StdRandom.uniform() - 0.5) * 2.0 * (double)set.colorNoise);
                        }
                        this.tempVerts[this.curr.vertexIdx + this.curr.colorOffset] = Color.toFloatBits((float)MathUtils.clamp((float)(c[0] + r), (float)0.0f, (float)1.0f), (float)MathUtils.clamp((float)(c[1] + g), (float)0.0f, (float)1.0f), (float)MathUtils.clamp((float)(c[2] + b), (float)0.0f, (float)1.0f), (float)MathUtils.clamp((float)c[3], (float)0.0f, (float)1.0f));
                    }
                    int idx = this.curr.vertexIdx;
                    this.tempVerts[idx] = (float)x;
                    this.tempVerts[idx + 1] = (float)y;
                    this.tempVerts[idx + 2] = (float)z;
                    this.curr.vertexIdx += this.curr.vertexSize;
                    ++numAdded;
                }
                int count = numAdded * this.curr.vertexSize;
                this.setCount(render, count);
                this.curr.mesh.setVertices(this.tempVerts, 0, count);
                this.setInGpu(render, true);
            }
            this.curr = (ImmediateModeRenderSystem.MeshData)this.meshes.get(this.getOffset(render));
            if (this.curr != null) {
                if (set.textureArray != null) {
                    set.textureArray.bind(0);
                }
                shaderProgram.setUniformf("u_appTime", (float)GaiaSky.instance.getRunTimeSeconds());
                shaderProgram.setUniformi("u_shadingStyle", set.shadingStyle.ordinal());
                float meanDist = (float)set.getMeanDistance();
                shaderProgram.setUniformf("u_alpha", this.alphas[base.ct.getFirstOrdinal()] * base.opacity);
                shaderProgram.setUniformf("u_falloff", set.profileDecay);
                shaderProgram.setUniformf("u_sizeFactor", (float)((this.stereoHalfWidth ? 2.0 : 1.0) * (double)this.rc.scaleFactor * (double)Settings.SceneSettings.StarSettings.getStarPointSize() * 0.3 * (double)sizeFactor * (double)meanDist / ((double)this.camera.getFovFactor() * Constants.DISTANCE_SCALE_FACTOR)));
                shaderProgram.setUniformf("u_sizeLimits", (float)(set.particleSizeLimitsPoint[0] / (double)this.camera.getFovFactor()), (float)(set.particleSizeLimitsPoint[1] / (double)this.camera.getFovFactor()));
                shaderProgram.setUniformf("u_proximityThreshold", (float)set.proximityThreshold);
                this.addAffineTransformUniforms(shaderProgram, (AffineTransformations)Mapper.affine.get(render.entity));
                this.curr.mesh.render(shaderProgram, ShapeRenderer.ShapeType.Point.getGlType());
            }
        }
    }

    private void interpolateColor(float[] c0, float[] c1, float[] result, double factor) {
        float f = (float)factor;
        result[0] = (1.0f - f) * c0[0] + f * c1[0];
        result[1] = (1.0f - f) * c0[1] + f * c1[1];
        result[2] = (1.0f - f) * c0[2] + f * c1[2];
        result[3] = (1.0f - f) * c0[3] + f * c1[3];
    }

    @Override
    protected void setInGpu(IRenderable renderable, boolean state) {
        if (this.inGpu != null) {
            if (this.inGpu.contains(renderable) && !state) {
                EventManager.publish(Event.GPU_DISPOSE_PARTICLE_GROUP, renderable, new Object[0]);
            }
            if (state) {
                this.inGpu.add(renderable);
            } else {
                this.inGpu.remove(renderable);
            }
        }
    }

    @Override
    public void notify(Event event, Object source, Object ... data) {
        if (event == Event.GPU_DISPOSE_PARTICLE_GROUP) {
            IRenderable renderable = (IRenderable)source;
            int offset = this.getOffset(renderable);
            this.clearMeshData(offset);
            this.inGpu.remove(renderable);
        }
    }
}

