/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.system.render.draw;

import com.badlogic.ashley.core.Entity;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.VertexAttribute;
import com.badlogic.gdx.utils.Array;
import gaiasky.data.util.PointCloudData;
import gaiasky.render.RenderGroup;
import gaiasky.render.api.IPointRenderable;
import gaiasky.render.api.IRenderable;
import gaiasky.render.system.ImmediateModeRenderSystem;
import gaiasky.scene.Mapper;
import gaiasky.scene.camera.ICamera;
import gaiasky.scene.component.Body;
import gaiasky.scene.component.GraphNode;
import gaiasky.scene.component.Render;
import gaiasky.scene.component.Verts;
import gaiasky.scene.system.render.SceneRenderer;
import gaiasky.scene.view.PointView;
import gaiasky.util.Logger;
import gaiasky.util.gdx.mesh.IntMesh;
import gaiasky.util.gdx.shader.ExtShaderProgram;
import gaiasky.util.math.Vector3D;
import java.util.List;

public class PointPrimitiveRenderSystem
extends ImmediateModeRenderSystem {
    protected static final Logger.Log logger = Logger.getLogger(PointPrimitiveRenderSystem.class);
    private final PointView pointView;
    private final int glType;
    private int sizeOffset;
    private final Vector3D D31 = new Vector3D();

    public PointPrimitiveRenderSystem(SceneRenderer sceneRenderer, RenderGroup rg, float[] alphas, ExtShaderProgram[] shaders) {
        super(sceneRenderer, rg, alphas, shaders);
        this.pointView = new PointView();
        this.glType = 0;
    }

    @Override
    protected void initShaderProgram() {
        Gdx.gl.glEnable(34370);
    }

    @Override
    protected void initVertices() {
        this.meshes = new Array();
        this.initVertices(this.meshIdx++);
    }

    private void initVertices(int index) {
        if (index >= this.meshes.size) {
            this.meshes.setSize(index + 1);
        }
        if (this.meshes.get(index) == null) {
            if (index > 0) {
                logger.info("Capacity too small, creating new meshdata: " + this.curr.capacity);
            }
            this.curr = new ImmediateModeRenderSystem.MeshData();
            this.meshes.set(index, (Object)this.curr);
            this.curr.capacity = 1000;
            VertexAttribute[] attribs = this.buildVertexAttributes();
            this.curr.mesh = new IntMesh(false, this.curr.capacity, 0, attribs);
            this.curr.vertexSize = this.curr.mesh.getVertexAttributes().vertexSize / 4;
            this.curr.vertices = new float[this.curr.capacity * this.curr.vertexSize];
            this.curr.colorOffset = this.curr.mesh.getVertexAttribute(4) != null ? this.curr.mesh.getVertexAttribute((int)4).offset / 4 : 0;
            this.sizeOffset = this.curr.mesh.getVertexAttribute((int)32).offset / 4;
        } else {
            this.curr = (ImmediateModeRenderSystem.MeshData)this.meshes.get(index);
        }
    }

    protected VertexAttribute[] buildVertexAttributes() {
        Array attribs = new Array();
        attribs.add((Object)new VertexAttribute(1, 3, "a_position"));
        attribs.add((Object)new VertexAttribute(4, 4, "a_color"));
        attribs.add((Object)new VertexAttribute(32, 1, "a_size"));
        VertexAttribute[] array = new VertexAttribute[attribs.size];
        for (int i = 0; i < attribs.size; ++i) {
            array[i] = (VertexAttribute)attribs.get(i);
        }
        return array;
    }

    @Override
    public void renderStud(List<IRenderable> renderables, ICamera camera, double t) {
        ExtShaderProgram shaderProgram = this.getShaderProgram();
        shaderProgram.begin();
        shaderProgram.setUniformMatrix("u_projView", camera.getCamera().combined);
        this.addEffectsUniforms(shaderProgram, camera);
        renderables.forEach(r -> {
            Render render = (Render)r;
            this.pointView.setEntity(render.entity);
            this.render(render.entity, this.pointView, this.getAlpha(render.entity));
            this.pointView.blend();
            this.pointView.depth();
            for (int md = 0; md < this.meshIdx; ++md) {
                ImmediateModeRenderSystem.MeshData meshd = (ImmediateModeRenderSystem.MeshData)this.meshes.get(md);
                meshd.mesh.setVertices(meshd.vertices, 0, meshd.vertexIdx);
                meshd.mesh.render(shaderProgram, this.glType);
                meshd.clear();
            }
        });
        shaderProgram.end();
        this.meshIdx = 1;
        this.curr = (ImmediateModeRenderSystem.MeshData)this.meshes.get(0);
    }

    private void render(Entity entity, PointView pointView, float alpha) {
        Body body = (Body)Mapper.body.get(entity);
        Verts verts = (Verts)Mapper.verts.get(entity);
        GraphNode graph = (GraphNode)Mapper.graph.get(entity);
        PointCloudData pointCloudData = verts.pointCloudData;
        float[] cc = body.color;
        Vector3D v = this.D31;
        for (int i = 0; i < pointCloudData.getNumPoints(); ++i) {
            pointCloudData.loadPoint(v, i);
            v.add(graph.translation);
            this.addPoint(pointView, (float)v.x, (float)v.y, (float)v.z, verts.primitiveSize, cc[0], cc[1], cc[2], alpha * cc[3]);
        }
    }

    public void addPoint(IPointRenderable pr, double x, double y, double z, float pointSize, float r, float g, float b, float a) {
        if (this.curr.numVertices + 1 >= this.curr.capacity) {
            this.initVertices(this.meshIdx++);
        }
        this.color(r, g, b, a);
        this.size(pointSize);
        this.vertex((float)x, (float)y, (float)z);
    }

    public void size(float pointSize) {
        this.curr.vertices[this.curr.vertexIdx + this.sizeOffset] = pointSize;
    }
}

