/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.system.render.draw;

import com.badlogic.ashley.core.Entity;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.VertexAttribute;
import com.badlogic.gdx.utils.Array;
import gaiasky.data.util.PointCloudData;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.event.IObserver;
import gaiasky.render.RenderGroup;
import gaiasky.render.api.IGPUVertsRenderable;
import gaiasky.render.api.IRenderable;
import gaiasky.render.system.ImmediateModeRenderSystem;
import gaiasky.scene.Mapper;
import gaiasky.scene.camera.ICamera;
import gaiasky.scene.component.Base;
import gaiasky.scene.component.GraphNode;
import gaiasky.scene.component.Orientation;
import gaiasky.scene.component.Render;
import gaiasky.scene.component.Trajectory;
import gaiasky.scene.component.Verts;
import gaiasky.scene.system.render.SceneRenderer;
import gaiasky.scene.view.VertsView;
import gaiasky.util.Logger;
import gaiasky.util.Settings;
import gaiasky.util.gdx.mesh.IntMesh;
import gaiasky.util.gdx.shader.ExtShaderProgram;
import gaiasky.util.math.Vector3D;
import java.util.List;
import net.jafama.FastMath;

public class PrimitiveVertexRenderSystem<T extends IGPUVertsRenderable>
extends ImmediateModeRenderSystem
implements IObserver {
    protected static final Logger.Log logger = Logger.getLogger(PrimitiveVertexRenderSystem.class);
    static final double baseWidthAngle = FastMath.toRadians((double)0.13);
    static final double baseWidthAngleTan = FastMath.tan((double)baseWidthAngle);
    protected final boolean lines;
    protected final VertsView vertsView;
    protected ICamera camera;
    protected int coordOffset;

    public PrimitiveVertexRenderSystem(SceneRenderer sceneRenderer, RenderGroup rg, float[] alphas, ExtShaderProgram[] shaders, boolean lines) {
        super(sceneRenderer, rg, alphas, shaders);
        this.lines = lines;
        this.vertsView = new VertsView();
        EventManager.instance.subscribe((IObserver)this, Event.GPU_DISPOSE_VERTS_OBJECT);
    }

    public boolean isLine() {
        return this.lines;
    }

    public boolean isPoint() {
        return !this.lines;
    }

    @Override
    protected void initShaderProgram() {
        if (this.isLine()) {
            Gdx.gl.glEnable(2848);
            Gdx.gl.glHint(3154, 4354);
        } else if (this.isPoint()) {
            Gdx.gl.glEnable(34370);
        }
    }

    @Override
    protected void initVertices() {
        this.meshes = new Array();
    }

    private int addMeshData(int nVertices) {
        int mdi = this.createMeshData();
        this.curr = (ImmediateModeRenderSystem.MeshData)this.meshes.get(mdi);
        VertexAttribute[] attributes = this.buildVertexAttributes();
        this.curr.mesh = new IntMesh(true, nVertices, 0, attributes);
        this.curr.vertexSize = this.curr.mesh.getVertexAttributes().vertexSize / 4;
        this.curr.colorOffset = this.curr.mesh.getVertexAttribute(4) != null ? this.curr.mesh.getVertexAttribute((int)4).offset / 4 : 0;
        this.coordOffset = this.curr.mesh.getVertexAttribute(32) != null ? this.curr.mesh.getVertexAttribute((int)32).offset / 4 : 0;
        return mdi;
    }

    @Override
    public void renderStud(List<IRenderable> renderables, ICamera camera, double t) {
        if (this.isLine()) {
            this.initShaderProgram();
        }
        ExtShaderProgram shaderProgram = this.getShaderProgram();
        shaderProgram.begin();
        this.camera = camera;
        renderables.forEach(r -> {
            Trajectory trajectory;
            Render render = (Render)r;
            if (!Mapper.verts.has(render.entity)) {
                logger.error("Can't render entities without a " + Verts.class.getSimpleName() + " component.");
            }
            boolean coordEnabled = (trajectory = (Trajectory)Mapper.trajectory.get(render.entity)) != null && trajectory.orbitTrail;
            this.vertsView.setEntity(render.entity);
            VertsView renderable = this.vertsView;
            if (!this.inGpu(render)) {
                PointCloudData data = renderable.getPointCloud();
                int nPoints = data.getNumPoints();
                if (this.getOffset(render) < 0) {
                    this.setOffset(render, this.addMeshData(nPoints + 10));
                } else {
                    this.curr = (ImmediateModeRenderSystem.MeshData)this.meshes.get(this.getOffset(render));
                    if (this.curr.numVertices < nPoints + 1) {
                        this.curr.clear();
                        this.curr.mesh.dispose();
                        this.meshes.set(this.getOffset(render), null);
                        this.setOffset(render, this.addMeshData(nPoints + 10));
                    } else {
                        this.curr.vertexIdx = 0;
                        this.curr.indexIdx = 0;
                        this.curr.numVertices = 0;
                    }
                }
                boolean hasTime = data.hasTime();
                long t0 = hasTime ? data.getDate(0).getEpochSecond() : 0L;
                long t1 = hasTime ? data.getDate(data.getNumPoints() - 1).getEpochSecond() : 0L;
                long t01 = t1 - t0;
                this.ensureTempVertsSize((nPoints + 1) * this.curr.vertexSize);
                this.curr.vertices = this.tempVerts;
                int numAddedVertices = 0;
                float[] cc = renderable.getColor();
                for (int point_i = 0; point_i < nPoints; ++point_i) {
                    this.coord(!hasTime ? (coordEnabled ? (float)point_i / (float)nPoints : 1.0f) : (float)((double)(data.getDate(point_i).getEpochSecond() - t0) / (double)t01));
                    this.color((double)cc[0], (double)cc[1], (double)cc[2], 1.0);
                    this.vertex((float)data.getX(point_i), (float)data.getY(point_i), (float)data.getZ(point_i));
                    ++numAddedVertices;
                }
                if (renderable.isClosedLoop()) {
                    this.coord(1.0f);
                    this.color((double)cc[0], (double)cc[1], (double)cc[2], 1.0);
                    this.vertex((float)data.getX(0), (float)data.getY(0), (float)data.getZ(0));
                    ++numAddedVertices;
                }
                int count = numAddedVertices * this.curr.vertexSize;
                this.setCount(render, numAddedVertices);
                this.curr.mesh.setVertices(this.curr.vertices, 0, count);
                this.curr.vertices = null;
                this.setInGpu(render, true);
            }
            this.curr = (ImmediateModeRenderSystem.MeshData)this.meshes.get(this.getOffset(render));
            Base base = (Base)Mapper.base.get(render.entity);
            if (this.isLine()) {
                float lw = this.vertsView.getPrimitiveSize() * Settings.settings.scene.renderer.line.width * camera.getFovFactor() + Settings.settings.scene.renderer.line.glWidthBias;
                shaderProgram.setUniformf("u_lineWidthTan", (float)((double)(lw * 0.8f) * baseWidthAngleTan));
                Gdx.gl.glLineWidth(lw * 1.5f);
            } else {
                shaderProgram.setUniformf("u_pointSize", renderable.getPrimitiveSize());
            }
            shaderProgram.setUniformMatrix("u_worldTransform", renderable.getLocalTransform());
            shaderProgram.setUniformMatrix("u_projView", camera.getCamera().combined);
            shaderProgram.setUniformf("u_alpha", (float)renderable.getAlpha() * this.getAlpha(renderable) * base.opacity * 0.6f);
            shaderProgram.setUniformf("u_coordEnabled", coordEnabled ? 1.0f : -1.0f);
            if (trajectory != null && trajectory.body != null) {
                GraphNode bodyGraph = (GraphNode)Mapper.graph.get(trajectory.body);
                shaderProgram.setUniformf("u_bodyPos", bodyGraph.translation.x.floatValue(), bodyGraph.translation.y.floatValue(), bodyGraph.translation.z.floatValue());
            } else {
                shaderProgram.setUniformf("u_bodyPos", Float.NaN, Float.NaN, Float.NaN);
            }
            shaderProgram.setUniformf("u_trailMap", trajectory != null ? trajectory.trailMap : 0.0f);
            shaderProgram.setUniformf("u_trailMinOpacity", trajectory != null ? trajectory.trailMinOpacity : 0.0f);
            shaderProgram.setUniformf("u_coordPos", trajectory != null ? (float)trajectory.coord : 1.0f);
            shaderProgram.setUniformf("u_period", trajectory != null && trajectory.oc != null ? (float)trajectory.oc.period : 0.0f);
            Entity parent = renderable.getParentEntity();
            if (parent != null) {
                Vector3D urp;
                Vector3D vector3D = urp = Mapper.orientation.has(parent) ? ((Orientation)Mapper.orientation.get(parent)).getNonRotatedPos() : null;
                if (urp != null) {
                    shaderProgram.setUniformf("u_parentPos", (float)urp.x, (float)urp.y, (float)urp.z);
                } else {
                    shaderProgram.setUniformf("u_parentPos", 0.0f, 0.0f, 0.0f);
                }
            }
            this.addEffectsUniforms(shaderProgram, camera);
            this.curr.mesh.render(shaderProgram, renderable.getGlPrimitive(), 0, this.getCount(render));
        });
        shaderProgram.end();
    }

    private void coord(float value) {
        this.curr.vertices[this.curr.vertexIdx + this.coordOffset] = value;
    }

    protected VertexAttribute[] buildVertexAttributes() {
        Array attributes = new Array();
        attributes.add((Object)new VertexAttribute(1, 3, "a_position"));
        attributes.add((Object)new VertexAttribute(4, 4, "a_color"));
        attributes.add((Object)new VertexAttribute(32, 1, "a_coord"));
        VertexAttribute[] array = new VertexAttribute[attributes.size];
        for (int i = 0; i < attributes.size; ++i) {
            array[i] = (VertexAttribute)attributes.get(i);
        }
        return array;
    }

    @Override
    public void notify(Event event, Object source, Object ... data) {
        if (event == Event.GPU_DISPOSE_VERTS_OBJECT) {
            IRenderable renderable = (IRenderable)source;
            RenderGroup rg = (RenderGroup)((Object)data[0]);
            if (rg == RenderGroup.LINE_GPU || rg == RenderGroup.POINT_GPU) {
                this.setInGpu(renderable, false);
            }
        }
    }
}

