/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.system.render.draw;

import com.badlogic.ashley.core.Entity;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.VertexAttribute;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.Array;
import gaiasky.GaiaSky;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.event.IObserver;
import gaiasky.render.ComponentTypes;
import gaiasky.render.RenderGroup;
import gaiasky.render.api.IRenderable;
import gaiasky.render.system.ImmediateModeRenderSystem;
import gaiasky.scene.Mapper;
import gaiasky.scene.camera.ICamera;
import gaiasky.scene.component.Base;
import gaiasky.scene.component.Body;
import gaiasky.scene.component.GraphNode;
import gaiasky.scene.component.Render;
import gaiasky.scene.system.render.SceneRenderer;
import gaiasky.scene.system.render.draw.PointCloudQuadRenderer;
import gaiasky.scene.system.render.draw.StarSetQuadComponent;
import gaiasky.scene.view.RenderView;
import gaiasky.util.Logger;
import gaiasky.util.Settings;
import gaiasky.util.coord.AstroUtils;
import gaiasky.util.gdx.shader.ExtShaderProgram;
import java.util.List;

public class SingleStarQuadRenderer
extends PointCloudQuadRenderer
implements IObserver {
    protected static final Logger.Log logger = Logger.getLogger(SingleStarQuadRenderer.class);
    private final RenderView view;
    private final Vector3 aux1 = new Vector3();
    private final ComponentTypes.ComponentType ct;
    boolean initializing;
    private int sizeOffset;
    private int pmOffset;
    private int uvOffset;
    private int starPosOffset;
    private StarSetQuadComponent triComponent;

    public SingleStarQuadRenderer(SceneRenderer sceneRenderer, RenderGroup rg, float[] alphas, ExtShaderProgram[] shaders, ComponentTypes.ComponentType ct) {
        super(sceneRenderer, rg, alphas, shaders);
        this.view = new RenderView();
        this.ct = ct;
        this.triComponent.setStarTexture(Settings.settings.scene.star.getStarTexture());
        this.initializing = true;
        this.addMeshData(2000, 3000);
        EventManager.instance.subscribe((IObserver)this, Event.STAR_BRIGHTNESS_CMD, Event.STAR_BRIGHTNESS_POW_CMD, Event.STAR_POINT_SIZE_CMD, Event.STAR_BASE_LEVEL_CMD, Event.BILLBOARD_TEXTURE_IDX_CMD);
    }

    @Override
    protected void addVertexAttributes(Array<VertexAttribute> attributes) {
        attributes.add((Object)new VertexAttribute(1, 2, "a_position"));
        attributes.add((Object)new VertexAttribute(16, 2, "a_texCoord"));
        attributes.add((Object)new VertexAttribute(4, 4, "a_color"));
        attributes.add((Object)new VertexAttribute(8192, 3, "a_starPos"));
        attributes.add((Object)new VertexAttribute(16384, 3, "a_pm"));
        attributes.add((Object)new VertexAttribute(512, 1, "a_size"));
    }

    @Override
    protected void offsets(ImmediateModeRenderSystem.MeshData curr) {
        curr.colorOffset = curr.mesh.getVertexAttribute(4) != null ? curr.mesh.getVertexAttribute((int)4).offset / 4 : 0;
        this.uvOffset = curr.mesh.getVertexAttribute(16) != null ? curr.mesh.getVertexAttribute((int)16).offset / 4 : 0;
        this.pmOffset = curr.mesh.getVertexAttribute(16384) != null ? curr.mesh.getVertexAttribute((int)16384).offset / 4 : 0;
        this.sizeOffset = curr.mesh.getVertexAttribute(512) != null ? curr.mesh.getVertexAttribute((int)512).offset / 4 : 0;
        this.starPosOffset = curr.mesh.getVertexAttribute(8192) != null ? curr.mesh.getVertexAttribute((int)8192).offset / 4 : 0;
    }

    @Override
    protected void initShaderProgram() {
        this.triComponent = new StarSetQuadComponent();
        this.triComponent.initShaderProgram(this.getShaderProgram());
    }

    @Override
    protected void preRenderObjects(ExtShaderProgram shaderProgram, ICamera camera) {
        shaderProgram.setUniformMatrix("u_projView", camera.getCamera().combined);
        shaderProgram.setUniformf("u_camPos", 0.0f, 0.0f, 0.0f);
        this.addEffectsUniforms(shaderProgram, camera);
    }

    @Override
    public void renderStud(List<IRenderable> renderables, ICamera camera, double t) {
        if (!renderables.isEmpty()) {
            ExtShaderProgram shaderProgram = this.getShaderProgram();
            shaderProgram.begin();
            this.preRenderObjects(shaderProgram, camera);
            this.renderObjects(shaderProgram, renderables);
            this.postRenderObjects(shaderProgram, camera);
            shaderProgram.end();
        }
    }

    private void renderObjects(ExtShaderProgram shaderProgram, List<IRenderable> renderables) {
        int n = renderables.size();
        if (n > 0) {
            this.ensureMeshDataSize(n * 4 * this.curr.vertexSize, n * 6);
            this.ensureTempVertsSize(n * 4 * this.curr.vertexSize);
            this.ensureTempIndicesSize(n * 6);
            int numVerticesAdded = 0;
            int numStarsAdded = 0;
            this.curr.clear();
            for (int i = 0; i < n; ++i) {
                Entity entity = ((Render)renderables.get((int)i)).entity;
                this.view.setEntity(entity);
                Base base = (Base)Mapper.base.get(entity);
                Body body = (Body)Mapper.body.get(entity);
                GraphNode graph = (GraphNode)Mapper.graph.get(entity);
                float[] col = body.color;
                for (int vert = 0; vert < 4; ++vert) {
                    this.tempVerts[this.curr.vertexIdx] = ((Float)this.vertPos[vert].getFirst()).floatValue();
                    this.tempVerts[this.curr.vertexIdx + 1] = ((Float)this.vertPos[vert].getSecond()).floatValue();
                    this.tempVerts[this.curr.vertexIdx + this.uvOffset] = ((Float)this.vertUV[vert].getFirst()).floatValue();
                    this.tempVerts[this.curr.vertexIdx + this.uvOffset + 1] = ((Float)this.vertUV[vert].getSecond()).floatValue();
                    this.tempVerts[this.curr.vertexIdx + this.curr.colorOffset] = Color.toFloatBits((float)col[0], (float)col[1], (float)col[2], (float)base.opacity);
                    this.tempVerts[this.curr.vertexIdx + this.sizeOffset] = (float)(this.view.getRadius() * 5.0);
                    graph.translation.put(this.aux1);
                    this.tempVerts[this.curr.vertexIdx + this.starPosOffset] = this.aux1.x;
                    this.tempVerts[this.curr.vertexIdx + this.starPosOffset + 1] = this.aux1.y;
                    this.tempVerts[this.curr.vertexIdx + this.starPosOffset + 2] = this.aux1.z;
                    this.tempVerts[this.curr.vertexIdx + this.pmOffset] = 0.0f;
                    this.tempVerts[this.curr.vertexIdx + this.pmOffset + 1] = 0.0f;
                    this.tempVerts[this.curr.vertexIdx + this.pmOffset + 2] = 0.0f;
                    this.curr.vertexIdx += this.curr.vertexSize;
                    ++this.curr.numVertices;
                    ++numVerticesAdded;
                }
                this.quadIndices(this.curr);
                ++numStarsAdded;
            }
            int count = numVerticesAdded * this.curr.vertexSize;
            this.curr.mesh.setVertices(this.tempVerts, 0, count);
            this.curr.mesh.setIndices(this.tempIndices, 0, numStarsAdded * 6);
            if (this.curr != null) {
                if (this.triComponent.starTex != null) {
                    this.triComponent.starTex.bind(0);
                    shaderProgram.setUniformi("u_starTex", 0);
                }
                this.triComponent.alphaSizeBr[0] = this.alphas[this.ct.ordinal()];
                this.triComponent.alphaSizeBr[1] = this.triComponent.starPointSize * 1000000.0f;
                shaderProgram.setUniform3fv("u_alphaSizeBr", this.triComponent.alphaSizeBr, 0, 3);
                shaderProgram.setUniformf("u_fixedAngularSize", -1.0f);
                double curRt = AstroUtils.getDaysSince(GaiaSky.instance.time.getTime(), AstroUtils.JD_J2015);
                float curRt2 = (float)(curRt - (double)((float)curRt));
                shaderProgram.setUniformf("u_t", (float)curRt, curRt2);
                this.triComponent.setOpacityLimitsUniform(shaderProgram, null);
                try {
                    this.curr.mesh.render(shaderProgram, 4);
                }
                catch (IllegalArgumentException e) {
                    logger.error(e, "Render exception");
                }
            }
        }
    }

    private void ensureMeshDataSize(int numVertices, int numIndices) {
        if (this.curr.mesh.getNumVertices() < numVertices || this.curr.mesh.getNumIndices() < numIndices) {
            this.curr.dispose();
            this.meshes.clear();
            this.addMeshData(numVertices, numIndices);
        }
    }

    @Override
    public void notify(Event event, Object source, Object ... data) {
        switch (event) {
            case STAR_BASE_LEVEL_CMD: {
                this.triComponent.updateStarOpacityLimits(((Float)data[0]).floatValue(), Settings.settings.scene.star.opacity[1]);
                this.triComponent.touchStarParameters(this.getShaderProgram());
                break;
            }
            case STAR_BRIGHTNESS_CMD: {
                this.triComponent.updateStarBrightness(((Float)data[0]).floatValue());
                this.triComponent.touchStarParameters(this.getShaderProgram());
                break;
            }
            case STAR_BRIGHTNESS_POW_CMD: {
                this.triComponent.updateBrightnessPower(((Float)data[0]).floatValue());
                this.triComponent.touchStarParameters(this.getShaderProgram());
                break;
            }
            case STAR_POINT_SIZE_CMD: {
                this.triComponent.updateStarPointSize(((Float)data[0]).floatValue());
                this.triComponent.touchStarParameters(this.getShaderProgram());
                break;
            }
            case BILLBOARD_TEXTURE_IDX_CMD: {
                GaiaSky.postRunnable(() -> this.triComponent.setStarTexture(Settings.settings.scene.star.getStarTexture()));
                break;
            }
        }
    }
}

