/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.system.render.draw;

import com.badlogic.ashley.core.Entity;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import gaiasky.render.RenderGroup;
import gaiasky.render.api.IRenderable;
import gaiasky.render.system.AbstractRenderSystem;
import gaiasky.scene.camera.ICamera;
import gaiasky.scene.component.Render;
import gaiasky.scene.system.render.SceneRenderer;
import gaiasky.scene.system.render.draw.sprite.SpriteEntityRenderSystem;
import java.util.List;

public class SpriteRenderer
extends AbstractRenderSystem {
    private final SpriteEntityRenderSystem renderer;
    private final SpriteBatch batch;

    public SpriteRenderer(SceneRenderer sceneRenderer, RenderGroup rg, float[] alphas, ShaderProgram program) {
        super(sceneRenderer, rg, alphas, null);
        this.batch = new SpriteBatch(50, program);
        this.renderer = new SpriteEntityRenderSystem();
    }

    @Override
    public void renderStud(List<IRenderable> renderables, ICamera camera, double t) {
        this.batch.begin();
        for (IRenderable r : renderables) {
            Entity e = ((Render)r).getEntity();
            float alpha = this.getAlpha(e);
            this.renderer.render(e, this.batch, camera, alpha);
        }
        this.batch.end();
    }
}

