/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.system.render.draw;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.VertexAttribute;
import com.badlogic.gdx.utils.Array;
import gaiasky.GaiaSky;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.event.IObserver;
import gaiasky.render.RenderGroup;
import gaiasky.render.api.IRenderable;
import gaiasky.render.system.ImmediateModeRenderSystem;
import gaiasky.render.system.InstancedRenderSystem;
import gaiasky.scene.Mapper;
import gaiasky.scene.api.IParticleRecord;
import gaiasky.scene.camera.ICamera;
import gaiasky.scene.component.AffineTransformations;
import gaiasky.scene.component.Base;
import gaiasky.scene.component.DatasetDescription;
import gaiasky.scene.component.Highlight;
import gaiasky.scene.component.Render;
import gaiasky.scene.component.StarSet;
import gaiasky.scene.system.render.SceneRenderer;
import gaiasky.scene.system.render.draw.StarSetQuadComponent;
import gaiasky.util.Logger;
import gaiasky.util.Settings;
import gaiasky.util.color.Colormap;
import gaiasky.util.coord.AstroUtils;
import gaiasky.util.gdx.shader.ExtShaderProgram;

public class StarSetInstancedRenderer
extends InstancedRenderSystem
implements IObserver {
    protected static final Logger.Log logger = Logger.getLogger(StarSetInstancedRenderer.class);
    private final Colormap cmap = new Colormap();
    private StarSetQuadComponent triComponent;

    public StarSetInstancedRenderer(SceneRenderer sceneRenderer, RenderGroup rg, float[] alphas, ExtShaderProgram[] shaders) {
        super(sceneRenderer, rg, alphas, shaders);
        this.triComponent.setStarTexture(Settings.settings.scene.star.getStarTexture());
        EventManager.instance.subscribe((IObserver)this, Event.STAR_BRIGHTNESS_CMD, Event.STAR_BRIGHTNESS_POW_CMD, Event.STAR_POINT_SIZE_CMD, Event.STAR_BASE_LEVEL_CMD, Event.BACKBUFFER_SCALE_CMD, Event.FOV_CHANGED_CMD, Event.GPU_DISPOSE_STAR_GROUP, Event.BILLBOARD_TEXTURE_IDX_CMD);
    }

    @Override
    protected void addAttributesDivisor1(Array<VertexAttribute> attributes, int primitive) {
        attributes.add((Object)new VertexAttribute(4, 4, "a_color"));
        attributes.add((Object)new VertexAttribute(8192, 3, "a_starPos"));
        attributes.add((Object)new VertexAttribute(16384, 3, "a_pm"));
        attributes.add((Object)new VertexAttribute(512, 1, "a_size"));
    }

    @Override
    protected void offsets0(ImmediateModeRenderSystem.MeshData curr, InstancedRenderSystem.InstancedModel model) {
    }

    @Override
    protected void offsets1(ImmediateModeRenderSystem.MeshData curr, InstancedRenderSystem.InstancedModel model) {
        curr.colorOffset = curr.mesh.getInstancedAttribute(4) != null ? curr.mesh.getInstancedAttribute((int)4).offset / 4 : 0;
        model.properMotionOffset = curr.mesh.getInstancedAttribute(16384) != null ? curr.mesh.getInstancedAttribute((int)16384).offset / 4 : 0;
        model.sizeOffset = curr.mesh.getInstancedAttribute(512) != null ? curr.mesh.getInstancedAttribute((int)512).offset / 4 : 0;
        model.particlePosOffset = curr.mesh.getInstancedAttribute(8192) != null ? curr.mesh.getInstancedAttribute((int)8192).offset / 4 : 0;
    }

    @Override
    protected void initShaderProgram() {
        this.triComponent = new StarSetQuadComponent();
        this.triComponent.initShaderProgram(this.getShaderProgram());
    }

    @Override
    protected void preRenderObjects(ExtShaderProgram shaderProgram, ICamera camera) {
        shaderProgram.setUniformMatrix("u_projView", camera.getCamera().combined);
        shaderProgram.setUniformf("u_camPos", camera.getPos());
        this.addMotionTrailsUniforms(shaderProgram, camera);
        this.addCameraUpCubemapMode(shaderProgram, camera);
        this.addEffectsUniforms(shaderProgram, camera);
    }

    @Override
    protected void renderObject(ExtShaderProgram shaderProgram, IRenderable renderable) {
        Render render = (Render)renderable;
        Base base = (Base)Mapper.base.get(render.entity);
        StarSet set = (StarSet)Mapper.starSet.get(render.entity);
        Highlight hl = (Highlight)Mapper.highlight.get(render.entity);
        DatasetDescription desc = (DatasetDescription)Mapper.datasetDescription.get(render.entity);
        if (!set.disposed) {
            boolean hlCmap = hl.isHighlighted() && !hl.isHlplain();
            InstancedRenderSystem.InstancedModel model = this.getModel(set, this.getOffset(render));
            int n = set.data().size();
            if (!this.inGpu(render)) {
                float sizeFactor = this.utils.getDatasetSizeFactor(render.entity, hl, desc);
                int offset = this.addMeshData(model, model.numVertices, n, 0, set.modelFile, set.modelType, set.modelPrimitive);
                this.setModel(offset, model);
                this.setOffset(render, offset);
                this.curr = (ImmediateModeRenderSystem.MeshData)this.meshes.get(offset);
                model.ensureInstanceAttribsSize(n * this.curr.instanceSize);
                int numStarsAdded = 0;
                for (int i = 0; i < n; ++i) {
                    if (!this.utils.filter(i, set, desc) || !set.isVisible(i)) continue;
                    IParticleRecord particle = set.get(i);
                    if (!Double.isFinite(particle.size())) {
                        logger.debug("Star " + particle.id() + " has a non-finite size");
                        continue;
                    }
                    if (hlCmap) {
                        double[] color = this.cmap.colormap(hl.getHlcmi(), hl.getHlcma().getNumber(particle), hl.getHlcmmin(), hl.getHlcmmax());
                        model.instanceAttributes[this.curr.instanceIdx + this.curr.colorOffset] = Color.toFloatBits((float)((float)color[0]), (float)((float)color[1]), (float)((float)color[2]), (float)hl.getHlcmAlpha());
                    } else {
                        model.instanceAttributes[this.curr.instanceIdx + this.curr.colorOffset] = this.utils.saturateColor(i, set, hl);
                    }
                    model.instanceAttributes[this.curr.instanceIdx + model.sizeOffset] = (float)((double)particle.size() * 1.31526E-6) * sizeFactor;
                    model.instanceAttributes[this.curr.instanceIdx + model.properMotionOffset] = particle.vx();
                    model.instanceAttributes[this.curr.instanceIdx + model.properMotionOffset + 1] = particle.vy();
                    model.instanceAttributes[this.curr.instanceIdx + model.properMotionOffset + 2] = particle.vz();
                    model.instanceAttributes[this.curr.instanceIdx + model.particlePosOffset] = (float)particle.x();
                    model.instanceAttributes[this.curr.instanceIdx + model.particlePosOffset + 1] = (float)particle.y();
                    model.instanceAttributes[this.curr.instanceIdx + model.particlePosOffset + 2] = (float)particle.z();
                    this.curr.instanceIdx += this.curr.instanceSize;
                    ++this.curr.numVertices;
                    ++numStarsAdded;
                }
                this.curr.mesh.setVertices(model.vertices, 0, model.numVertices * model.modelVertexSize);
                int count = numStarsAdded * this.curr.instanceSize;
                this.setCount(render, numStarsAdded);
                this.curr.mesh.setInstanceAttribs(model.instanceAttributes, 0, count);
                this.setInGpu(render, true);
            }
            this.curr = (ImmediateModeRenderSystem.MeshData)this.meshes.get(this.getOffset(render));
            if (this.curr != null) {
                if (hl.dirty) {
                    this.triComponent.updatePointScale(this.utils.getDatasetSizeFactor(render.entity, hl, desc));
                    hl.dirty = false;
                }
                if (this.triComponent.starTex != null) {
                    this.triComponent.starTex.bind(0);
                    shaderProgram.setUniformi("u_starTex", 0);
                }
                this.triComponent.alphaSizeBr[0] = base.opacity * this.alphas[base.ct.getFirstOrdinal()];
                shaderProgram.setUniform3fv("u_alphaSizeBr", this.triComponent.alphaSizeBr, 0, 3);
                shaderProgram.setUniformf("u_fixedAngularSize", (float)set.fixedAngularSize);
                double curRt = AstroUtils.getDaysSince(GaiaSky.instance.time.getTime(), set.epochJd);
                float curRt2 = (float)(curRt - (double)((float)curRt));
                shaderProgram.setUniformf("u_t", (float)curRt, curRt2);
                this.triComponent.setOpacityLimitsUniform(shaderProgram, hl);
                this.addAffineTransformUniforms(shaderProgram, (AffineTransformations)Mapper.affine.get(render.entity));
                if (!set.allowStreaks) {
                    shaderProgram.setUniformf("u_camVel", 0.0f, 0.0f, 0.0f);
                }
                try {
                    this.curr.mesh.render(shaderProgram, 4, 0, model.numVertices, this.getCount(render));
                }
                catch (IllegalArgumentException e) {
                    logger.error(e, "Render exception");
                }
            }
        } else {
            throw new RuntimeException("No suitable model found for type '" + set.modelType + "' and primitive '" + set.modelPrimitive + "'");
        }
    }

    @Override
    protected void setInGpu(IRenderable renderable, boolean state) {
        if (this.inGpu != null) {
            if (this.inGpu.contains(renderable) && !state) {
                EventManager.publish(Event.GPU_DISPOSE_STAR_GROUP, renderable, new Object[0]);
            }
            if (state) {
                this.inGpu.add(renderable);
            } else {
                this.inGpu.remove(renderable);
            }
        }
    }

    @Override
    public void notify(Event event, Object source, Object ... data) {
        switch (event) {
            case STAR_BASE_LEVEL_CMD: {
                this.triComponent.updateStarOpacityLimits(((Float)data[0]).floatValue(), Settings.settings.scene.star.opacity[1]);
                this.triComponent.touchStarParameters(this.getShaderProgram());
                break;
            }
            case STAR_BRIGHTNESS_CMD: {
                this.triComponent.updateStarBrightness(((Float)data[0]).floatValue());
                this.triComponent.touchStarParameters(this.getShaderProgram());
                break;
            }
            case STAR_BRIGHTNESS_POW_CMD: {
                this.triComponent.updateBrightnessPower(((Float)data[0]).floatValue());
                this.triComponent.touchStarParameters(this.getShaderProgram());
                break;
            }
            case STAR_POINT_SIZE_CMD: {
                this.triComponent.updateStarPointSize(((Float)data[0]).floatValue());
                this.triComponent.touchStarParameters(this.getShaderProgram());
                break;
            }
            case BACKBUFFER_SCALE_CMD: 
            case FOV_CHANGED_CMD: {
                this.triComponent.updateMinQuadSolidAngle(Settings.settings.graphics.backBufferResolution);
                this.triComponent.touchStarParameters(this.getShaderProgram());
                break;
            }
            case GPU_DISPOSE_STAR_GROUP: {
                IRenderable renderable = (IRenderable)source;
                int offset = this.getOffset(renderable);
                if (offset < 0) break;
                this.clearMeshData(offset);
                this.models.set(offset, null);
                this.inGpu.remove(renderable);
                break;
            }
            case BILLBOARD_TEXTURE_IDX_CMD: {
                GaiaSky.postRunnable(() -> this.triComponent.setStarTexture(Settings.settings.scene.star.getStarTexture()));
                break;
            }
        }
    }

    @Override
    public void resize(int w, int h) {
        this.triComponent.updateMinQuadSolidAngle(Settings.settings.graphics.backBufferResolution);
        this.triComponent.touchStarParameters(this.getShaderProgram());
    }
}

