/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.system.render.draw;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.VertexAttribute;
import com.badlogic.gdx.utils.Array;
import gaiasky.GaiaSky;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.event.IObserver;
import gaiasky.render.RenderGroup;
import gaiasky.render.api.IRenderable;
import gaiasky.render.system.ImmediateModeRenderSystem;
import gaiasky.scene.Mapper;
import gaiasky.scene.api.IParticleRecord;
import gaiasky.scene.camera.ICamera;
import gaiasky.scene.component.AffineTransformations;
import gaiasky.scene.component.Base;
import gaiasky.scene.component.DatasetDescription;
import gaiasky.scene.component.Highlight;
import gaiasky.scene.component.Render;
import gaiasky.scene.component.StarSet;
import gaiasky.scene.entity.ParticleUtils;
import gaiasky.scene.system.render.SceneRenderer;
import gaiasky.util.Logger;
import gaiasky.util.Settings;
import gaiasky.util.color.Colormap;
import gaiasky.util.coord.AstroUtils;
import gaiasky.util.gdx.mesh.IntMesh;
import gaiasky.util.gdx.shader.ExtShaderProgram;
import java.util.List;
import net.jafama.FastMath;

public class StarSetPointRenderer
extends ImmediateModeRenderSystem
implements IObserver {
    protected static final Logger.Log logger = Logger.getLogger(StarSetPointRenderer.class);
    private final double BRIGHTNESS_FACTOR;
    private final float[] alphaSizeBrRc = new float[4];
    private final float[] opacityLimitsHlShowAll = new float[]{2.0f, 4.0f};
    private final Colormap cmap = new Colormap();
    private final ParticleUtils utils = new ParticleUtils();
    private int sizeOffset;
    private int pmOffset;
    private float[] opacityLimits;
    private Texture starTex;

    public StarSetPointRenderer(SceneRenderer sceneRenderer, RenderGroup rg, float[] alphas, ExtShaderProgram[] shaders) {
        super(sceneRenderer, rg, alphas, shaders);
        this.BRIGHTNESS_FACTOR = 10.0;
        this.setStarTexture(Settings.settings.scene.star.getStarTexture());
        EventManager.instance.subscribe((IObserver)this, Event.STAR_BASE_LEVEL_CMD, Event.GPU_DISPOSE_STAR_GROUP, Event.BILLBOARD_TEXTURE_IDX_CMD);
    }

    public void setStarTexture(String starTexture) {
        this.starTex = new Texture(Settings.settings.data.dataFileHandle(starTexture), true);
        this.starTex.setFilter(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear);
    }

    @Override
    protected void initShaderProgram() {
        Gdx.gl.glEnable(34370);
        this.opacityLimits = new float[]{Settings.settings.scene.star.opacity[0], Settings.settings.scene.star.opacity[1]};
        ExtShaderProgram shaderProgram = this.getShaderProgram();
        shaderProgram.begin();
        shaderProgram.setUniformf("u_thAnglePoint", 1.0E-10f, 1.5E-8f);
        shaderProgram.end();
    }

    @Override
    protected void initVertices() {
        this.meshes = new Array();
    }

    private int addMeshData(int nVertices) {
        int mdi = this.createMeshData();
        this.curr = (ImmediateModeRenderSystem.MeshData)this.meshes.get(mdi);
        VertexAttribute[] attributes = this.buildVertexAttributes();
        this.curr.mesh = new IntMesh(false, nVertices, 0, attributes);
        this.curr.vertexSize = this.curr.mesh.getVertexAttributes().vertexSize / 4;
        this.curr.colorOffset = this.curr.mesh.getVertexAttribute(4) != null ? this.curr.mesh.getVertexAttribute((int)4).offset / 4 : 0;
        this.pmOffset = this.curr.mesh.getVertexAttribute(128) != null ? this.curr.mesh.getVertexAttribute((int)128).offset / 4 : 0;
        this.sizeOffset = this.curr.mesh.getVertexAttribute(32) != null ? this.curr.mesh.getVertexAttribute((int)32).offset / 4 : 0;
        return mdi;
    }

    @Override
    public void renderStud(List<IRenderable> renderables, ICamera camera, double t) {
        if (!renderables.isEmpty()) {
            ExtShaderProgram shaderProgram = this.getShaderProgram();
            float starPointSize = Settings.SceneSettings.StarSettings.getStarPointSize();
            shaderProgram.begin();
            shaderProgram.setUniformMatrix("u_projView", camera.getCamera().combined);
            shaderProgram.setUniformf("u_camPos", camera.getPos());
            shaderProgram.setUniformf("u_camDir", camera.getCamera().direction);
            shaderProgram.setUniformi("u_cubemap", Settings.settings.program.modeCubemap.active ? 1 : 0);
            shaderProgram.setUniformf("u_brightnessPower", Settings.settings.scene.star.power);
            shaderProgram.setUniformf("u_ar", Settings.settings.program.modeStereo.isStereoHalfWidth() ? 2.0f : 1.0f);
            this.addEffectsUniforms(shaderProgram, camera);
            this.alphaSizeBrRc[2] = (float)((double)Settings.settings.scene.star.brightness * this.BRIGHTNESS_FACTOR);
            this.alphaSizeBrRc[3] = this.rc.scaleFactor;
            renderables.forEach(renderable -> {
                Render render = (Render)renderable;
                Base base = (Base)Mapper.base.get(render.entity);
                StarSet set = (StarSet)Mapper.starSet.get(render.entity);
                Highlight hl = (Highlight)Mapper.highlight.get(render.entity);
                DatasetDescription desc = (DatasetDescription)Mapper.datasetDescription.get(render.entity);
                float sizeFactor = this.utils.getDatasetSizeFactor(render.entity, hl, desc);
                if (!set.disposed) {
                    boolean hlCmap;
                    boolean bl = hlCmap = hl.isHighlighted() && !hl.isHlplain();
                    if (!this.inGpu(render)) {
                        int n = set.data().size();
                        int offset = this.addMeshData(n);
                        this.setOffset(render, offset);
                        this.curr = (ImmediateModeRenderSystem.MeshData)this.meshes.get(offset);
                        this.ensureTempVertsSize(n * this.curr.vertexSize);
                        int numAdded = 0;
                        for (int i = 0; i < n; ++i) {
                            if (!this.utils.filter(i, set, desc) || !set.isVisible(i)) continue;
                            IParticleRecord particle = set.get(i);
                            if (!Double.isFinite(particle.size())) {
                                logger.debug("Star " + particle.id() + " has a non-finite size");
                                continue;
                            }
                            if (hlCmap) {
                                double[] color = this.cmap.colormap(hl.getHlcmi(), hl.getHlcma().getNumber(particle), hl.getHlcmmin(), hl.getHlcmmax());
                                this.tempVerts[this.curr.vertexIdx + this.curr.colorOffset] = Color.toFloatBits((float)((float)color[0]), (float)((float)color[1]), (float)((float)color[2]), (float)hl.getHlcmAlpha());
                            } else {
                                this.tempVerts[this.curr.vertexIdx + this.curr.colorOffset] = this.utils.getColor(i, set, hl);
                            }
                            this.tempVerts[this.curr.vertexIdx + this.sizeOffset] = hl.isHlAllVisible() && hl.isHighlighted() ? FastMath.max((float)10.0f, (float)((float)((double)particle.size() * 1.31526E-6) * sizeFactor)) : (float)((double)particle.size() * 1.31526E-6) * sizeFactor;
                            this.tempVerts[this.curr.vertexIdx] = (float)particle.x();
                            this.tempVerts[this.curr.vertexIdx + 1] = (float)particle.y();
                            this.tempVerts[this.curr.vertexIdx + 2] = (float)particle.z();
                            this.tempVerts[this.curr.vertexIdx + this.pmOffset] = particle.vx();
                            this.tempVerts[this.curr.vertexIdx + this.pmOffset + 1] = particle.vy();
                            this.tempVerts[this.curr.vertexIdx + this.pmOffset + 2] = particle.vz();
                            this.curr.vertexIdx += this.curr.vertexSize;
                            ++numAdded;
                        }
                        int count = numAdded * this.curr.vertexSize;
                        this.curr.mesh.setVertices(this.tempVerts, 0, count);
                        this.setInGpu(render, true);
                    }
                    this.curr = (ImmediateModeRenderSystem.MeshData)this.meshes.get(this.getOffset(render));
                    if (this.curr != null) {
                        if (this.starTex != null) {
                            this.starTex.bind(0);
                            shaderProgram.setUniformi("u_starTex", 0);
                        }
                        shaderProgram.setUniform2fv("u_opacityLimits", hl.isHighlighted() && hl.isHlAllVisible() ? this.opacityLimitsHlShowAll : this.opacityLimits, 0, 2);
                        this.alphaSizeBrRc[0] = base.opacity * this.alphas[base.ct.getFirstOrdinal()];
                        this.alphaSizeBrRc[1] = (Settings.settings.program.modeStereo.isStereoFullWidth() ? 1.0f : 2.0f) * starPointSize * this.rc.scaleFactor * sizeFactor / camera.getFovFactor();
                        shaderProgram.setUniform4fv("u_alphaSizeBrRc", this.alphaSizeBrRc, 0, 4);
                        shaderProgram.setUniformf("u_fixedAngularSize", (float)set.fixedAngularSize);
                        double curRt = AstroUtils.getDaysSince(GaiaSky.instance.time.getTime(), set.epochJd);
                        float curRt2 = (float)(curRt - (double)((float)curRt));
                        shaderProgram.setUniformf("u_t", (float)curRt, curRt2);
                        this.addAffineTransformUniforms(shaderProgram, (AffineTransformations)Mapper.affine.get(render.entity));
                        try {
                            this.curr.mesh.render(shaderProgram, 0);
                        }
                        catch (IllegalArgumentException e) {
                            logger.error("Render exception");
                        }
                    }
                }
            });
            shaderProgram.end();
        }
    }

    protected VertexAttribute[] buildVertexAttributes() {
        Array attributes = new Array();
        attributes.add((Object)new VertexAttribute(1, 3, "a_position"));
        attributes.add((Object)new VertexAttribute(128, 3, "a_pm"));
        attributes.add((Object)new VertexAttribute(4, 4, "a_color"));
        attributes.add((Object)new VertexAttribute(32, 1, "a_size"));
        VertexAttribute[] array = new VertexAttribute[attributes.size];
        for (int i = 0; i < attributes.size; ++i) {
            array[i] = (VertexAttribute)attributes.get(i);
        }
        return array;
    }

    @Override
    protected void setInGpu(IRenderable renderable, boolean state) {
        if (this.inGpu != null) {
            if (this.inGpu.contains(renderable) && !state) {
                EventManager.publish(Event.GPU_DISPOSE_STAR_GROUP, renderable, new Object[0]);
            }
            super.setInGpu(renderable, state);
        }
    }

    @Override
    public void notify(Event event, Object source, Object ... data) {
        switch (event) {
            case STAR_BASE_LEVEL_CMD: {
                this.opacityLimits[0] = ((Float)data[0]).floatValue();
                break;
            }
            case GPU_DISPOSE_STAR_GROUP: {
                IRenderable renderable = (IRenderable)source;
                int offset = this.getOffset(renderable);
                if (offset < 0) break;
                this.clearMeshData(offset);
                this.inGpu.remove(renderable);
                break;
            }
            case BILLBOARD_TEXTURE_IDX_CMD: {
                GaiaSky.postRunnable(() -> this.setStarTexture(Settings.settings.scene.star.getStarTexture()));
                break;
            }
        }
    }
}

