/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.system.render.draw;

import com.badlogic.gdx.graphics.Texture;
import gaiasky.GaiaSky;
import gaiasky.scene.component.Highlight;
import gaiasky.util.Settings;
import gaiasky.util.gdx.shader.ExtShaderProgram;

public class StarSetQuadComponent {
    protected float[] alphaSizeBr;
    protected float[] opacityLimits;
    protected float[] opacityLimitsHlShowAll;
    protected float starPointSize;
    protected float brightnessPower;
    protected float pointScale;
    protected float minQuadSolidAngle;
    protected Texture starTex;

    public void setStarTexture(String starTexture) {
        this.starTex = new Texture(Settings.settings.data.dataFileHandle(starTexture), true);
        this.starTex.setFilter(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear);
    }

    protected void initShaderProgram(ExtShaderProgram shaderProgram) {
        this.alphaSizeBr = new float[3];
        this.opacityLimits = new float[2];
        this.opacityLimitsHlShowAll = new float[]{0.95f, Settings.settings.scene.star.opacity[1]};
        this.updateMinQuadSolidAngle(Settings.settings.graphics.backBufferResolution);
        this.updateStarBrightness(Settings.settings.scene.star.brightness);
        this.updateBrightnessPower(Settings.settings.scene.star.power);
        this.updateStarPointSize(Settings.settings.scene.star.pointSize);
        this.updateStarOpacityLimits(Settings.settings.scene.star.opacity[0], Settings.settings.scene.star.opacity[1]);
        shaderProgram.begin();
        shaderProgram.setUniformf("u_thAnglePoint", 1.0E-10f, 1.5E-8f);
        shaderProgram.setUniformf("u_solidAngleMap", 1.0E-10f, 2.0E-9f);
        this.starParameterUniforms(shaderProgram);
        shaderProgram.end();
    }

    protected void starParameterUniforms(ExtShaderProgram shaderProgram) {
        shaderProgram.setUniformf("u_minQuadSolidAngle", this.minQuadSolidAngle);
        shaderProgram.setUniform3fv("u_alphaSizeBr", this.alphaSizeBr, 0, 3);
        shaderProgram.setUniformf("u_brightnessPower", this.brightnessPower);
    }

    protected void touchStarParameters(ExtShaderProgram shaderProgram) {
        GaiaSky.postRunnable(() -> {
            shaderProgram.begin();
            this.starParameterUniforms(shaderProgram);
            shaderProgram.end();
        });
    }

    protected void updateMinQuadSolidAngle(int[] backBufferSize) {
        this.minQuadSolidAngle = 2.592E-6f / (float)backBufferSize[1];
    }

    protected void updateStarBrightness(float br) {
        this.alphaSizeBr[2] = (br - 0.4f) / 7.6f * 4.0f;
    }

    protected void updateBrightnessPower(float bp) {
        this.brightnessPower = bp;
    }

    protected void updateStarPointSize(float ps) {
        this.starPointSize = ps * 0.4f;
        this.updateSizeAggregate();
    }

    protected void updateStarOpacityLimits(float min, float max) {
        this.opacityLimits[0] = min;
        this.opacityLimits[1] = max;
    }

    protected void updatePointScale(float ps) {
        this.pointScale = ps;
        this.updateSizeAggregate();
    }

    private void updateSizeAggregate() {
        this.alphaSizeBr[1] = this.starPointSize * 1000000.0f * this.pointScale;
    }

    protected void setOpacityLimitsUniform(ExtShaderProgram shaderProgram, Highlight highlight) {
        if (highlight != null && highlight.isHighlighted() && highlight.isHlAllVisible()) {
            this.opacityLimitsHlShowAll[0] = 0.95f;
            this.opacityLimitsHlShowAll[1] = Settings.settings.scene.star.opacity[1];
            shaderProgram.setUniform2fv("u_opacityLimits", this.opacityLimitsHlShowAll, 0, 2);
        } else {
            shaderProgram.setUniform2fv("u_opacityLimits", this.opacityLimits, 0, 2);
        }
    }
}

