/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.system.render.draw;

import com.badlogic.gdx.graphics.Camera;
import gaiasky.render.RenderGroup;
import gaiasky.render.api.IRenderable;
import gaiasky.render.system.AbstractRenderSystem;
import gaiasky.scene.Mapper;
import gaiasky.scene.camera.ICamera;
import gaiasky.scene.component.Render;
import gaiasky.scene.system.render.SceneRenderer;
import gaiasky.scene.system.render.draw.model.ModelEntityRenderSystem;
import gaiasky.util.gdx.IntModelBatch;
import java.util.List;
import org.lwjgl.opengl.GL41;

public class TessellationRenderer
extends AbstractRenderSystem {
    private final IntModelBatch batch;
    private final ModelEntityRenderSystem renderObject;

    public TessellationRenderer(SceneRenderer sceneRenderer, RenderGroup rg, float[] alphas, IntModelBatch batch) {
        super(sceneRenderer, rg, alphas, null);
        this.batch = batch;
        this.renderObject = new ModelEntityRenderSystem(sceneRenderer);
    }

    @Override
    public void renderStud(List<IRenderable> renderables, ICamera camera, double t) {
        if (this.mustRender()) {
            GL41.glPatchParameteri((int)36466, (int)3);
            this.batch.begin((Camera)camera.getCamera());
            renderables.forEach(r -> {
                Render render = (Render)r;
                this.renderObject.render(render.entity, this.batch, camera, this.getAlpha(render.entity), t, this.rc, this.getRenderGroup(), !Mapper.tagBillboard.has(render.entity));
            });
            this.batch.end();
        }
    }

    protected boolean mustRender() {
        return true;
    }
}

