/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.system.render.draw;

import com.badlogic.ashley.core.Entity;
import gaiasky.render.ComponentTypes;
import gaiasky.render.RenderGroup;
import gaiasky.render.api.IRenderable;
import gaiasky.render.system.AbstractRenderSystem;
import gaiasky.scene.Mapper;
import gaiasky.scene.camera.ICamera;
import gaiasky.scene.component.Body;
import gaiasky.scene.component.Render;
import gaiasky.scene.system.render.SceneRenderer;
import gaiasky.scene.view.LabelView;
import gaiasky.util.gdx.g2d.BitmapFont;
import gaiasky.util.gdx.g2d.ExtSpriteBatch;
import gaiasky.util.gdx.shader.ExtShaderProgram;
import java.util.List;

public class TextRenderer
extends AbstractRenderSystem {
    private final ExtSpriteBatch batch;
    private final LabelView view;
    public BitmapFont fontDistanceField;

    public TextRenderer(SceneRenderer sceneRenderer, RenderGroup rg, float[] alphas, ExtSpriteBatch batch, ExtShaderProgram program) {
        super(sceneRenderer, rg, alphas, new ExtShaderProgram[]{program});
        this.batch = batch;
        this.view = new LabelView();
    }

    public TextRenderer(SceneRenderer sceneRenderer, RenderGroup rg, float[] alphas, ExtSpriteBatch batch, ExtShaderProgram program, BitmapFont fontDistanceField) {
        this(sceneRenderer, rg, alphas, batch, program);
        if (fontDistanceField != null) {
            this.fontDistanceField = fontDistanceField;
            this.fontDistanceField.getData().setScale(0.6f);
        }
    }

    @Override
    public void renderStud(List<IRenderable> renderables, ICamera camera, double t) {
        this.batch.begin();
        ExtShaderProgram program = this.programs[0];
        this.renderFont3D(renderables, program, camera, this.alphas[ComponentTypes.ComponentType.Labels.ordinal()]);
        this.batch.end();
    }

    private void renderFont3D(List<IRenderable> renderables, ExtShaderProgram program, ICamera camera, float alpha) {
        renderables.forEach(r -> {
            Render render = (Render)r;
            Entity entity = render.entity;
            this.view.setEntity(entity);
            Body body = (Body)Mapper.body.get(entity);
            program.setUniform4fv("u_color", body.labelColor, 0, 4);
            program.setUniformf("u_componentAlpha", this.getAlpha(entity) * (this.view.isLabel() ? alpha : 1.0f));
            program.setUniformf("u_opacity", 0.75f * this.view.getTextOpacity());
            this.addDepthBufferUniforms(program, camera);
            this.view.render(this.batch, program, this, this.rc, camera);
        });
    }

    @Override
    public void resize(int w, int h) {
        super.resize(w, h);
        this.updateBatchSize(w, h);
    }

    @Override
    public void updateBatchSize(int w, int h) {
        this.batch.setProjectionMatrix(this.batch.getProjectionMatrix().setToOrtho2D(0.0f, 0.0f, (float)w, (float)h));
    }
}

