/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.system.render.draw.billboard;

import com.badlogic.ashley.core.Entity;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.math.Vector3;
import gaiasky.GaiaSky;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.event.IObserver;
import gaiasky.scene.Mapper;
import gaiasky.scene.api.IParticleRecord;
import gaiasky.scene.camera.ICamera;
import gaiasky.scene.component.Base;
import gaiasky.scene.component.Body;
import gaiasky.scene.component.Celestial;
import gaiasky.scene.component.Cluster;
import gaiasky.scene.component.DatasetDescription;
import gaiasky.scene.component.GraphNode;
import gaiasky.scene.component.Highlight;
import gaiasky.scene.component.ModelScaffolding;
import gaiasky.scene.component.ParticleExtra;
import gaiasky.scene.component.SolidAngle;
import gaiasky.scene.component.StarSet;
import gaiasky.scene.entity.ParticleUtils;
import gaiasky.scene.view.BillboardView;
import gaiasky.util.Constants;
import gaiasky.util.Settings;
import gaiasky.util.gdx.mesh.IntMesh;
import gaiasky.util.gdx.shader.ExtShaderProgram;
import gaiasky.util.math.MathUtilsDouble;
import gaiasky.util.math.Vector3Q;
import net.jafama.FastMath;

public class BillboardEntityRenderSystem
implements IObserver {
    private final Vector3 F31 = new Vector3();
    private final Vector3Q B31 = new Vector3Q();
    private final Color c = new Color();
    private final ParticleUtils utils = new ParticleUtils();
    protected float solidAngleThresholdTopOverFovFactor;
    protected float solidAngleThresholdBottomOverFovFactor;
    protected float fovFactor;

    public BillboardEntityRenderSystem() {
        EventManager.instance.subscribe((IObserver)this, Event.FOV_CHANGED_CMD);
        this.initRenderAttributes();
    }

    private void initRenderAttributes() {
        this.fovFactor = GaiaSky.instance != null ? GaiaSky.instance.getCameraManager().getFovFactor() : 1.0f;
        this.solidAngleThresholdTopOverFovFactor = 0.01f / this.fovFactor;
        this.solidAngleThresholdBottomOverFovFactor = 5.0E-7f / this.fovFactor;
    }

    public float getRenderSizeBillboardGalaxy(ICamera camera, Body body, ModelScaffolding scaffolding) {
        return body.size * Settings.settings.scene.star.brightness * scaffolding.billboardSizeFactor;
    }

    public void renderBillboardGalaxy(BillboardView view, float alpha, ExtShaderProgram shader, IntMesh mesh, ICamera camera) {
        Entity entity = view.getEntity();
        Base base = view.base;
        Body body = view.body;
        ModelScaffolding scaffolding = (ModelScaffolding)Mapper.modelScaffolding.get(entity);
        float size = (float)((double)this.getRenderSizeBillboardGalaxy(camera, view.body, scaffolding) / Constants.DISTANCE_SCALE_FACTOR);
        shader.setUniformf("u_pos", view.graph.translation);
        shader.setUniformf("u_size", size);
        shader.setUniformf("u_color", body.color[0], body.color[1], body.color[2], alpha);
        shader.setUniformf("u_alpha", alpha * base.opacity);
        shader.setUniformf("u_distance", (float)body.distToCamera);
        shader.setUniformf("u_apparent_angle", (float)body.solidAngleApparent);
        shader.setUniformf("u_time", (float)GaiaSky.instance.getT() / 5.0f);
        shader.setUniformf("u_radius", size);
        mesh.render(shader, 4, 0, 6);
    }

    private void renderCloseUpStar(StarSet set, Highlight highlight, DatasetDescription desc, int idx, float fovFactor, Vector3Q cPosD, ICamera camera, ExtShaderProgram shader, IntMesh mesh, double thPointTimesFovFactor, float alpha) {
        if (this.utils.filter(idx, set, desc) && set.isVisible(idx)) {
            IParticleRecord star = (IParticleRecord)set.pointData.get(idx);
            double varScl = this.utils.getVariableSizeScaling(set, idx);
            double size = set.getSize(idx);
            double sizeVar = size * varScl;
            double radius = sizeVar * 1.31526E-6;
            Vector3Q starPos = set.fetchPosition(star, camera.getPos(), this.B31, set.currDeltaYears);
            double distToCamera = starPos.lenDouble();
            double solidAngle = size * 1.31526E-6 / distToCamera;
            Color.abgr8888ToColor((Color)this.c, (float)this.utils.getColor(idx, set, highlight));
            if (solidAngle >= thPointTimesFovFactor) {
                double fuzzySize = this.getRenderSizeStarSet(size, radius, distToCamera, solidAngle);
                shader.setUniformMatrix("u_matrix", camera.getCamera().view);
                shader.setUniformf("u_pos", starPos);
                shader.setUniformf("u_size", (float)fuzzySize);
                shader.setUniformf("u_color", this.c.r, this.c.g, this.c.b, alpha *= (float)MathUtilsDouble.flint(solidAngle, thPointTimesFovFactor, thPointTimesFovFactor * 2.0, 0.0, 1.0));
                shader.setUniformf("u_distance", (float)distToCamera);
                shader.setUniformf("u_apparent_angle", (float)(solidAngle * (double)Settings.settings.scene.star.pointSize));
                shader.setUniformf("u_radius", (float)radius);
                mesh.render(shader, 4, 0, 6);
            }
        }
    }

    public double getRenderSizeStarSet(double size, double radius, double distToCamera, double solidAngle) {
        double computedSize = size;
        if (solidAngle > (double)this.solidAngleThresholdBottomOverFovFactor) {
            double dist = solidAngle > (double)this.solidAngleThresholdTopOverFovFactor ? radius / 0.01 : distToCamera / (double)this.fovFactor;
            computedSize = size * (dist / radius) * 5.0E-7;
        }
        return computedSize *= (double)Settings.settings.scene.star.pointSize * Settings.settings.scene.star.glowFactor;
    }

    public void renderBillboardStarSet(BillboardView view, float alpha, ExtShaderProgram shader, IntMesh mesh, ICamera camera) {
        Entity entity = view.getEntity();
        Base base = view.base;
        StarSet set = (StarSet)Mapper.starSet.get(entity);
        DatasetDescription desc = (DatasetDescription)Mapper.datasetDescription.get(entity);
        Highlight highlight = (Highlight)Mapper.highlight.get(entity);
        double thPointTimesFovFactor = Settings.settings.scene.star.threshold.point * (double)this.fovFactor;
        double innerRad = 0.006 + (double)Settings.settings.scene.star.pointSize * 0.008;
        alpha *= base.opacity;
        shader.setUniformf("u_th_angle_point", (float)thPointTimesFovFactor);
        shader.setUniformi("u_lightScattering", 0);
        shader.setUniformf("u_inner_rad", (float)innerRad);
        boolean focusRendered = false;
        int n = FastMath.min((int)set.numBillboards, (int)set.indices.length);
        for (int i = 0; i < n; ++i) {
            if (set.indices[i] < 0) continue;
            this.renderCloseUpStar(set, highlight, desc, set.indices[i], this.fovFactor, set.cPosD, camera, shader, mesh, thPointTimesFovFactor, alpha);
            focusRendered = focusRendered || set.indices[i] == set.focusIndex;
        }
        if (set.focus != null && !focusRendered) {
            this.renderCloseUpStar(set, highlight, desc, set.focusIndex, this.fovFactor, set.cPosD, camera, shader, mesh, thPointTimesFovFactor, alpha);
        }
    }

    public float getRenderSizeCelestial(ICamera camera, Entity entity, Body body, SolidAngle sa, ModelScaffolding scaffolding, ParticleExtra extra) {
        if (extra != null) {
            boolean star = Mapper.hip.has(entity);
            extra.computedSize = body.size;
            if (body.solidAngle > (double)this.solidAngleThresholdBottomOverFovFactor) {
                double dist = body.solidAngle > (double)this.solidAngleThresholdTopOverFovFactor ? (double)((float)extra.radius) / 0.01 : body.distToCamera / (double)this.fovFactor;
                extra.computedSize *= dist / extra.radius * 5.0E-7;
            }
            extra.computedSize = extra.computedSize * ((double)Settings.settings.scene.star.pointSize * (star ? Settings.settings.scene.star.glowFactor : 0.2 / (Constants.DISTANCE_SCALE_FACTOR != 1.0 ? 200.0 : 1.0)));
            return (float)(extra.computedSize * extra.primitiveRenderScale);
        }
        if (Mapper.fade.has(entity)) {
            return this.getRenderSizeBillboardGalaxy(camera, body, scaffolding);
        }
        float thAngleQuad = (float)sa.thresholdQuad * camera.getFovFactor();
        double size = 0.0;
        if (body.solidAngle >= sa.thresholdPoint * (double)camera.getFovFactor()) {
            size = FastMath.tan((double)thAngleQuad) * body.distToCamera * (double)scaffolding.billboardSizeFactor;
        }
        return (float)size;
    }

    public void renderBillboardCelestial(BillboardView view, float alpha, ExtShaderProgram shader, IntMesh mesh, ICamera camera) {
        Entity entity = view.getEntity();
        Base base = view.base;
        Body body = view.body;
        GraphNode graph = view.graph;
        Celestial celestial = view.celestial;
        SolidAngle sa = (SolidAngle)Mapper.sa.get(entity);
        ParticleExtra extra = (ParticleExtra)Mapper.extra.get(entity);
        ModelScaffolding scaffolding = (ModelScaffolding)Mapper.modelScaffolding.get(entity);
        boolean isStar = Mapper.hip.has(entity);
        boolean isModel = !isStar && Mapper.model.has(entity);
        float fuzzySize = this.getRenderSizeCelestial(camera, entity, body, sa, scaffolding, extra);
        float radius = (float)(extra != null ? extra.radius : (double)body.size / 2.0 * (double)scaffolding.sizeScaleFactor);
        Vector3 billboardPosition = graph.translation.put(this.F31);
        if (isModel) {
            float len = billboardPosition.len();
            billboardPosition.nor().scl(len * 0.99f);
        } else {
            shader.setUniformMatrix("u_matrix", camera.getCamera().view);
        }
        shader.setUniformf("u_pos", billboardPosition);
        shader.setUniformf("u_size", fuzzySize);
        float[] color = body.color;
        float a = extra == null ? alpha * (1.0f - scaffolding.fadeOpacity) * base.opacity : alpha * base.opacity;
        shader.setUniformf("u_color", color[0], color[1], color[2], a);
        shader.setUniformf("u_inner_rad", (float)celestial.innerRad);
        shader.setUniformf("u_distance", (float)body.distToCamera);
        shader.setUniformf("u_apparent_angle", (float)body.solidAngleApparent);
        shader.setUniformf("u_th_angle_point", (float)sa.thresholdPoint * this.fovFactor);
        shader.setUniformf("u_vrScale", (float)Constants.DISTANCE_SCALE_FACTOR);
        shader.setUniformf("u_radius", radius);
        mesh.render(shader, 4, 0, 6);
    }

    public void renderBillboardCluster(BillboardView view, float alpha, ExtShaderProgram shader, IntMesh mesh, ICamera camera) {
        Entity entity = view.getEntity();
        Base base = view.base;
        Body body = view.body;
        GraphNode graph = view.graph;
        Cluster cluster = (Cluster)Mapper.cluster.get(entity);
        if (cluster.clusterTex != null) {
            cluster.clusterTex.bind(0);
        }
        float fa = (1.0f - cluster.fadeAlpha) * 0.6f;
        shader.setUniformf("u_pos", graph.translation);
        shader.setUniformf("u_size", body.size);
        shader.setUniformf("u_color", body.color[0] * fa, body.color[1] * fa, body.color[2] * fa, body.color[3] * alpha * base.opacity * 6.5f);
        mesh.render(shader, 4, 0, 6);
    }

    @Override
    public void notify(Event event, Object source, Object ... data) {
        if (event == Event.FOV_CHANGED_CMD) {
            this.fovFactor = ((Float)data[0]).floatValue() / 40.0f;
            this.solidAngleThresholdTopOverFovFactor = 0.01f / this.fovFactor;
            this.solidAngleThresholdBottomOverFovFactor = 5.0E-7f / this.fovFactor;
        }
    }
}

