/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.system.render.draw.line;

import com.badlogic.ashley.core.Entity;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.math.MathUtils;
import gaiasky.GaiaSky;
import gaiasky.data.util.PointCloudData;
import gaiasky.render.ComponentTypes;
import gaiasky.render.api.ILineRenderable;
import gaiasky.render.system.LineRenderSystem;
import gaiasky.scene.Mapper;
import gaiasky.scene.api.IParticleRecord;
import gaiasky.scene.camera.ICamera;
import gaiasky.scene.component.Arrow;
import gaiasky.scene.component.Axis;
import gaiasky.scene.component.Base;
import gaiasky.scene.component.Body;
import gaiasky.scene.component.Boundaries;
import gaiasky.scene.component.Constel;
import gaiasky.scene.component.GraphNode;
import gaiasky.scene.component.GridRecursive;
import gaiasky.scene.component.Orientation;
import gaiasky.scene.component.Perimeter;
import gaiasky.scene.component.Ruler;
import gaiasky.scene.component.StarSet;
import gaiasky.scene.component.Trajectory;
import gaiasky.scene.component.VRDevice;
import gaiasky.scene.component.Verts;
import gaiasky.scene.record.OrbitComponent;
import gaiasky.scene.system.render.draw.LinePrimitiveRenderer;
import gaiasky.scene.view.LineView;
import gaiasky.util.Constants;
import gaiasky.util.Settings;
import gaiasky.util.color.ColorUtils;
import gaiasky.util.math.MathUtilsDouble;
import gaiasky.util.math.Matrix4D;
import gaiasky.util.math.Vector3D;
import gaiasky.util.math.Vector3Q;
import gaiasky.util.tree.IPosition;
import java.time.Instant;
import java.util.List;
import net.jafama.FastMath;

public class LineEntityRenderSystem {
    private final float[] rgba = new float[4];
    protected Vector3D prev = new Vector3D();
    protected Vector3D curr = new Vector3D();
    private final LineView lineView;
    private final Vector3Q B31 = new Vector3Q();
    private final Vector3D D31 = new Vector3D();
    private final Vector3D D32 = new Vector3D();
    private final Vector3D D33 = new Vector3D();
    private final Vector3D D34 = new Vector3D();

    public LineEntityRenderSystem() {
        this.lineView = new LineView();
    }

    public LineEntityRenderSystem(LineView view) {
        this.lineView = view;
    }

    public void renderVRDevice(Entity entity, LineRenderSystem renderer, ICamera camera, float alpha) {
        VRDevice vr = (VRDevice)Mapper.vr.get(entity);
        Gdx.gl.glEnable(2929);
        Gdx.gl.glDepthMask(true);
        float[] p0c = vr.colorP0;
        float[] p1c = vr.colorP1;
        float[] p2c = vr.colorP2;
        renderer.addLine(this.lineView, vr.beamP0.x, vr.beamP0.y, vr.beamP0.z, vr.beamP1.x, vr.beamP1.y, vr.beamP1.z, p0c[0], p0c[1], p0c[2], p0c[3], p1c[0], p1c[1], p1c[2], p1c[3]);
        renderer.addLine(this.lineView, vr.beamP1.x, vr.beamP1.y, vr.beamP1.z, vr.beamP2.x, vr.beamP2.y, vr.beamP2.z, p1c[0], p1c[1], p1c[2], p1c[3], p2c[0], p2c[1], p2c[2], p2c[3]);
    }

    public void renderPolyline(Entity entity, LinePrimitiveRenderer renderer, ICamera camera, float alpha) {
        float[] cc = this.lineView.body.color;
        alpha *= cc[3];
        Verts verts = this.lineView.verts;
        if (verts.pointCloudData != null && verts.pointCloudData.getNumPoints() > 1) {
            GraphNode graph = (GraphNode)Mapper.graph.get(entity);
            Vector3D prev = this.D31;
            for (int i = 0; i < verts.pointCloudData.getNumPoints(); ++i) {
                verts.pointCloudData.loadPoint(prev, i);
                prev.add(graph.translation);
                renderer.addPoint(this.lineView, (float)prev.x, (float)prev.y, (float)prev.z, cc[0], cc[1], cc[2], alpha);
            }
            renderer.breakLine();
            Arrow arrow = (Arrow)Mapper.arrow.get(entity);
            if (arrow != null && arrow.arrowCap) {
                Vector3D p1 = this.D32.set(verts.pointCloudData.getX(0), verts.pointCloudData.getY(0), verts.pointCloudData.getZ(0));
                Vector3D p2 = this.D33.set(verts.pointCloudData.getX(1), verts.pointCloudData.getY(1), verts.pointCloudData.getZ(1));
                Vector3D ppm = this.D34.set(p1).sub(p2);
                double p1p2len = ppm.len();
                p1.sub(camera.getPos());
                p2.sub(camera.getPos());
                Vector3D p3 = ppm.nor().scl(p1p2len * 0.7).add(p2);
                p3.rotate(p1, 30.0);
                renderer.addPoint(this.lineView, p1.x, p1.y, p1.z, cc[0], cc[1], cc[2], alpha);
                renderer.addPoint(this.lineView, p3.x, p3.y, p3.z, cc[0], cc[1], cc[2], alpha);
                renderer.breakLine();
                p3.rotate(p1, -60.0);
                renderer.addPoint(this.lineView, p1.x, p1.y, p1.z, cc[0], cc[1], cc[2], alpha);
                renderer.addPoint(this.lineView, p3.x, p3.y, p3.z, cc[0], cc[1], cc[2], alpha);
                renderer.breakLine();
            }
        }
    }

    public void renderPerimeter(Entity entity, LinePrimitiveRenderer renderer, ICamera camera, float alpha) {
        Perimeter perimeter = (Perimeter)Mapper.perimeter.get(entity);
        float[] cc = this.lineView.body.color;
        for (float[][] linePoints : perimeter.loc3d) {
            int m = linePoints.length;
            for (int pointIndex = 1; pointIndex < m; ++pointIndex) {
                renderer.addLine(this.lineView, linePoints[pointIndex - 1][0], linePoints[pointIndex - 1][1], linePoints[pointIndex - 1][2], linePoints[pointIndex][0], linePoints[pointIndex][1], linePoints[pointIndex][2], cc[0], cc[1], cc[2], alpha * this.lineView.base.opacity);
            }
            renderer.addLine(this.lineView, linePoints[m - 1][0], linePoints[m - 1][1], linePoints[m - 1][2], linePoints[0][0], linePoints[0][1], linePoints[0][2], cc[0], cc[1], cc[2], alpha * this.lineView.base.opacity);
        }
    }

    public void renderAxes(Entity entity, LinePrimitiveRenderer renderer, ICamera camera, float alpha) {
        if (alpha > 0.0f) {
            Axis axis = (Axis)Mapper.axis.get(entity);
            Vector3D o = axis.o;
            Vector3D x = axis.x;
            Vector3D y = axis.y;
            Vector3D z = axis.z;
            float[][] axesColors = axis.axesColors;
            renderer.addLine(this.lineView, o.x, o.y, o.z, x.x, x.y, x.z, axesColors[0][0], axesColors[0][1], axesColors[0][2], alpha);
            renderer.addLine(this.lineView, o.x, o.y, o.z, y.x, y.y, y.z, axesColors[1][0], axesColors[1][1], axesColors[1][2], alpha);
            renderer.addLine(this.lineView, o.x, o.y, o.z, z.x, z.y, z.z, axesColors[2][0], axesColors[2][1], axesColors[2][2], alpha);
        }
    }

    public void renderRuler(Entity entity, LinePrimitiveRenderer renderer, ICamera camera, float alpha) {
        Body body = this.lineView.body;
        Ruler ruler = (Ruler)Mapper.ruler.get(entity);
        double va = 0.01 * (double)camera.getFovFactor();
        renderer.addLine(this.lineView, ruler.p0.x, ruler.p0.y, ruler.p0.z, ruler.p1.x, ruler.p1.y, ruler.p1.z, body.color[0], body.color[1], body.color[2], body.color[3] * alpha);
        this.addCap(body, ruler.p0, ruler.p1, va, renderer, alpha);
        this.addCap(body, ruler.p1, ruler.p0, va, renderer, alpha);
    }

    private void addCap(Body body, Vector3D p0, Vector3D p1, double va, LinePrimitiveRenderer renderer, float alpha) {
        Vector3D cp = this.D32.set(p0);
        Vector3D crs = this.D31.set(p1).sub(p0).crs(cp);
        double d = p0.len();
        double lengthCap = FastMath.tan((double)va) * d;
        crs.setLength(lengthCap);
        Vector3D aux0 = this.D32.set(p0).add(crs);
        Vector3D aux1 = this.D33.set(p0).sub(crs);
        renderer.addLine(this.lineView, aux0.x, aux0.y, aux0.z, aux1.x, aux1.y, aux1.z, body.color[0], body.color[1], body.color[2], alpha);
    }

    public void renderGridRec(Entity entity, LinePrimitiveRenderer renderer, ICamera camera, float alpha) {
        Base base = this.lineView.base;
        GridRecursive gr = (GridRecursive)Mapper.gridRec.get(entity);
        if (camera.hasFocus()) {
            renderer.addLine(this.lineView, gr.a.x, gr.a.y, gr.a.z, gr.b.x, gr.b.y, gr.b.z, gr.ccL[0], gr.ccL[1], gr.ccL[2], gr.ccL[3] * alpha * base.opacity);
            renderer.addLine(this.lineView, gr.c.x, gr.c.y, gr.c.z, gr.d.x, gr.d.y, gr.d.z, gr.ccL[0], gr.ccL[1], gr.ccL[2], gr.ccL[3] * alpha * base.opacity);
        }
    }

    public void renderConstellationBoundaries(Entity entity, LinePrimitiveRenderer renderer, ICamera camera, float alpha) {
        Base base = this.lineView.base;
        Body body = this.lineView.body;
        Boundaries bound = (Boundaries)Mapper.bound.get(entity);
        alpha *= 0.3f;
        this.lineView.setEntity(entity);
        for (List<Vector3D> points : bound.boundaries) {
            Vector3D previous = null;
            for (Vector3D point : points) {
                if (previous != null) {
                    renderer.addLine(this.lineView, (float)previous.x, (float)previous.y, (float)previous.z, (float)point.x, (float)point.y, (float)point.z, body.color[0], body.color[1], body.color[2], alpha * base.opacity);
                }
                previous = point;
            }
            Vector3D first = points.getFirst();
            renderer.addLine(this.lineView, (float)first.x, (float)first.y, (float)first.z, (float)previous.x, (float)previous.y, (float)previous.z, body.color[0], body.color[1], body.color[2], alpha * base.opacity);
        }
    }

    public void renderConstellation(Entity entity, LinePrimitiveRenderer renderer, ICamera camera, float alpha) {
        Base base = this.lineView.base;
        Body body = this.lineView.body;
        Constel constel = (Constel)Mapper.constel.get(entity);
        alpha *= constel.alpha * base.opacity;
        Vector3D p1 = this.D31;
        Vector3D p2 = this.D32;
        Vector3Q campos = camera.getPos();
        this.lineView.setEntity(entity);
        for (IPosition[] pair : constel.lines) {
            if (pair == null) continue;
            this.getPosition(pair[0], campos, p1, constel);
            this.getPosition(pair[1], campos, p2, constel);
            renderer.addLine(this.lineView, p1.x, p1.y, p1.z, p2.x, p2.y, p2.z, body.color[0], body.color[1], body.color[2], alpha);
        }
    }

    private void getPosition(IPosition posBean, Vector3Q camPos, Vector3D out, Constel constel) {
        Vector3D vel = this.D33.setZero();
        if (posBean.getVelocity() != null && !posBean.getVelocity().hasNaN()) {
            vel.set(posBean.getVelocity()).scl(constel.deltaYears);
        }
        out.set(posBean.getPosition()).sub(camPos).add(vel);
    }

    private float getCurrentAlpha(float topAlpha, Trajectory trajectory) {
        float alpha = topAlpha;
        if (trajectory.trailMap > 0.0f) {
            alpha = 1.0f / (1.0f - trajectory.trailMap) * (alpha - trajectory.trailMap);
        }
        return MathUtils.clamp((float)alpha, (float)0.0f, (float)1.0f);
    }

    public void renderTrajectory(Entity entity, LinePrimitiveRenderer renderer, ICamera camera, float alpha) {
        block23: {
            Trajectory trajectory = (Trajectory)Mapper.trajectory.get(entity);
            if (!trajectory.bodyRepresentation.isOrbit()) break block23;
            Base base = this.lineView.base;
            Body body = this.lineView.body;
            Verts verts = this.lineView.verts;
            GraphNode graph = (GraphNode)Mapper.graph.get(entity);
            Matrix4D localTransformD = trajectory.localTransformD;
            OrbitComponent oc = trajectory.oc;
            boolean orbitTrail = trajectory.orbitTrail;
            float[] cc = body.color;
            PointCloudData pointCloudData = verts.pointCloudData;
            float baseOpacity = (float)((double)alpha * trajectory.alpha * (double)base.opacity);
            Vector3D parentPos = Mapper.orientation.has(graph.parent) ? ((Orientation)Mapper.orientation.get(graph.parent)).getNonRotatedPos() : null;
            int last = parentPos != null ? 2 : 1;
            float topAlpha = 1.0f;
            float dAlpha = 0.0f;
            int stIdx = 0;
            int nPoints = verts.pointCloudData.getNumPoints();
            boolean hasTime = verts.pointCloudData.hasTime();
            Vector3D bodyPos = this.D31.setZero();
            if (orbitTrail && hasTime) {
                float bottomAlpha = trajectory.params != null && (trajectory.params.orbitalPeriod > 40000.0 || base.ct.isEnabled(ComponentTypes.ComponentType.Moons)) ? -0.2f : -0.1f;
                dAlpha = (topAlpha - bottomAlpha) / (float)nPoints;
                Instant currentTime = GaiaSky.instance.time.getTime();
                long wrapTime = verts.pointCloudData.getWrapTimeMs(currentTime);
                stIdx = verts.pointCloudData.getIndex(wrapTime);
                if (trajectory.body != null) {
                    bodyPos.set(((GraphNode)Mapper.graph.get((Entity)trajectory.body)).translation);
                } else if (oc != null) {
                    oc.loadDataPoint(bodyPos, currentTime);
                    bodyPos.mul(localTransformD);
                }
                topAlpha = bottomAlpha;
                dAlpha = -dAlpha;
            }
            this.lineView.setEntity(entity);
            if (!trajectory.orbitTrail) {
                for (int i = 1; i < nPoints; ++i) {
                    pointCloudData.loadPoint(this.prev, i - 1);
                    pointCloudData.loadPoint(this.curr, i);
                    if (parentPos != null) {
                        this.prev.sub(parentPos);
                        this.curr.sub(parentPos);
                    }
                    this.prev.mul(localTransformD);
                    this.curr.mul(localTransformD);
                    renderer.addLine(this.lineView, (float)this.prev.x, (float)this.prev.y, (float)this.prev.z, (float)this.curr.x, (float)this.curr.y, (float)this.curr.z, cc[0], cc[1], cc[2], alpha * cc[3] * baseOpacity);
                }
            } else if (oc != null && oc.period > 0.0) {
                int i = this.wrap(stIdx + 2, nPoints);
                for (int n = 0; n < nPoints - last; ++n) {
                    int im = this.wrap(i - 1, nPoints);
                    verts.pointCloudData.loadPoint(this.prev, im);
                    verts.pointCloudData.loadPoint(this.curr, i);
                    if (parentPos != null) {
                        this.prev.sub(parentPos);
                        this.curr.sub(parentPos);
                    }
                    this.prev.mul(localTransformD);
                    this.curr.mul(localTransformD);
                    float p0Alpha = this.getCurrentAlpha(topAlpha, trajectory);
                    float p1Alpha = this.getCurrentAlpha(topAlpha - dAlpha, trajectory);
                    if ((double)p0Alpha > 0.0 || (double)p1Alpha > 0.0) {
                        if (orbitTrail && n == nPoints - 2) {
                            renderer.addLine((ILineRenderable)this.lineView, (double)((float)this.curr.x), (double)((float)this.curr.y), (double)((float)this.curr.z), (double)((float)bodyPos.x), (double)((float)bodyPos.y), (double)((float)bodyPos.z), cc[0], cc[1], cc[2], p1Alpha * cc[3] * baseOpacity, cc[0], cc[1], cc[2], p0Alpha * cc[3] * baseOpacity);
                        } else {
                            renderer.addLine((ILineRenderable)this.lineView, (double)((float)this.prev.x), (double)((float)this.prev.y), (double)((float)this.prev.z), (double)((float)this.curr.x), (double)((float)this.curr.y), (double)((float)this.curr.z), cc[0], cc[1], cc[2], p0Alpha * cc[3] * baseOpacity, cc[0], cc[1], cc[2], p1Alpha * cc[3] * baseOpacity);
                        }
                    }
                    topAlpha -= dAlpha;
                    i = this.wrap(i + 1, nPoints);
                }
            } else if (hasTime) {
                dAlpha = -1.0f / (float)stIdx * (1.0f - trajectory.trailMap);
                for (int i = 1; i < stIdx; ++i) {
                    pointCloudData.loadPoint(this.prev, i - 1);
                    pointCloudData.loadPoint(this.curr, i);
                    if (parentPos != null) {
                        this.prev.sub(parentPos);
                        this.curr.sub(parentPos);
                    }
                    this.prev.mul(localTransformD);
                    this.curr.mul(localTransformD);
                    float p0Alpha = this.getCurrentAlpha(topAlpha, trajectory);
                    float p1Alpha = this.getCurrentAlpha(topAlpha - dAlpha, trajectory);
                    if ((double)p0Alpha > 0.0 || (double)p1Alpha > 0.0) {
                        renderer.addLine((ILineRenderable)this.lineView, (double)((float)this.prev.x), (double)((float)this.prev.y), (double)((float)this.prev.z), (double)((float)this.curr.x), (double)((float)this.curr.y), (double)((float)this.curr.z), cc[0], cc[1], cc[2], baseOpacity * p0Alpha * cc[3], cc[0], cc[1], cc[2], baseOpacity * p1Alpha * cc[3]);
                    }
                    topAlpha -= dAlpha;
                }
                renderer.addLine(this.lineView, (float)this.curr.x, (float)this.curr.y, (float)this.curr.z, (float)bodyPos.x, (float)bodyPos.y, (float)bodyPos.z, cc[0], cc[1], cc[2], baseOpacity * topAlpha * cc[3]);
            } else {
                dAlpha = 1.0f / ((float)(nPoints - 1) * (1.0f - trajectory.trailMap));
                for (int i = nPoints - 1; i > 0; --i) {
                    pointCloudData.loadPoint(this.prev, i - 1);
                    pointCloudData.loadPoint(this.curr, i);
                    if (parentPos != null) {
                        this.prev.sub(parentPos);
                        this.curr.sub(parentPos);
                    }
                    this.prev.mul(localTransformD);
                    this.curr.mul(localTransformD);
                    float p0Alpha = MathUtils.clamp((float)topAlpha, (float)0.0f, (float)1.0f);
                    float p1Alpha = MathUtils.clamp((float)(topAlpha - dAlpha), (float)0.0f, (float)1.0f);
                    if ((double)p0Alpha > 0.001) {
                        renderer.addLine((ILineRenderable)this.lineView, (double)((float)this.prev.x), (double)((float)this.prev.y), (double)((float)this.prev.z), (double)((float)this.curr.x), (double)((float)this.curr.y), (double)((float)this.curr.z), cc[0], cc[1], cc[2], alpha * cc[3] * p0Alpha * baseOpacity, cc[0], cc[1], cc[2], alpha * cc[3] * p1Alpha * baseOpacity);
                    }
                    topAlpha -= dAlpha;
                }
            }
        }
    }

    public void renderStarSet(Entity entity, LinePrimitiveRenderer renderer, ICamera camera, float alpha) {
        Base base = this.lineView.base;
        StarSet set = (StarSet)Mapper.starSet.get(entity);
        this.lineView.setEntity(entity);
        alpha *= GaiaSky.instance.sceneRenderer.alphas[ComponentTypes.ComponentType.VelocityVectors.ordinal()];
        float thPointTimesFovFactor = (float)Settings.settings.scene.star.threshold.point * camera.getFovFactor();
        int n = (int)((double)this.getMaxVelocityVectors(entity, set) * (Settings.settings.scene.properMotion.number * 0.1));
        for (int i = n - 1; i >= 0 && set.indices[i] >= 0; --i) {
            float b;
            float g;
            float r;
            IParticleRecord star = (IParticleRecord)set.pointData.get(set.indices[i]);
            float radius = (float)(set.getSize(set.indices[i]) * 1.31526E-6);
            Vector3Q lPos = set.fetchPosition(star, set.cPosD, this.B31, set.currDeltaYears);
            Vector3D pm = this.D32.set(star.vx(), star.vy(), star.vz()).scl(set.currDeltaYears);
            float distToCamera = (float)lPos.lenDouble();
            float viewAngle = radius / distToCamera / camera.getFovFactor() * Settings.settings.scene.star.brightness;
            if (!(viewAngle >= thPointTimesFovFactor) || star.vx() == 0.0f && star.vy() == 0.0f && star.vz() == 0.0f) continue;
            Vector3D p1 = this.D31.set(star.x() + pm.x, star.y() + pm.y, star.z() + pm.z).sub(camera.getPos());
            Vector3D ppm = this.D32.set(star.vx(), star.vy(), star.vz()).scl(Settings.settings.scene.properMotion.length);
            double p1p2len = ppm.len();
            Vector3D p2 = this.D33.set(ppm).add(p1);
            float maxSpeedKms = 100.0f;
            switch (Settings.settings.scene.properMotion.colorMode) {
                case 1: {
                    ppm.set(star.vx(), star.vy(), star.vz());
                    ppm.scl(Constants.U_TO_KM / 3.15576E7);
                    double len = MathUtilsDouble.clamp(ppm.len(), 0.0, (double)maxSpeedKms) / (double)maxSpeedKms;
                    ColorUtils.colormap_long_rainbow((float)(1.0 - len), this.rgba);
                    r = this.rgba[0];
                    g = this.rgba[1];
                    b = this.rgba[2];
                    break;
                }
                case 2: {
                    float radialVelocity = star.radVel();
                    if (Float.isFinite(radialVelocity) && radialVelocity != 0.0f) {
                        r = ColorUtils.gBlue[0] + 0.2f;
                        g = ColorUtils.gBlue[1] + 0.4f;
                        b = ColorUtils.gBlue[2] + 0.4f;
                        break;
                    }
                    r = ColorUtils.gRed[0] + 0.4f;
                    g = ColorUtils.gRed[1] + 0.2f;
                    b = ColorUtils.gRed[2] + 0.2f;
                    break;
                }
                case 3: {
                    float radialVelocity = star.radVel();
                    if (Float.isFinite(radialVelocity) && radialVelocity != 0.0f) {
                        float rv = (MathUtilsDouble.clamp(radialVelocity, -maxSpeedKms, maxSpeedKms) / maxSpeedKms + 1.0f) / 2.0f;
                        ColorUtils.colormap_blue_white_red(rv, this.rgba);
                        r = this.rgba[0];
                        g = this.rgba[1];
                        b = this.rgba[2];
                        break;
                    }
                    b = 1.0f;
                    g = 1.0f;
                    r = 1.0f;
                    break;
                }
                case 4: {
                    if (ppm.len2() != 0.0) {
                        ppm.set(star.vx(), star.vy(), star.vz());
                        ppm.scl(Constants.U_TO_KM / 3.15576E7);
                        Vector3D camStar = this.D34.set(p1);
                        double pr = ppm.dot(camStar.nor());
                        double projection = (MathUtilsDouble.clamp(pr, -((double)maxSpeedKms), (double)maxSpeedKms) / (double)maxSpeedKms + 1.0) / 2.0;
                        ColorUtils.colormap_blue_white_red((float)projection, this.rgba);
                        r = this.rgba[0];
                        g = this.rgba[1];
                        b = this.rgba[2];
                        break;
                    }
                    b = 1.0f;
                    g = 1.0f;
                    r = 1.0f;
                    break;
                }
                case 5: {
                    r = ColorUtils.gBlue[0] + 0.2f;
                    g = ColorUtils.gBlue[1] + 0.4f;
                    b = ColorUtils.gBlue[2] + 0.4f;
                    break;
                }
                default: {
                    ppm.nor();
                    r = (float)(ppm.x + 1.0) / 2.0f;
                    g = (float)(ppm.y + 1.0) / 2.0f;
                    b = (float)(ppm.z + 1.0) / 2.0f;
                }
            }
            r = MathUtilsDouble.clamp(r, 0.0f, 1.0f);
            g = MathUtilsDouble.clamp(g, 0.0f, 1.0f);
            b = MathUtilsDouble.clamp(b, 0.0f, 1.0f);
            renderer.addLine(this.lineView, p1.x, p1.y, p1.z, p2.x, p2.y, p2.z, r, g, b, alpha * base.opacity);
            if (!Settings.settings.scene.properMotion.arrowHeads) continue;
            Vector3D p3 = this.D32.set(ppm).nor().scl(p1p2len * 0.86).add(p1);
            p3.rotate(p2, 30.0);
            renderer.addLine(this.lineView, p3.x, p3.y, p3.z, p2.x, p2.y, p2.z, r, g, b, alpha * base.opacity);
            p3.rotate(p2, -60.0);
            renderer.addLine(this.lineView, p3.x, p3.y, p3.z, p2.x, p2.y, p2.z, r, g, b, alpha * base.opacity);
        }
    }

    private long getMaxVelocityVectors(Entity entity, StarSet set) {
        return FastMath.min((int)set.indices.length, (int)FastMath.max((int)Math.round((float)Settings.settings.scene.star.group.numVelocityVector / (Mapper.octant.has(entity) ? 5.0f : 1.0f)), (int)40));
    }

    private int wrap(int idx, int n) {
        return (idx % n + n) % n;
    }
}

