/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.system.render.draw.model;

import com.badlogic.ashley.core.Entity;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector3;
import gaiasky.GaiaSky;
import gaiasky.render.ComponentTypes;
import gaiasky.render.RenderGroup;
import gaiasky.render.RenderingContext;
import gaiasky.render.ShadowMapImpl;
import gaiasky.scene.Mapper;
import gaiasky.scene.camera.ICamera;
import gaiasky.scene.component.Atmosphere;
import gaiasky.scene.component.Base;
import gaiasky.scene.component.Body;
import gaiasky.scene.component.Cloud;
import gaiasky.scene.component.Cluster;
import gaiasky.scene.component.Distance;
import gaiasky.scene.component.GraphNode;
import gaiasky.scene.component.GridRecursive;
import gaiasky.scene.component.Mesh;
import gaiasky.scene.component.Model;
import gaiasky.scene.component.ModelScaffolding;
import gaiasky.scene.component.Orientation;
import gaiasky.scene.component.ParticleExtra;
import gaiasky.scene.component.StarSet;
import gaiasky.scene.component.VRDevice;
import gaiasky.scene.entity.ParticleUtils;
import gaiasky.scene.record.AtmosphereComponent;
import gaiasky.scene.record.ModelComponent;
import gaiasky.scene.record.RotationComponent;
import gaiasky.scene.system.render.SceneRenderer;
import gaiasky.scene.view.FocusView;
import gaiasky.util.Settings;
import gaiasky.util.gdx.IntModelBatch;
import gaiasky.util.gdx.IntRenderableProvider;
import gaiasky.util.gdx.model.IntModelInstance;
import gaiasky.util.gdx.model.gltf.scene3d.attributes.CascadeShadowMapAttribute;
import gaiasky.util.gdx.shader.Environment;
import gaiasky.util.gdx.shader.Material;
import gaiasky.util.gdx.shader.attribute.ColorAttribute;
import gaiasky.util.gdx.shader.attribute.FloatAttribute;
import gaiasky.util.math.MathUtilsDouble;
import gaiasky.util.math.Vector3Q;
import java.util.Objects;
import net.jafama.FastMath;

public class ModelEntityRenderSystem {
    private final ParticleUtils utils;
    private final SceneRenderer sceneRenderer;
    private final FocusView focusView;
    private final Vector3Q v3b1 = new Vector3Q();
    private final Vector3Q v3b2 = new Vector3Q();
    private final Vector3 v3f1 = new Vector3();

    public ModelEntityRenderSystem(SceneRenderer sr) {
        this.sceneRenderer = sr;
        this.focusView = new FocusView();
        this.focusView.setScene(GaiaSky.instance.scene);
        this.utils = new ParticleUtils();
    }

    public void render(Entity entity, IntModelBatch batch, ICamera camera, float alpha, double t, RenderingContext rc, RenderGroup renderGroup, boolean shadow) {
        Model model = (Model)Mapper.model.get(entity);
        if (model != null && model.renderConsumer != null) {
            boolean relativistic = !Mapper.engine.has(entity) || !camera.getMode().isSpacecraft();
            model.renderConsumer.apply(this, entity, model, batch, Float.valueOf(alpha), t, rc, renderGroup, shadow, relativistic);
        }
    }

    public void renderOpaque(Entity entity, IntModelBatch modelBatch, float alpha, boolean shadow) {
        ModelScaffolding scaffolding = (ModelScaffolding)Mapper.modelScaffolding.get(entity);
        Model model = (Model)Mapper.model.get(entity);
        ModelComponent mc = model.model;
        if (mc != null && mc.instance != null && mc.isModelInitialised()) {
            if (scaffolding != null) {
                if (shadow) {
                    this.prepareShadowEnvironment(model, scaffolding);
                }
                mc.update(alpha * scaffolding.fadeOpacity);
                modelBatch.render((IntRenderableProvider)mc.instance, mc.env);
            } else {
                mc.setTransparency(alpha);
                modelBatch.render((IntRenderableProvider)mc.instance, mc.env);
            }
        }
    }

    public void renderVRDeviceModel(Entity entity, Model model, IntModelBatch batch, float alpha, double t, RenderingContext rc, RenderGroup renderGroup, boolean shadow, boolean relativistic) {
        model.model.setTransparency(alpha);
        batch.render((IntRenderableProvider)model.model.instance, model.model.env);
        VRDevice vr = (VRDevice)Mapper.vr.get(entity);
        IntModelInstance intersectionModel = vr.intersectionModel;
        if (vr.intersection != null && vr.interacting && vr.hitUI) {
            batch.render((IntRenderableProvider)intersectionModel, model.model.env);
        }
    }

    public void renderGenericModel(Entity entity, Model model, IntModelBatch batch, float alpha, double t, RenderingContext rc, RenderGroup renderGroup, boolean shadow, boolean relativistic) {
        ModelScaffolding scaffolding = (ModelScaffolding)Mapper.modelScaffolding.get(entity);
        ModelComponent mc = model.model;
        if (mc != null && mc.instance != null && mc.isModelInitialised()) {
            Base base = (Base)Mapper.base.get(entity);
            Body body = (Body)Mapper.body.get(entity);
            if (scaffolding != null && shadow) {
                this.prepareShadowEnvironment(model, scaffolding);
            }
            float alphaFactor = scaffolding != null ? (Mapper.fade.has(entity) ? base.opacity : scaffolding.fadeOpacity * base.opacity) : base.opacity;
            if (Mapper.grid.has(entity)) {
                ICamera cam = GaiaSky.instance.getICamera();
                mc.setFloatExtAttribute(FloatAttribute.Generic1, Settings.settings.scene.renderer.line.width);
                mc.setFloatExtAttribute(FloatAttribute.Generic2, cam.getFovFactor());
            }
            float colorAlpha = Mapper.tagBillboard.has(entity) || Mapper.tagBillboardGalaxy.has(entity) ? body.color[3] : 1.0f;
            mc.update(alpha * alphaFactor * colorAlpha, relativistic);
            mc.updateSizeKm(body.size);
            batch.render((IntRenderableProvider)mc.instance, mc.env);
        }
    }

    public void renderVolume(Entity entity, Model model, IntModelBatch batch, float alpha, double t, RenderingContext rc, RenderGroup renderGroup, boolean shadow, boolean relativistic) {
        ModelScaffolding scaffolding = (ModelScaffolding)Mapper.modelScaffolding.get(entity);
        ModelComponent mc = model.model;
        if (mc != null && mc.instance != null && mc.isModelInitialised()) {
            Base base = (Base)Mapper.base.get(entity);
            float alphaFactor = scaffolding != null ? (!Mapper.fade.has(entity) ? base.opacity : scaffolding.fadeOpacity * base.opacity) : base.opacity;
            this.focusView.setEntity(entity);
            this.focusView.getPredictedPosition(this.v3b2, GaiaSky.instance.time, GaiaSky.instance.getICamera(), true);
            Vector3 camPos = this.v3b1.set(GaiaSky.instance.getCameraManager().getPos()).sub(this.v3b2).put(this.v3f1);
            mc.updateCamPos(camPos);
            mc.updateTimes(GaiaSky.instance.getT(), FastMath.abs((double)(GaiaSky.instance.time.getTimeSeconds() % 50000.0 - 25000.0)));
            mc.update(alpha * alphaFactor, relativistic);
            mc.updateDepthTest();
            batch.render((IntRenderableProvider)mc.instance, mc.env);
        }
    }

    public void renderShape(Entity entity, Model model, IntModelBatch batch, float alpha, double t, RenderingContext rc, RenderGroup renderGroup, boolean shadow, boolean relativistic) {
        ModelComponent mc = model.model;
        Base base = (Base)Mapper.base.get(entity);
        Body body = (Body)Mapper.body.get(entity);
        GraphNode graph = (GraphNode)Mapper.graph.get(entity);
        mc.update(relativistic, graph.localTransform, alpha * base.opacity * body.color[3]);
        mc.updateDepthTest();
        Gdx.gl20.glLineWidth(1.5f + Settings.settings.scene.renderer.line.glWidthBias);
        batch.render((IntRenderableProvider)mc.instance, mc.env);
        batch.render((IntRenderableProvider)model.model.instance, model.model.env);
    }

    public void renderRecursiveGridModel(Entity entity, Model model, IntModelBatch modelBatch, float alpha, double t, RenderingContext rc, RenderGroup renderGroup, boolean shadow, boolean relativistic) {
        Base base = (Base)Mapper.base.get(entity);
        Body body = (Body)Mapper.body.get(entity);
        GridRecursive gr = (GridRecursive)Mapper.gridRec.get(entity);
        ModelComponent mc = model.model;
        mc.update(alpha * body.color[3] * base.opacity, relativistic);
        if (gr.regime == 1) {
            mc.depthTestReadOnly();
        } else {
            mc.depthTestDisable();
        }
        mc.setFloatExtAttribute(FloatAttribute.TessQuality, gr.scalingFading.getFirst().floatValue());
        mc.setFloatExtAttribute(FloatAttribute.HeightScale, gr.scalingFading.getSecond().floatValue());
        mc.setFloatExtAttribute(FloatAttribute.ElevationMultiplier, Settings.settings.program.recursiveGrid.style.ordinal());
        mc.setFloatExtAttribute(FloatAttribute.Ts, Settings.settings.scene.renderer.line.width * 1.4f);
        modelBatch.render((IntRenderableProvider)mc.instance, mc.env);
    }

    public void renderMeshModel(Entity entity, Model model, IntModelBatch batch, float alpha, double t, RenderingContext rc, RenderGroup renderGroup, boolean shadow, boolean relativistic) {
        if (model.model != null) {
            GraphNode graph = (GraphNode)Mapper.graph.get(entity);
            Base base = (Base)Mapper.base.get(entity);
            Mesh mesh = (Mesh)Mapper.mesh.get(entity);
            ModelComponent mc = model.model;
            if (mesh.shading == Mesh.MeshShading.ADDITIVE) {
                mc.update(relativistic, graph.localTransform, alpha * base.opacity, 1, 1, true);
                mc.depthTestReadOnly();
            } else {
                mc.update(relativistic, graph.localTransform, alpha * base.opacity);
                mc.depthTestReadWrite();
            }
            if (mc.instance != null) {
                batch.render((IntRenderableProvider)mc.instance, mc.env);
            }
        }
    }

    public void renderStarClusterModel(Entity entity, Model model, IntModelBatch modelBatch, float alpha, double t, RenderingContext rc, RenderGroup renderGroup, boolean shadow, boolean relativistic) {
        ModelComponent mc = model.model;
        Base base = (Base)Mapper.base.get(entity);
        GraphNode graph = (GraphNode)Mapper.graph.get(entity);
        Cluster cluster = (Cluster)Mapper.cluster.get(entity);
        mc.update(relativistic, null, alpha * base.opacity * cluster.fadeAlpha);
        mc.updateDepthTest();
        mc.instance.transform.set(graph.localTransform);
        modelBatch.render((IntRenderableProvider)mc.instance, mc.env);
    }

    public void renderParticleStarSetModel(Entity entity, Model model, IntModelBatch batch, float alpha, double t, RenderingContext rc, RenderGroup renderGroup, boolean shadow, boolean relativistic) {
        StarSet set = (StarSet)Mapper.starSet.get(entity);
        ModelComponent mc = model.model;
        if (mc != null && mc.isModelInitialised()) {
            float opacity;
            mc.touch();
            if (set.proximity.updating[0] != null && alpha * (opacity = (float)MathUtilsDouble.lint(set.proximity.updating[0].distToCamera, set.modelDist / 50.0, set.modelDist, 1.0, 0.0)) > 0.0f) {
                mc.setTransparency(alpha * opacity);
                mc.updateDepthTest();
                float[] col = set.proximity.updating[0].col;
                ((ColorAttribute)Objects.requireNonNull(mc.env.get((int)ColorAttribute.AmbientLight))).color.set(col[0], col[1], col[2], 1.0f);
                ((FloatAttribute)Objects.requireNonNull(mc.env.get((int)FloatAttribute.Time))).value = (float)t;
                double variableScaling = this.utils.getVariableSizeScaling(set, set.proximity.updating[0].index);
                int idx = set.proximity.updating[0].index;
                Vector3Q pos = set.fetchPosition(set.get(idx), GaiaSky.instance.getICamera().getPos(), this.v3b1, set.currDeltaYears);
                mc.instance.transform.idt().translate((float)pos.x.doubleValue(), (float)pos.y.doubleValue(), (float)pos.z.doubleValue()).scl((float)(set.getRadius(set.indices[0]) * 2.0 * variableScaling));
                if (relativistic) {
                    mc.updateRelativisticEffects(GaiaSky.instance.getICamera());
                }
                batch.render((IntRenderableProvider)mc.instance, mc.env);
            }
        }
    }

    public void renderParticleStarModel(Entity entity, Model model, IntModelBatch batch, float alpha, double t, RenderingContext rc, RenderGroup renderGroup, boolean shadow, boolean relativistic) {
        Body body = (Body)Mapper.body.get(entity);
        GraphNode graph = (GraphNode)Mapper.graph.get(entity);
        ParticleExtra extra = (ParticleExtra)Mapper.extra.get(entity);
        Distance dist = (Distance)Mapper.distance.get(entity);
        ModelScaffolding scaffolding = (ModelScaffolding)Mapper.modelScaffolding.get(entity);
        ModelComponent mc = model.model;
        float[] cc = body.color;
        double thresholdDistance = dist.distance * (double)scaffolding.sizeScaleFactor;
        float opacity = (float)MathUtilsDouble.flint(body.distToCamera, thresholdDistance / 50.0, thresholdDistance, 1.0, 0.0);
        ((ColorAttribute)Objects.requireNonNull(mc.env.get((int)ColorAttribute.AmbientLight))).color.set(cc[0], cc[1], cc[2], 1.0f);
        ((FloatAttribute)Objects.requireNonNull(mc.env.get((int)FloatAttribute.Time))).value = (float)t;
        mc.updateDepthTest();
        mc.update(alpha * opacity, relativistic);
        graph.translation.setToTranslation(mc.instance.transform).scl((float)(extra.radius * 2.0) * scaffolding.sizeScaleFactor);
        batch.render((IntRenderableProvider)mc.instance, mc.env);
    }

    public void renderSpacecraft(Entity entity, Model model, IntModelBatch batch, float alpha, double t, RenderingContext rc, RenderGroup renderGroup, boolean shadow, boolean relativistic) {
        ModelScaffolding scaffolding = (ModelScaffolding)Mapper.modelScaffolding.get(entity);
        GraphNode graph = (GraphNode)Mapper.graph.get(entity);
        ICamera cam = GaiaSky.instance.getICamera();
        ModelComponent mc = model.model;
        if (mc.isModelInitialised()) {
            if (shadow) {
                this.prepareShadowEnvironment(model, scaffolding);
            }
            mc.setTransparency(alpha * scaffolding.fadeOpacity);
            if (cam.getMode().isSpacecraft()) {
                mc.updateRelativisticEffects(cam, 0.0f);
            } else {
                mc.updateRelativisticEffects(cam);
            }
            batch.render((IntRenderableProvider)mc.instance, mc.env);
        } else {
            mc.load(graph.localTransform);
        }
    }

    public void renderPlanet(Entity entity, Model model, IntModelBatch batch, float alpha, double t, RenderingContext rc, RenderGroup renderGroup, boolean shadow, boolean relativistic) {
        Base base = (Base)Mapper.base.get(entity);
        Body body = (Body)Mapper.body.get(entity);
        ModelScaffolding scaffolding = (ModelScaffolding)Mapper.modelScaffolding.get(entity);
        Atmosphere atmosphere = (Atmosphere)Mapper.atmosphere.get(entity);
        Cloud cloud = (Cloud)Mapper.cloud.get(entity);
        if (renderGroup == RenderGroup.MODEL_ATM) {
            this.renderAtmosphere(entity, body, model, scaffolding, batch, atmosphere, this.sceneRenderer.alphas[ComponentTypes.ComponentType.Atmospheres.ordinal()], rc);
        } else if (renderGroup == RenderGroup.MODEL_CLOUD) {
            this.renderClouds(entity, base, model, cloud, batch, this.sceneRenderer.alphas[ComponentTypes.ComponentType.Clouds.ordinal()], t);
        } else {
            if (atmosphere.atmosphere != null) {
                float atmOpacity = (float)MathUtilsDouble.flint(body.solidAngle, 0.00745329f, 0.02490659f, 0.0, 1.0);
                if (Settings.settings.scene.visibility.get(ComponentTypes.ComponentType.Atmospheres.toString()).booleanValue() && atmOpacity > 0.0f && rc != null) {
                    GraphNode graph = (GraphNode)Mapper.graph.get(entity);
                    RotationComponent rotation = ((Orientation)Mapper.orientation.get((Entity)entity)).rotationComponent;
                    atmosphere.atmosphere.updateAtmosphericScatteringParams((Material)model.model.instance.materials.first(), alpha * atmOpacity, true, graph, rotation, scaffolding, rc.vrOffset);
                } else {
                    atmosphere.atmosphere.removeAtmosphericScattering((Material)model.model.instance.materials.first());
                }
            }
            if (shadow) {
                this.prepareShadowEnvironment(model, scaffolding);
            }
            model.model.updateEclipsingBodyUniforms(entity);
            model.model.update(alpha * base.opacity, relativistic);
            model.model.updateSizeKm(body.size);
            batch.render((IntRenderableProvider)model.model.instance, model.model.env);
        }
    }

    public void renderAtmosphere(Entity entity, Body body, Model model, ModelScaffolding scaffolding, IntModelBatch batch, Atmosphere atmosphere, float alpha, RenderingContext rc) {
        ICamera cam = GaiaSky.instance.getICamera();
        float atmOpacity = (float)MathUtilsDouble.flint(body.solidAngle, 0.00745329f, 0.02490659f, 0.0, 1.0);
        if (atmOpacity > 0.0f) {
            GraphNode graph = (GraphNode)Mapper.graph.get(entity);
            Orientation orientation = (Orientation)Mapper.orientation.get(entity);
            AtmosphereComponent ac = atmosphere.atmosphere;
            ac.updateAtmosphericScatteringParams((Material)ac.mc.instance.materials.first(), alpha * atmOpacity, false, graph, orientation.rotationComponent, scaffolding, rc.vrOffset);
            ac.mc.updateRelativisticEffects(cam);
            ac.mc.updateEclipsingBodyUniforms(entity);
            batch.render((IntRenderableProvider)ac.mc.instance, model.model.env);
        }
    }

    public void renderClouds(Entity entity, Base base, Model model, Cloud cloud, IntModelBatch batch, float alpha, double t) {
        cloud.cloud.updateCullFace(((Body)Mapper.body.get((Entity)entity)).distToCamera);
        cloud.cloud.touch(model);
        ICamera cam = GaiaSky.instance.getICamera();
        cloud.cloud.mc.updateRelativisticEffects(cam);
        cloud.cloud.mc.setTransparency(alpha * base.opacity);
        cloud.cloud.mc.updateEclipsingBodyUniforms(entity);
        batch.render((IntRenderableProvider)cloud.cloud.mc.instance, model.model.env);
    }

    protected void prepareShadowEnvironment(Model model, ModelScaffolding scaffolding) {
        if (!model.model.env.has(CascadeShadowMapAttribute.Type)) {
            Environment env = model.model.env;
            if (Settings.settings.scene.renderer.shadow.active && scaffolding.isSelfShadow()) {
                if (scaffolding.shadow > 0 && scaffolding.shadowMapFb != null && scaffolding.shadowMapCombined != null) {
                    Texture texGlobal;
                    boolean global = scaffolding.shadowMapFbGlobal != null;
                    Matrix4 combined = scaffolding.shadowMapCombined;
                    Texture tex = (Texture)scaffolding.shadowMapFb.getColorBufferTexture();
                    Matrix4 combinedGlobal = global ? scaffolding.shadowMapCombinedGlobal : null;
                    Texture texture = texGlobal = global ? (Texture)scaffolding.shadowMapFbGlobal.getColorBufferTexture() : null;
                    if (scaffolding.shadowMap == null) {
                        scaffolding.shadowMap = new ShadowMapImpl(combined, tex, combinedGlobal, texGlobal);
                    } else {
                        scaffolding.shadowMap.setProjViewTrans(combined);
                        scaffolding.shadowMap.setDepthMap(tex);
                        if (global) {
                            scaffolding.shadowMap.setProjViewTransGlobal(combinedGlobal);
                            scaffolding.shadowMap.setDepthMapGlobal(texGlobal);
                        }
                    }
                    env.shadowMap = scaffolding.shadowMap;
                    --scaffolding.shadow;
                } else {
                    env.shadowMap = null;
                }
            } else {
                model.model.env.shadowMap = null;
            }
        }
    }
}

