/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.system.render.draw.sprite;

import com.badlogic.ashley.core.Entity;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.math.Vector3;
import gaiasky.GaiaSky;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.scene.Mapper;
import gaiasky.scene.camera.ICamera;
import gaiasky.scene.component.Body;
import gaiasky.scene.component.LocationMark;
import gaiasky.scene.view.LabelView;
import gaiasky.util.DecalUtils;
import gaiasky.util.Logger;
import gaiasky.util.Settings;
import gaiasky.util.gdx.g2d.Sprite;
import gaiasky.util.math.Vector3D;
import java.util.HashMap;
import java.util.Map;

public class SpriteEntityRenderSystem {
    protected static final Logger.Log logger = Logger.getLogger(SpriteEntityRenderSystem.class);
    private final LabelView view;
    private final Vector3D D31 = new Vector3D();
    private Map<String, Sprite> spriteMap;
    Vector3 F31 = new Vector3();

    public SpriteEntityRenderSystem() {
        this.view = new LabelView();
        this.initSprites();
    }

    private void initSprites() {
        this.spriteMap = new HashMap<String, Sprite>();
        Sprite spriteDefault = new Sprite(GaiaSky.instance.getGlobalResources().getTexture("loc-marker-default"));
        Sprite spriteFlag = new Sprite(GaiaSky.instance.getGlobalResources().getTexture("loc-marker-flag"));
        Sprite spriteCity = new Sprite(GaiaSky.instance.getGlobalResources().getTexture("loc-marker-city"));
        this.spriteMap.put("default", spriteDefault);
        this.spriteMap.put("loc-marker-default", spriteDefault);
        this.spriteMap.put("flag", spriteFlag);
        this.spriteMap.put("loc-marker-flag", spriteFlag);
        this.spriteMap.put("city", spriteCity);
        this.spriteMap.put("loc-marker-city", spriteCity);
    }

    private Sprite getSprite(String name) {
        if (name.equalsIgnoreCase("none")) {
            return null;
        }
        Sprite s = this.spriteMap.get(name);
        if (s == null) {
            try {
                Texture t = new Texture(Settings.settings.data.dataFile(name));
                t.setFilter(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear);
                s = new Sprite(t);
                this.spriteMap.put(name, s);
            }
            catch (Exception e) {
                logger.error(e);
            }
        }
        return s;
    }

    public void render(Entity entity, SpriteBatch batch, ICamera camera, float alpha) {
        this.view.setEntity(entity);
        if (this.view.isLocation() && this.view.renderTextLocation()) {
            Vector3D pos = this.D31;
            this.view.textPosition(camera, pos);
            Sprite sprite = this.getSprite(this.view.loc.locationMarkerTexture);
            if (sprite != null) {
                float[] color;
                Body body = this.view.body;
                float[] fArray = color = body.color != null ? body.color : body.labelColor;
                if (color != null) {
                    sprite.setColor(color[0], color[1], color[2], color.length > 3 ? color[3] * alpha : 0.4f * alpha);
                } else {
                    sprite.setColor(0.7f, 0.6f, 0.0f, 0.4f * alpha);
                }
                DecalUtils.drawSprite(sprite, batch, (float)pos.x, (float)pos.y, (float)pos.z, 1.0E-4, 1.0f, camera, true, 0.017f, 0.035f);
                LocationMark loc = (LocationMark)Mapper.loc.get(entity);
                if (loc != null && loc.tooltipText != null) {
                    pos.put(this.F31);
                    camera.getCamera().project(this.F31);
                    int x = Gdx.input.getX();
                    int y_o = Gdx.input.getY();
                    int y = Gdx.graphics.getHeight() - y_o;
                    int s = 8;
                    if ((float)x > this.F31.x - (float)s && (float)x < this.F31.x + (float)s && (float)y > this.F31.y - (float)s && (float)y < this.F31.y + (float)s) {
                        EventManager.publish(Event.LOCATION_HOVER_INFO, this, x, y_o, loc);
                    }
                }
            }
        }
    }
}

