/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.system.render.draw.text;

import com.badlogic.ashley.core.Entity;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.PerspectiveCamera;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.IntSet;
import gaiasky.render.RenderingContext;
import gaiasky.scene.Mapper;
import gaiasky.scene.api.IFocus;
import gaiasky.scene.api.IParticleRecord;
import gaiasky.scene.camera.ICamera;
import gaiasky.scene.component.Body;
import gaiasky.scene.component.GraphNode;
import gaiasky.scene.component.GridRecursive;
import gaiasky.scene.component.GridUV;
import gaiasky.scene.component.Keyframes;
import gaiasky.scene.component.Label;
import gaiasky.scene.component.ModelScaffolding;
import gaiasky.scene.component.ParticleSet;
import gaiasky.scene.component.RefSysTransform;
import gaiasky.scene.component.SolidAngle;
import gaiasky.scene.component.StarSet;
import gaiasky.scene.system.render.draw.TextRenderer;
import gaiasky.scene.view.LabelView;
import gaiasky.util.Constants;
import gaiasky.util.DecalUtils;
import gaiasky.util.GlobalResources;
import gaiasky.util.Pair;
import gaiasky.util.Settings;
import gaiasky.util.camera.rec.Keyframe;
import gaiasky.util.color.ColorUtils;
import gaiasky.util.coord.Coordinates;
import gaiasky.util.gdx.g2d.BitmapFont;
import gaiasky.util.gdx.g2d.ExtSpriteBatch;
import gaiasky.util.gdx.shader.ExtShaderProgram;
import gaiasky.util.gravwaves.RelativisticEffectsManager;
import gaiasky.util.i18n.I18n;
import gaiasky.util.math.MathUtilsDouble;
import gaiasky.util.math.Vector3D;
import gaiasky.util.math.Vector3Q;
import java.text.DecimalFormat;
import java.util.List;
import net.jafama.FastMath;

public class LabelEntityRenderSystem {
    private final Vector3D D31 = new Vector3D();
    private final Vector3D D32 = new Vector3D();
    private final Vector3D D33 = new Vector3D();
    private final Vector3 F31 = new Vector3();
    private final Vector3 F32 = new Vector3();
    private final Vector3Q B31 = new Vector3Q();
    private static final int divisionsUV = 36;
    private static int verticalOffset = 0;
    private final DecimalFormat nf = new DecimalFormat("##0.#");
    private final double rad02 = FastMath.toRadians((double)2.0);
    private final double rad40 = FastMath.toRadians((double)40.0);

    public void renderLocation(LabelView view, ExtSpriteBatch batch, ExtShaderProgram shader, TextRenderer sys, RenderingContext rc, ICamera camera) {
        float[] color;
        Body body = view.body;
        GraphNode graph = view.graph;
        ModelScaffolding scaffolding = (ModelScaffolding)Mapper.modelScaffolding.get(graph.parent);
        float[] fArray = color = body.labelColor != null ? body.labelColor : body.color;
        if (color != null) {
            batch.setColor(color[0], color[1], color[2], color.length > 3 ? color[3] : 0.6f);
        } else {
            batch.setColor(1.0f, 1.0f, 1.0f, 0.6f);
        }
        Vector3D labelPosition = this.D31;
        view.textPosition(camera, labelPosition);
        shader.setUniformf("u_viewAngle", view.label.forceLabel ? 2.0f : (float)(body.solidAngleApparent * (double)scaffolding.locVaMultiplier * Constants.U_TO_KM));
        shader.setUniformf("u_viewAnglePow", 1.0f);
        shader.setUniformf("u_thLabel", view.label.forceLabel ? 1.0f : scaffolding.locThresholdLabel / (float)Constants.DISTANCE_SCALE_FACTOR);
        this.render3DLabel(view, batch, shader, sys.fontDistanceField, camera, rc, view.text(), labelPosition, body.distToCamera, view.textScale() * camera.getFovFactor(), view.textSize() * camera.getFovFactor(), view.getRadius(), 0.025f, 0.1f, view.label.forceLabel);
    }

    public void renderShape(LabelView view, ExtSpriteBatch batch, ExtShaderProgram shader, TextRenderer sys, RenderingContext rc, ICamera camera) {
        Body body = view.body;
        SolidAngle sa = (SolidAngle)Mapper.sa.get(view.getEntity());
        Vector3D labelPosition = this.D31;
        view.textPosition(camera, labelPosition);
        shader.setUniformf("u_viewAngle", view.label.forceLabel ? 2.0f : (float)body.solidAngle);
        shader.setUniformf("u_viewAnglePow", 1.0f);
        shader.setUniformf("u_thLabel", view.label.forceLabel ? 1.0f : (float)sa.thresholdLabel / view.label.labelBias);
        this.render3DLabel(view, batch, shader, sys.fontDistanceField, camera, rc, view.text(), labelPosition, body.distToCamera, view.textScale() * camera.getFovFactor(), view.textSize() * camera.getFovFactor(), view.getRadius(), view.label.forceLabel);
    }

    public void renderRuler(LabelView view, ExtSpriteBatch batch, ExtShaderProgram shader, TextRenderer sys, RenderingContext rc, ICamera camera) {
        Vector3D labelPosition = this.D31;
        view.textPosition(camera, labelPosition);
        shader.setUniformf("u_viewAngle", 90.0f);
        shader.setUniformf("u_viewAnglePow", 1.0f);
        shader.setUniformf("u_thLabel", 1.0f);
        this.render3DLabel(view, batch, shader, sys.fontDistanceField, camera, rc, view.text(), labelPosition, view.body.distToCamera, view.textScale() * camera.getFovFactor(), view.textSize() * camera.getFovFactor(), view.getRadius(), view.label.forceLabel);
    }

    public void renderRecursiveGrid(LabelView view, ExtSpriteBatch batch, ExtShaderProgram shader, TextRenderer sys, RenderingContext rc, ICamera camera) {
        GridRecursive gr = (GridRecursive)Mapper.gridRec.get(view.getEntity());
        Body body = view.body;
        int index = gr.annotations.size() - 1;
        for (int i = 1; i < gr.annotations.size(); ++i) {
            if (!(body.distToCamera > gr.annotations.get(i - 1).getFirst()) || !(body.distToCamera <= gr.annotations.get(i).getFirst())) continue;
            index = i;
            break;
        }
        int n = 2;
        for (int i = index - (n + 1); i < index + n - 1; ++i) {
            if (i < 0 || i >= gr.annotations.size()) continue;
            this.renderDistanceLabel(view, batch, shader, sys, rc, camera, gr.annotations.get(i).getFirst(), gr.annotations.get(i).getSecond());
        }
        if (Settings.settings.program.recursiveGrid.origin.isRefSys() && camera.hasFocus() && gr.d01 > 0.0 && gr.d02 > 0.0) {
            Settings.DistanceUnits du = Settings.settings.program.ui.distanceUnits;
            shader.setUniform4fv("u_color", gr.ccL, 0, 4);
            Pair<Double, String> d = GlobalResources.doubleToDistanceString(gr.d01, du);
            float ff = camera.getFovFactor();
            float min = 0.025f * ff;
            float max = 0.05f * ff;
            if (gr.d01 / body.distToCamera > (double)0.1f) {
                this.render3DLabel(view, batch, shader, sys.fontDistanceField, camera, rc, GlobalResources.formatNumber(d.getFirst()) + " " + d.getSecond(), gr.p01, body.distToCamera, view.textScale(), (float)(gr.d01 * 0.001 * (double)camera.getFovFactor()), view.getRadius(), min, max, view.label.forceLabel);
            }
            d = GlobalResources.doubleToDistanceString(gr.d02, du);
            if (gr.d02 / body.distToCamera > (double)0.1f) {
                this.render3DLabel(view, batch, shader, sys.fontDistanceField, camera, rc, GlobalResources.formatNumber(d.getFirst()) + " " + d.getSecond(), gr.p02, body.distToCamera, view.textScale(), (float)(gr.d02 * 0.001 * (double)camera.getFovFactor()), view.getRadius(), min, max, view.label.forceLabel);
            }
        }
    }

    private void renderDistanceLabel(LabelView view, ExtSpriteBatch batch, ExtShaderProgram shader, TextRenderer sys, RenderingContext rc, ICamera camera, double dist, String text) {
        shader.setUniformf("u_viewAngle", 90.0f);
        shader.setUniformf("u_viewAnglePow", 1.0f);
        shader.setUniformf("u_thLabel", 1.0f);
        Vector3Q v = this.B31.setZero();
        if (Settings.settings.program.recursiveGrid.origin.isFocus() && camera.hasFocus()) {
            IFocus focus = camera.getFocus();
            focus.getAbsolutePosition(v);
        }
        float ff = camera.getFovFactor();
        float min = 0.025f * ff;
        float max = 0.07f * ff;
        RefSysTransform transform = (RefSysTransform)Mapper.transform.get(view.getEntity());
        Label label = view.label;
        float size = (float)FastMath.min((double)5.0E-4, (double)(dist * 0.0025 * (double)camera.getFovFactor()));
        label.labelPosition.set(dist, 0.0, 0.0);
        if (transform.matrix != null) {
            label.labelPosition.mul(transform.matrix);
        }
        label.labelPosition.add(v).sub(camera.getPos());
        this.render3DLabel(view, batch, shader, sys.fontDistanceField, camera, rc, text, label.labelPosition.put(this.D33), view.body.distToCamera, view.textScale(), size, view.getRadius(), min, max, view.label.forceLabel);
        label.labelPosition.set(-dist, 0.0, 0.0);
        if (transform.matrix != null) {
            label.labelPosition.mul(transform.matrix);
        }
        label.labelPosition.add(v).sub(camera.getPos());
        this.render3DLabel(view, batch, shader, sys.fontDistanceField, camera, rc, text, label.labelPosition.put(this.D33), view.body.distToCamera, view.textScale(), size, view.getRadius(), min, max, view.label.forceLabel);
        label.labelPosition.set(0.0, 0.0, dist);
        if (transform.matrix != null) {
            label.labelPosition.mul(transform.matrix);
        }
        label.labelPosition.add(v).sub(camera.getPos());
        this.render3DLabel(view, batch, shader, sys.fontDistanceField, camera, rc, text, label.labelPosition.put(this.D33), view.body.distToCamera, view.textScale(), size, view.getRadius(), min, max, view.label.forceLabel);
        label.labelPosition.set(0.0, 0.0, -dist);
        if (transform.matrix != null) {
            label.labelPosition.mul(transform.matrix);
        }
        label.labelPosition.add(v).sub(camera.getPos());
        this.render3DLabel(view, batch, shader, sys.fontDistanceField, camera, rc, text, label.labelPosition.put(this.D33), view.body.distToCamera, view.textScale(), size, view.getRadius(), min, max, view.label.forceLabel);
    }

    public void renderMesh(LabelView view, ExtSpriteBatch batch, ExtShaderProgram shader, TextRenderer sys, RenderingContext rc, ICamera camera) {
        Vector3D pos = this.D31;
        view.textPosition(camera, pos);
        shader.setUniformf("u_viewAngle", 90.0f);
        shader.setUniformf("u_viewAnglePow", 1.0f);
        shader.setUniformf("u_thLabel", 1.0f);
        this.render3DLabel(view, batch, shader, sys.fontDistanceField, camera, rc, view.text(), pos, view.body.distToCamera, view.textScale() * camera.getFovFactor(), view.textSize() * camera.getFovFactor(), view.getRadius(), view.label.forceLabel);
    }

    public void renderConstellation(LabelView view, ExtSpriteBatch batch, ExtShaderProgram shader, TextRenderer sys, RenderingContext rc, ICamera camera) {
        Vector3D pos = this.D31;
        view.textPosition(camera, pos);
        shader.setUniformf("u_viewAngle", 90.0f);
        shader.setUniformf("u_viewAnglePow", 1.0f);
        shader.setUniformf("u_thLabel", 1.0f);
        this.render3DLabel(view, batch, shader, sys.fontDistanceField, camera, rc, view.text(), pos, view.body.distToCamera, view.textScale() * camera.getFovFactor(), view.textSize() * camera.getFovFactor(), view.getRadius(), view.label.forceLabel);
    }

    public void renderCelestial(LabelView view, ExtSpriteBatch batch, ExtShaderProgram shader, TextRenderer sys, RenderingContext rc, ICamera camera) {
        Vector3D pos = this.D31;
        view.textPosition(camera, pos);
        shader.setUniformf("u_viewAngle", view.label.forceLabel ? 2.0f : (float)view.body.solidAngleApparent);
        shader.setUniformf("u_viewAnglePow", view.label.forceLabel ? 1.0f : view.label.solidAnglePow);
        shader.setUniformf("u_thLabel", view.label.forceLabel ? 1.0f : (float)view.sa.thresholdLabel / view.label.labelBias);
        this.render3DLabel(view, batch, shader, sys.fontDistanceField, camera, rc, view.text(), pos, view.body.distToCamera, view.textScale() * camera.getFovFactor(), view.textSize() * camera.getFovFactor(), view.getRadius(), view.label.forceLabel);
    }

    public void renderCluster(LabelView view, ExtSpriteBatch batch, ExtShaderProgram shader, TextRenderer sys, RenderingContext rc, ICamera camera) {
        Vector3D pos = this.D31;
        view.textPosition(camera, pos);
        shader.setUniformf("u_viewAngle", view.label.forceLabel ? 2.0f : (float)view.body.solidAngle * 500.0f);
        shader.setUniformf("u_viewAnglePow", 1.0f);
        shader.setUniformf("u_thLabel", 1.0f);
        this.render3DLabel(view, batch, shader, sys.fontDistanceField, camera, rc, view.text(), pos, view.body.distToCamera, view.textScale() * camera.getFovFactor(), view.textSize() * camera.getFovFactor(), view.getRadius(), view.label.forceLabel);
    }

    public void renderBillboardSet(LabelView view, ExtSpriteBatch batch, ExtShaderProgram shader, TextRenderer sys, RenderingContext rc, ICamera camera) {
        Vector3D pos = this.D31;
        view.textPosition(camera, pos);
        shader.setUniformf("u_viewAngle", 90.0f);
        shader.setUniformf("u_viewAnglePow", 1.0f);
        shader.setUniformf("u_thLabel", 1.0f);
        this.render3DLabel(view, batch, shader, sys.fontDistanceField, camera, rc, view.text(), pos, view.body.distToCamera, view.textScale(), view.textSize() * camera.getFovFactor(), view.getRadius(), view.label.forceLabel);
    }

    public void renderParticleSet(LabelView view, ExtSpriteBatch batch, ExtShaderProgram shader, TextRenderer sys, RenderingContext rc, ICamera camera) {
        ParticleSet set = view.particleSet;
        if (view.particleSet.renderSetLabel) {
            Vector3D pos = this.D31;
            pos.set(view.label.labelPosition).add(camera.getInversePos());
            shader.setUniformf("u_viewAngle", 90.0f);
            shader.setUniformf("u_viewAnglePow", 1.0f);
            shader.setUniformf("u_thLabel", 1.0f);
            this.render3DLabel(view, batch, shader, sys.fontDistanceField, camera, rc, view.text(), pos, pos.len(), view.textScale() * 2.0f * camera.getFovFactor(), view.textSize() * camera.getFovFactor(), view.getRadius(), view.label.forceLabel);
        }
        int[] active = view.particleSet.indices;
        if (view.particleSet.renderParticleLabels && active != null) {
            float thresholdLabel = 1.0f;
            List<IParticleRecord> pointData = view.particleSet.pointData;
            int n = FastMath.min((int)pointData.size(), (int)view.particleSet.numLabels);
            for (int i = 0; i < n; ++i) {
                IParticleRecord pb;
                int idx = active[i];
                if (!(set.metadata[i] < Double.MAX_VALUE) || !set.isVisible(i) || (pb = pointData.get(idx)).names() == null) continue;
                Vector3Q particlePosition = view.particleSet.fetchPosition(pb, view.particleSet.cPosD, this.B31, view.particleSet.currDeltaYears);
                float distToCamera = (float)particlePosition.lenDouble();
                float solidAngle = 2.0E15f * (float)Constants.DISTANCE_SCALE_FACTOR / distToCamera / camera.getFovFactor();
                Vector3D labelPosition = particlePosition.put(this.D32);
                if (view.particleSet.isWireframe()) {
                    this.textPosition(camera, labelPosition, distToCamera, (double)solidAngle * 3.0E-7, 0.0);
                } else {
                    this.textPosition(camera, labelPosition, distToCamera, FastMath.min((double)view.particleSet.particleSizeLimits[1], (double)solidAngle) * 1.0E-6, 0.0);
                }
                shader.setUniformf("u_viewAngle", solidAngle);
                shader.setUniformf("u_viewAnglePow", 1.0f);
                shader.setUniformf("u_thLabel", thresholdLabel * camera.getFovFactor());
                float textSize = (float)FastMath.tanh((double)solidAngle) * distToCamera * 100000.0f;
                float alpha = FastMath.min((float)((float)FastMath.atan((double)(textSize / distToCamera))), (float)0.001f);
                float size = pb.hasSize() ? pb.size() : view.body.size;
                float sa = size / distToCamera;
                if (set.proximityLoadingFlag && set.proximityLoaded.contains(idx) && (double)sa > set.proximityThreshold * 0.5) {
                    alpha *= (float)MathUtilsDouble.lint((double)sa, set.proximityThreshold * 0.5, set.proximityThreshold * 1.5, 1.0, 0.0);
                }
                textSize = (float)FastMath.tan((double)alpha) * distToCamera * 0.5f;
                this.render3DLabel(view, batch, shader, sys.fontDistanceField, camera, rc, I18n.localize(pb.names()[0]), labelPosition, distToCamera, view.textScale() * camera.getFovFactor(), textSize * camera.getFovFactor(), view.getRadius(), view.label.forceLabel);
            }
        }
    }

    public void renderStarSet(LabelView view, ExtSpriteBatch batch, ExtShaderProgram shader, TextRenderer sys, RenderingContext rc, ICamera camera) {
        StarSet set = view.starSet;
        if (view.starSet.renderSetLabel && view.label.labelPosition != null) {
            Vector3D pos = this.D31;
            pos.set(view.label.labelPosition).add(camera.getInversePos());
            shader.setUniformf("u_viewAngle", 90.0f);
            shader.setUniformf("u_viewAnglePow", 1.0f);
            shader.setUniformf("u_thLabel", 1.0f);
            this.render3DLabel(view, batch, shader, sys.fontDistanceField, camera, rc, view.text(), pos, pos.len(), view.textScale() * 2.0f * camera.getFovFactor(), view.textSize() * camera.getFovFactor(), view.getRadius(), view.label.forceLabel);
        }
        if (view.starSet.renderParticleLabels) {
            float thresholdLabel = (float)(Settings.settings.scene.star.threshold.point / (double)Settings.settings.scene.label.number / (double)camera.getFovFactor());
            int[] active = set.indices;
            Vector3Q starPosition = this.B31;
            int n = FastMath.min((int)active.length, (int)set.numLabels);
            for (int i = 0; i < n; ++i) {
                int idx = active[i];
                if (idx < 0 || !(set.metadata[i] < Double.MAX_VALUE) || !set.isVisible(i)) continue;
                this.renderStarLabel(view, set, idx, starPosition, thresholdLabel, batch, shader, sys, rc, camera);
            }
            IntSet.IntSetIterator it = set.forceLabel.iterator();
            while (it.hasNext) {
                int i = it.next();
                if (!(set.metadata[i] < Double.MAX_VALUE) || !set.isVisible(i)) continue;
                this.renderStarLabel(view, set, i, starPosition, thresholdLabel, batch, shader, sys, rc, camera);
            }
        }
    }

    private void renderStarLabel(LabelView view, StarSet set, int idx, Vector3Q starPosition, float thresholdLabel, ExtSpriteBatch batch, ExtShaderProgram shader, TextRenderer sys, RenderingContext rc, ICamera camera) {
        float solidAngle;
        boolean visibleCamera;
        boolean forceLabel = set.forceLabel.contains(idx);
        IParticleRecord star = (IParticleRecord)set.pointData.get(idx);
        starPosition = set.fetchPosition(star, set.cPosD, starPosition, set.currDeltaYears);
        double distToCamera = starPosition.lenDouble();
        float radius = (float)set.getRadius(idx);
        if (forceLabel) {
            radius = FastMath.max((float)radius, (float)10000.0f);
        }
        if ((visibleCamera = camera.isVisible(solidAngle = (float)((double)radius / distToCamera * (double)Settings.settings.scene.star.brightness * 100.0), starPosition.put(this.D32), distToCamera)) && (forceLabel || solidAngle > thresholdLabel)) {
            Vector3D labelPosition = this.D32.set(starPosition);
            this.textPosition(camera, labelPosition, distToCamera, solidAngle / 100.0f, radius);
            shader.setUniformf("u_viewAngle", solidAngle);
            shader.setUniformf("u_viewAnglePow", 1.0f);
            shader.setUniformf("u_thLabel", thresholdLabel * camera.getFovFactor());
            shader.setUniform4fv("u_color", view.textColour(star.names()[0]), 0, 4);
            float alpha = 0.001f;
            double size = (double)star.size() * 1.31526E-6;
            double sa = size / distToCamera;
            if (set.proximityLoadingFlag && set.proximityLoaded.contains(idx) && sa > set.proximityThreshold * 0.5) {
                alpha *= (float)MathUtilsDouble.lint(sa, set.proximityThreshold * 0.5, set.proximityThreshold * 1.5, 1.0, 0.0);
            }
            double textSize = (double)alpha * distToCamera * 0.5;
            this.render3DLabel(view, batch, shader, sys.fontDistanceField, camera, rc, I18n.localize(star.names()[0]), labelPosition, distToCamera, view.textScale() * camera.getFovFactor(), textSize * (double)camera.getFovFactor(), radius, forceLabel);
        }
    }

    public static void resetVerticalOffset() {
        verticalOffset = 0;
    }

    public void renderGridAnnotations(LabelView view, ExtSpriteBatch batch, ExtShaderProgram shader, TextRenderer sys, RenderingContext rc, ICamera camera) {
        boolean paintProjectedLabels;
        float angle;
        Entity entity = view.getEntity();
        GridUV grid = (GridUV)Mapper.grid.get(entity);
        float fovFactor = camera.getFovFactor();
        float lod = 1.0f;
        if ((double)fovFactor < 0.05) {
            lod = 16.0f;
        } else if ((double)fovFactor < 0.1) {
            lod = 8.0f;
        } else if ((double)fovFactor < 0.5) {
            lod = 4.0f;
        } else if ((double)fovFactor < 0.75) {
            lod = 2.0f;
        }
        float stepAngle = 360.0f / (36.0f * lod);
        float distToCamera = (float)(1.0 * Constants.PC_TO_U);
        float textSize = (float)((Settings.settings.runtime.openXr ? 2.0E12 : 20000.0) * Constants.DISTANCE_SCALE_FACTOR);
        shader.setUniformf("u_viewAngle", 1.0f);
        shader.setUniformf("u_viewAnglePow", 1.0f);
        shader.setUniformf("u_thLabel", 0.0f);
        for (angle = 0.0f; angle < 360.0f; angle += stepAngle) {
            this.F31.set(Coordinates.sphericalToCartesian(Math.toRadians(angle), 0.0, distToCamera, this.D31).valuesF()).mul(grid.annotTransform);
            this.effectsPos(this.F31, camera);
            if (!(this.F31.dot(camera.getCamera().direction.nor()) > 0.0f)) continue;
            this.D31.set(this.F31).scl(Constants.DISTANCE_SCALE_FACTOR);
            this.render3DLabel(view, batch, shader, sys.fontDistanceField, camera, rc, this.angle(angle), this.D31, distToCamera, view.textScale() * camera.getFovFactor(), textSize * camera.getFovFactor(), 0.0, true);
        }
        for (angle = -90.0f; angle <= 90.0f; angle += stepAngle) {
            if (angle == 0.0f) continue;
            this.F31.set(Coordinates.sphericalToCartesian(0.0, FastMath.toRadians((double)angle), distToCamera, this.D31).valuesF()).mul(grid.annotTransform);
            this.effectsPos(this.F31, camera);
            if (this.F31.dot(camera.getCamera().direction.nor()) > 0.0f) {
                this.D31.set(this.F31).scl(Constants.DISTANCE_SCALE_FACTOR);
                this.render3DLabel(view, batch, shader, sys.fontDistanceField, camera, rc, this.angleSign(angle), this.D31, distToCamera, view.textScale() * camera.getFovFactor(), textSize * camera.getFovFactor(), 0.0, true);
            }
            this.F31.set(Coordinates.sphericalToCartesian(0.0, FastMath.toRadians((double)(-angle)), -distToCamera, this.D31).valuesF()).mul(grid.annotTransform);
            this.effectsPos(this.F31, camera);
            if (!(this.F31.dot(camera.getCamera().direction.nor()) > 0.0f)) continue;
            this.D31.set(this.F31).scl(Constants.DISTANCE_SCALE_FACTOR);
            this.render3DLabel(view, batch, shader, sys.fontDistanceField, camera, rc, this.angleSign(angle), this.D31, distToCamera, view.textScale() * camera.getFovFactor(), textSize * camera.getFovFactor(), 0.0, true);
        }
        boolean bl = paintProjectedLabels = !Settings.settings.program.modeCubemap.active && !Settings.settings.program.modeStereo.active;
        if (Settings.settings.program.uvGrid.frameCoordinates && paintProjectedLabels) {
            Vector3 vec = this.F31;
            Vector3D vecDouble = this.D31;
            Vector3D out = this.D32;
            PerspectiveCamera cam = camera.getCamera();
            int w = Gdx.graphics.getWidth();
            int h = Gdx.graphics.getHeight();
            float scale = (float)Math.sqrt(w * w + h * h) / 2200.0f;
            float labelSize = Settings.settings.scene.label.size * scale;
            float offsetY = (float)(verticalOffset++ * 16) * labelSize;
            Matrix4 trf = view.base.getName().contains("Ecliptic") ? Coordinates.equatorialToEclipticF() : (view.base.getName().contains("Galactic") ? Coordinates.equatorialToGalacticF() : Coordinates.idtF());
            int xStep = w / 6;
            int yStep = h / 6;
            float y = 5.0f;
            for (int xi = xStep; xi <= w - xStep; xi += xStep) {
                this.render2DLabel(batch, shader, rc, sys.fontDistanceField, "|", xi - 50, y, 0.95f * labelSize, 1);
            }
            float x = w - 5;
            for (int yi = yStep + 5; yi <= h - yStep + 5; yi += yStep) {
                this.render2DLabel(batch, shader, rc, sys.fontDistanceField, "-", x - 145.0f, yi, 0.95f * labelSize, 16);
            }
            y = 25.0f * scale + offsetY;
            for (x = (float)xStep; x <= (float)(w - xStep); x += (float)xStep) {
                vec.set(x, (float)h - y, 0.99f);
                cam.unproject(vec);
                vec.mul(trf);
                this.effectsPos(vec, camera);
                vecDouble.set(vec);
                Coordinates.cartesianToSpherical(vecDouble, out);
                String text = this.angle((float)FastMath.toDegrees((double)out.x)) + "/" + this.angleSign((float)FastMath.toDegrees((double)out.y));
                this.render2DLabel(batch, shader, rc, sys.fontDistanceField, text, x - 50.0f * scale, y, 0.45f * labelSize, 1);
            }
            yStep = h / 6;
            x = (float)w - 20.0f * scale;
            for (y = (float)yStep; y <= (float)(h - yStep); y += (float)yStep) {
                vec.set(x, (float)h - y, 0.99f);
                cam.unproject(vec);
                vec.mul(trf);
                this.effectsPos(vec, camera);
                vecDouble.set(vec);
                Coordinates.cartesianToSpherical(vecDouble, out);
                String text = this.angle((float)FastMath.toDegrees((double)out.x)) + "/" + this.angleSign((float)FastMath.toDegrees((double)out.y));
                this.render2DLabel(batch, shader, rc, sys.fontDistanceField, text, x - 145.0f, y + offsetY, 0.45f * labelSize, 16);
            }
        }
    }

    private String angle(float angle) {
        return this.nf.format(angle) + "\u00b0";
    }

    private String angleSign(float angle) {
        return (angle >= 0.0f ? "+" : "-") + this.nf.format(Math.abs(angle)) + "\u00b0";
    }

    private void effectsPos(Vector3 auxf, ICamera camera) {
        this.relativisticPos(auxf, camera);
        this.gravwavePos(auxf);
    }

    private void relativisticPos(Vector3 auxf, ICamera camera) {
        if (Settings.settings.runtime.relativisticAberration) {
            this.D31.set(auxf);
            GlobalResources.applyRelativisticAberration(this.D31, camera);
            this.D31.put(auxf);
        }
    }

    private void gravwavePos(Vector3 auxf) {
        if (Settings.settings.runtime.gravitationalWaves) {
            this.D31.set(auxf);
            RelativisticEffectsManager.getInstance().gravitationalWavePos(this.D31);
            this.D31.put(auxf);
        }
    }

    public void renderKeyframe(LabelView view, ExtSpriteBatch batch, ExtShaderProgram shader, TextRenderer sys, RenderingContext rc, ICamera camera) {
        Keyframes kf = (Keyframes)Mapper.keyframes.get(view.getEntity());
        if (kf.selected != null) {
            this.renderKeyframeLabel(view, kf, kf.selected, batch, shader, sys, rc, camera);
        }
        if (kf.highlighted != null) {
            this.renderKeyframeLabel(view, kf, kf.highlighted, batch, shader, sys, rc, camera);
        }
    }

    private void renderKeyframeLabel(LabelView view, Keyframes kfs, Keyframe kf, ExtSpriteBatch batch, ExtShaderProgram shader, TextRenderer sys, RenderingContext rc, ICamera camera) {
        Vector3D pos = this.D31;
        this.getTextPositionKeyframe(camera, pos, kf);
        float distToCam = (float)this.D32.set(kf.pos).add(camera.getInversePos()).len();
        shader.setUniformf("u_viewAngle", 90.0f);
        shader.setUniformf("u_viewAnglePow", 1.0f);
        shader.setUniformf("u_thLabel", 1.0f);
        shader.setUniform4fv("u_color", this.textColour(kfs, kf), 0, 4);
        this.render3DLabel(view, batch, shader, sys.fontDistanceField, camera, rc, this.getText(kf), pos, distToCam, view.textScale() * camera.getFovFactor(), view.textSize() * camera.getFovFactor() * distToCam, view.getRadius(), view.label.forceLabel);
    }

    public float[] textColour(Keyframes kfs, Keyframe kf) {
        if (kf == kfs.highlighted) {
            return ColorUtils.gYellow;
        }
        return ColorUtils.gPink;
    }

    private String getText(Keyframe kf) {
        return kf.name;
    }

    private void getTextPositionKeyframe(ICamera cam, Vector3D out, Keyframe kf) {
        kf.pos.put(out).add(cam.getInversePos());
        Vector3D aux = this.D32;
        aux.set(cam.getUp());
        aux.crs(out).nor();
        aux.add(cam.getUp()).nor().scl(-Math.tan(0.00872) * out.len());
        out.add(aux);
        GlobalResources.applyRelativisticAberration(out, cam);
        RelativisticEffectsManager.getInstance().gravitationalWavePos(out);
    }

    private void textPosition(ICamera cam, Vector3D out, double distToCamera, double solidAngle, double rad) {
        out.clamp(0.0, distToCamera - rad);
        Vector3D offset = this.D33;
        offset.set(cam.getUp());
        offset.crs(out).nor();
        float displacement = (float)MathUtilsDouble.flint(solidAngle, this.rad02, this.rad40, 1.0, 20.0);
        float offsetDistance = -0.02f * displacement * cam.getFovFactor() * (float)out.len();
        offset.add(cam.getUp()).nor().scl(offsetDistance);
        out.add(offset);
        GlobalResources.applyRelativisticAberration(out, cam);
        RelativisticEffectsManager.getInstance().gravitationalWavePos(out);
    }

    protected void render2DLabel(ExtSpriteBatch batch, ExtShaderProgram shader, RenderingContext rc, BitmapFont font, String label, float x, float y, float scale, int align) {
        shader.setUniformf("u_scale", scale);
        DecalUtils.drawFont2D(font, batch, rc, label, x, y, scale, align);
    }

    protected void render3DLabel(LabelView view, ExtSpriteBatch batch, ExtShaderProgram shader, BitmapFont font, ICamera camera, RenderingContext rc, String label, Vector3D pos, double distToCamera, float scale, double size, double radius, boolean forceLabel) {
        this.render3DLabel(view, batch, shader, font, camera, rc, label, pos, distToCamera, scale, size, radius, -1.0f, -1.0f, forceLabel);
    }

    protected void render3DLabel(LabelView view, ExtSpriteBatch batch, ExtShaderProgram shader, BitmapFont font, ICamera camera, RenderingContext rc, String labelText, Vector3D labelPosition, double distToCamera, float scale, double size, double radius, float minSizeDegrees, float maxSizeDegrees, boolean forceLabel) {
        shader.setUniformf("u_scale", Settings.settings.scene.label.size * scale / camera.getFovFactor());
        if (forceLabel || radius == 0.0 || distToCamera > radius * 1.3) {
            size *= (double)Settings.settings.scene.label.size;
            float rot = 0.0f;
            if (rc.cubemapSide == RenderingContext.CubemapSide.SIDE_UP || rc.cubemapSide == RenderingContext.CubemapSide.SIDE_DOWN) {
                Vector3 v1 = this.F31;
                Vector3 v2 = this.F32;
                camera.getCamera().project(v1.set((float)labelPosition.x, (float)labelPosition.y, (float)labelPosition.z));
                v1.z = 0.0f;
                v2.set((float)Gdx.graphics.getWidth() / 2.0f, (float)Gdx.graphics.getHeight() / 2.0f, 0.0f);
                rot = GlobalResources.angle2d(v1, v2) + (rc.cubemapSide == RenderingContext.CubemapSide.SIDE_UP ? 90.0f : -90.0f);
            }
            shader.setUniformf("u_pos", labelPosition);
            view.textDepthBuffer();
            DecalUtils.drawFont3D(font, batch, labelText, (float)labelPosition.x, (float)labelPosition.y, (float)labelPosition.z, size, rot, camera, !rc.isCubemap(), minSizeDegrees, maxSizeDegrees);
        }
    }
}

