/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.system.render.extract;

import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.core.Family;
import com.badlogic.ashley.systems.IteratingSystem;
import gaiasky.GaiaSky;
import gaiasky.render.RenderGroup;
import gaiasky.render.api.IRenderable;
import gaiasky.render.api.ISceneRenderer;
import gaiasky.scene.camera.ICamera;
import gaiasky.scene.component.Base;
import gaiasky.scene.view.LabelView;
import java.util.List;

public abstract class AbstractExtractSystem
extends IteratingSystem {
    protected final ICamera camera;
    protected ISceneRenderer renderer;
    protected LabelView view;
    protected List<List<IRenderable>> renderLists;

    public AbstractExtractSystem(Family family, int priority) {
        super(family, priority);
        this.camera = GaiaSky.instance.cameraManager;
        this.view = new LabelView();
    }

    public void extract(Entity entity) {
        this.processEntity(entity, 0.0f);
    }

    public void setRenderer(ISceneRenderer renderer) {
        this.renderer = renderer;
        this.renderLists = renderer.getRenderLists();
    }

    protected boolean mustRender(Base base) {
        return base.opacity > 0.0f && !base.copy && this.renderer.allOn(base.ct) && base.isVisible();
    }

    protected boolean addToRender(IRenderable renderable, RenderGroup rg) {
        try {
            return this.renderLists.get(rg.ordinal()).add(renderable);
        }
        catch (Exception e) {
            return false;
        }
    }

    protected boolean removeFromRender(IRenderable renderable, RenderGroup rg) {
        return this.renderLists.get(rg.ordinal()).remove(renderable);
    }

    protected boolean isInRender(IRenderable renderable, RenderGroup rg) {
        return this.renderLists.get(rg.ordinal()).contains(renderable);
    }

    protected boolean isInRender(IRenderable renderable, RenderGroup ... rgs) {
        boolean is = false;
        for (RenderGroup rg : rgs) {
            is = is || this.renderLists.get(rg.ordinal()).contains(renderable);
        }
        return is;
    }
}

