/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.system.render.extract;

import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.core.Family;
import gaiasky.render.RenderGroup;
import gaiasky.scene.Mapper;
import gaiasky.scene.component.Base;
import gaiasky.scene.component.Label;
import gaiasky.scene.component.Render;
import gaiasky.scene.component.RenderType;
import gaiasky.scene.system.render.draw.text.LabelEntityRenderSystem;
import gaiasky.scene.system.render.extract.AbstractExtractSystem;

public class BackgroundExtractor
extends AbstractExtractSystem {
    public BackgroundExtractor(Family family, int priority) {
        super(family, priority);
    }

    protected void processEntity(Entity entity, float deltaTime) {
        this.addToRenderLists(entity);
    }

    private void addToRenderLists(Entity entity) {
        Base base = (Base)Mapper.base.get(entity);
        if (this.mustRender(base)) {
            Render render = (Render)Mapper.render.get(entity);
            if (Mapper.grid.has(entity)) {
                this.addToRender(render, RenderGroup.MODEL_VERT_GRID);
                LabelEntityRenderSystem.resetVerticalOffset();
                this.addToRender(render, RenderGroup.FONT_LABEL);
            } else {
                Label label = (Label)Mapper.label.get(entity);
                RenderType renderType = (RenderType)Mapper.renderType.get(entity);
                this.addToRender(render, renderType.renderGroup);
                if (label.label && label.renderLabel) {
                    this.addToRender(render, RenderGroup.FONT_LABEL);
                }
            }
        }
    }
}

