/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.system.render.extract;

import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.core.Family;
import gaiasky.render.RenderGroup;
import gaiasky.scene.Mapper;
import gaiasky.scene.component.Base;
import gaiasky.scene.component.Body;
import gaiasky.scene.component.Label;
import gaiasky.scene.component.Render;
import gaiasky.scene.component.SolidAngle;
import gaiasky.scene.system.render.extract.AbstractExtractSystem;

public class ClusterExtractor
extends AbstractExtractSystem {
    public ClusterExtractor(Family family, int priority) {
        super(family, priority);
    }

    protected void processEntity(Entity entity, float deltaTime) {
        Base base = (Base)Mapper.base.get(entity);
        if (this.mustRender(base)) {
            Body body = (Body)Mapper.body.get(entity);
            Render render = (Render)Mapper.render.get(entity);
            Label label = (Label)Mapper.label.get(entity);
            SolidAngle sa = (SolidAngle)Mapper.sa.get(entity);
            if (body.solidAngleApparent >= sa.thresholdPoint) {
                this.addToRender(render, RenderGroup.MODEL_VERT_ADDITIVE);
            }
            if (label.renderLabel && body.solidAngleApparent >= sa.thresholdLabel / (double)label.labelBias || label.forceLabel) {
                this.addToRender(render, RenderGroup.FONT_LABEL);
            }
            if (body.solidAngleApparent < sa.thresholdQuad) {
                this.addToRender(render, RenderGroup.BILLBOARD_SPRITE);
            }
        }
    }
}

