/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.system.render.extract;

import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.core.Family;
import gaiasky.render.RenderGroup;
import gaiasky.render.api.ISceneRenderer;
import gaiasky.scene.Mapper;
import gaiasky.scene.component.Base;
import gaiasky.scene.component.GraphNode;
import gaiasky.scene.component.OrbitElementsSet;
import gaiasky.scene.component.Render;
import gaiasky.scene.system.render.extract.AbstractExtractSystem;
import gaiasky.scene.system.render.extract.ModelExtractor;
import gaiasky.scene.system.render.extract.TrajectoryExtractor;

public class ElementsSetExtractor
extends AbstractExtractSystem {
    private final TrajectoryExtractor trajectoryExtractor = new TrajectoryExtractor(null, 0);
    private final ModelExtractor modelExtractor = new ModelExtractor(null, 0);

    public ElementsSetExtractor(Family family, int priority) {
        super(family, priority);
    }

    @Override
    public void setRenderer(ISceneRenderer renderer) {
        super.setRenderer(renderer);
        this.trajectoryExtractor.setRenderer(renderer);
        this.modelExtractor.setRenderer(renderer);
    }

    protected void processEntity(Entity entity, float deltaTime) {
        Base base = (Base)Mapper.base.get(entity);
        GraphNode graph = (GraphNode)Mapper.graph.get(entity);
        if (this.mustRender(base)) {
            Render render = (Render)Mapper.render.get(entity);
            this.addToRender(render, RenderGroup.ORBITAL_ELEMENTS_GROUP);
        }
        if (graph.children != null) {
            OrbitElementsSet set = (OrbitElementsSet)Mapper.orbitElementsSet.get(entity);
            for (int i = 0; i < set.alwaysUpdate.size; ++i) {
                Entity child = (Entity)set.alwaysUpdate.get(i);
                this.extractSingle(child);
            }
        }
    }

    private void extractSingle(Entity entity) {
        if (Mapper.trajectory.has(entity)) {
            this.trajectoryExtractor.extractEntity(entity);
        }
        if (Mapper.model.has(entity)) {
            this.modelExtractor.extractEntity(entity);
        }
    }
}

