/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.system.render.extract;

import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.core.Family;
import gaiasky.render.RenderGroup;
import gaiasky.scene.Mapper;
import gaiasky.scene.component.Base;
import gaiasky.scene.component.Body;
import gaiasky.scene.component.Label;
import gaiasky.scene.component.Render;
import gaiasky.scene.component.SolidAngle;
import gaiasky.scene.system.render.extract.AbstractExtractSystem;

public class InvisibleExtractor
extends AbstractExtractSystem {
    public InvisibleExtractor(Family family, int priority) {
        super(family, priority);
    }

    protected void processEntity(Entity entity, float deltaTime) {
        Base base = (Base)Mapper.base.get(entity);
        Body body = (Body)Mapper.body.get(entity);
        SolidAngle sa = (SolidAngle)Mapper.sa.get(entity);
        Render render = (Render)Mapper.render.get(entity);
        Label label = (Label)Mapper.label.get(entity);
        if (this.renderText(base, body, sa, label)) {
            this.addToRender(render, RenderGroup.FONT_LABEL);
        }
    }

    private boolean renderText(Base base, Body body, SolidAngle sa, Label label) {
        return base.names != null && label.label && label.renderLabel && this.mustRender(base) && (label.forceLabel || body.solidAngleApparent >= sa.thresholdLabel / (double)label.labelBias);
    }
}

