/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.system.render.extract;

import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.core.Family;
import gaiasky.render.RenderGroup;
import gaiasky.scene.Mapper;
import gaiasky.scene.component.Base;
import gaiasky.scene.component.Keyframes;
import gaiasky.scene.component.Render;
import gaiasky.scene.component.Verts;
import gaiasky.scene.system.render.extract.AbstractExtractSystem;
import gaiasky.util.camera.rec.Camcorder;
import gaiasky.util.camera.rec.KeyframesManager;

public class KeyframeExtractor
extends AbstractExtractSystem {
    public KeyframeExtractor(Family family, int priority) {
        super(family, priority);
    }

    private void extractVerts(Entity entity) {
        Base base = (Base)Mapper.base.get(entity);
        Verts verts = (Verts)Mapper.verts.get(entity);
        if (this.mustRender(base) && verts.pointCloudData != null && verts.pointCloudData.getNumPoints() > 0) {
            Render render = (Render)Mapper.render.get(entity);
            this.addToRender(render, verts.renderGroup);
        }
    }

    protected void processEntity(Entity entity, float deltaTime) {
        Keyframes kf = (Keyframes)Mapper.keyframes.get(entity);
        if (Camcorder.instance.isPlaying() || KeyframesManager.instance.isPlaying() || KeyframesManager.instance.isStepping()) {
            return;
        }
        for (Entity object : kf.objects) {
            this.extractVerts(object);
        }
        Base base = (Base)Mapper.base.get(entity);
        if (this.mustRender(base) && (kf.selected != null || kf.highlighted != null)) {
            Render render = (Render)Mapper.render.get(entity);
            this.addToRender(render, RenderGroup.FONT_LABEL);
        }
    }
}

