/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.system.render.extract;

import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.core.Family;
import gaiasky.GaiaSky;
import gaiasky.render.RenderGroup;
import gaiasky.scene.Mapper;
import gaiasky.scene.component.Base;
import gaiasky.scene.component.Label;
import gaiasky.scene.component.Mesh;
import gaiasky.scene.component.Render;
import gaiasky.scene.system.render.extract.AbstractExtractSystem;

public class MeshExtractor
extends AbstractExtractSystem {
    public MeshExtractor(Family family, int priority) {
        super(family, priority);
    }

    protected void processEntity(Entity entity, float deltaTime) {
        Base base = (Base)Mapper.base.get(entity);
        Render render = (Render)Mapper.render.get(entity);
        Mesh mesh = (Mesh)Mapper.mesh.get(entity);
        if (this.mustRender(base) && GaiaSky.instance.isInitialised()) {
            switch (mesh.shading) {
                case ADDITIVE: {
                    this.addToRender(render, RenderGroup.MODEL_VERT_ADDITIVE);
                    break;
                }
                case REGULAR: {
                    this.addToRender(render, RenderGroup.MODEL_PIX_EARLY);
                    break;
                }
                case DUST: {
                    this.addToRender(render, RenderGroup.MODEL_PIX_DUST);
                }
            }
            if (((Label)Mapper.label.get((Entity)entity)).renderLabel) {
                this.addToRender(render, RenderGroup.FONT_LABEL);
            }
        }
    }
}

