/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.system.render.extract;

import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.core.Family;
import gaiasky.render.ComponentTypes;
import gaiasky.render.RenderGroup;
import gaiasky.render.api.IRenderable;
import gaiasky.scene.Mapper;
import gaiasky.scene.camera.ICamera;
import gaiasky.scene.component.Atmosphere;
import gaiasky.scene.component.Base;
import gaiasky.scene.component.Body;
import gaiasky.scene.component.Cloud;
import gaiasky.scene.component.Coordinates;
import gaiasky.scene.component.GraphNode;
import gaiasky.scene.component.Label;
import gaiasky.scene.component.Model;
import gaiasky.scene.component.ModelScaffolding;
import gaiasky.scene.component.Render;
import gaiasky.scene.component.RenderFlags;
import gaiasky.scene.component.RenderType;
import gaiasky.scene.component.SolidAngle;
import gaiasky.scene.system.render.extract.AbstractExtractSystem;
import gaiasky.util.Settings;
import gaiasky.util.math.MathUtilsDouble;

public class ModelExtractor
extends AbstractExtractSystem {
    public ModelExtractor(Family family, int priority) {
        super(family, priority);
    }

    protected void processEntity(Entity entity, float deltaTime) {
        this.extractEntity(entity);
    }

    public void extractEntity(Entity entity) {
        this.addToRenderLists(entity, this.camera);
    }

    protected void addToRenderLists(Entity entity, ICamera camera) {
        Base base = (Base)Mapper.base.get(entity);
        GraphNode graph = (GraphNode)Mapper.graph.get(entity);
        if (graph.parent == null) {
            return;
        }
        Coordinates coord = (Coordinates)Mapper.coordinates.get(entity);
        Coordinates parentCoord = (Coordinates)Mapper.coordinates.get(graph.parent);
        if (this.mustRender(base) && this.isValidPosition(coord) && this.isValidPosition(parentCoord)) {
            Body body = (Body)Mapper.body.get(entity);
            Model model = (Model)Mapper.model.get(entity);
            SolidAngle sa = (SolidAngle)Mapper.sa.get(entity);
            ModelScaffolding scaffolding = (ModelScaffolding)Mapper.modelScaffolding.get(entity);
            Atmosphere atmosphere = (Atmosphere)Mapper.atmosphere.get(entity);
            Cloud cloud = (Cloud)Mapper.cloud.get(entity);
            Render render = (Render)Mapper.render.get(entity);
            Label label = (Label)Mapper.label.get(entity);
            RenderFlags renderFlags = (RenderFlags)Mapper.renderFlags.get(entity);
            camera.checkClosestBody(entity);
            if (Mapper.volume.has(entity)) {
                this.addToRender(render, RenderGroup.VOLUME);
                if (this.renderText(base, body, sa, label)) {
                    this.addToRender(render, RenderGroup.FONT_LABEL);
                }
            } else if (Mapper.tagBillboardGalaxy.has(entity)) {
                double thPoint = sa.thresholdQuad * (double)camera.getFovFactor() / (double)scaffolding.sizeScaleFactor;
                if (body.solidAngleApparent >= thPoint) {
                    this.addToRender(render, RenderGroup.MODEL_DIFFUSE);
                } else if (base.opacity > 0.0f) {
                    this.addToRender(render, RenderGroup.BILLBOARD_GAL);
                }
                if (this.renderText(base, body, sa, label)) {
                    this.addToRender(render, RenderGroup.FONT_LABEL);
                }
            } else if (Mapper.tagBillboard.has(entity)) {
                if (body.solidAngleApparent >= sa.thresholdNone) {
                    this.addToRender(render, RenderGroup.MODEL_DIFFUSE);
                    if (label.renderLabel) {
                        this.addToRender(render, RenderGroup.FONT_LABEL);
                    }
                }
            } else {
                double thPoint = sa.thresholdPoint * (double)camera.getFovFactor() / (double)scaffolding.sizeScaleFactor;
                if (body.solidAngleApparent >= thPoint) {
                    double thQuad2 = sa.thresholdQuad * (double)camera.getFovFactor() * 2.0 / (double)scaffolding.sizeScaleFactor;
                    double thQuad1 = thQuad2 / 8.0 / (double)scaffolding.sizeScaleFactor;
                    scaffolding.fadeOpacity = body.solidAngleApparent < thPoint * 4.0 ? (float)MathUtilsDouble.flint(body.solidAngleApparent, thPoint, thPoint * 4.0, 1.0, 0.0) : (float)MathUtilsDouble.flint(body.solidAngleApparent, thQuad1, thQuad2, 0.0, 1.0);
                    if (body.solidAngleApparent < thQuad1) {
                        if (renderFlags == null || renderFlags.renderQuad) {
                            this.addToRender(render, RenderGroup.BILLBOARD_SSO);
                        }
                    } else if (body.solidAngleApparent > thQuad2) {
                        this.addToRenderModel(render, model);
                    } else {
                        if (renderFlags == null || renderFlags.renderQuad) {
                            this.addToRender(render, RenderGroup.BILLBOARD_SSO);
                        }
                        this.addToRenderModel(render, model);
                    }
                    if (this.renderText(base, body, sa, label)) {
                        this.addToRender(render, RenderGroup.FONT_LABEL);
                    }
                }
                if (!this.isInRender((IRenderable)render, RenderGroup.FONT_LABEL) && label.forceLabel) {
                    this.addToRender(render, RenderGroup.FONT_LABEL);
                }
                if (atmosphere != null && atmosphere.atmosphere != null && this.isInRender((IRenderable)render, RenderGroup.MODEL_PIX, RenderGroup.MODEL_PIX_TESS) && !coord.timeOverflow) {
                    this.addToRender(render, RenderGroup.MODEL_ATM);
                }
                if (cloud != null && cloud.cloud != null && this.isInRender((IRenderable)render, RenderGroup.MODEL_PIX, RenderGroup.MODEL_PIX_TESS) && !coord.timeOverflow) {
                    this.addToRender(render, RenderGroup.MODEL_CLOUD);
                }
            }
        }
    }

    private void addToRenderModel(Render render, Model model) {
        RenderType rt = (RenderType)Mapper.renderType.get(render.entity);
        RenderGroup rg = rt != null && rt.renderGroup != null ? rt.renderGroup : (this.renderTessellated(model) ? RenderGroup.MODEL_PIX_TESS : RenderGroup.MODEL_PIX);
        this.addToRender(render, rg);
    }

    private boolean renderTessellated(Model model) {
        return Settings.settings.scene.renderer.elevation.type.isTessellation() && model.model.isTessellated();
    }

    private boolean renderText(Base base, Body body, SolidAngle sa, Label label) {
        return base.names != null && label.renderLabel && this.renderer.isOn(ComponentTypes.ComponentType.Labels) && (label.forceLabel || body.solidAngleApparent >= sa.thresholdLabel / (double)label.labelBias);
    }

    private boolean isValidPosition(Coordinates coord) {
        return coord == null || !coord.timeOverflow;
    }
}

