/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.system.render.extract;

import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.core.Family;
import gaiasky.render.RenderGroup;
import gaiasky.render.api.ISceneRenderer;
import gaiasky.scene.Mapper;
import gaiasky.scene.camera.ICamera;
import gaiasky.scene.component.Base;
import gaiasky.scene.component.Octant;
import gaiasky.scene.component.Octree;
import gaiasky.scene.system.render.extract.AbstractExtractSystem;
import gaiasky.scene.system.render.extract.ParticleSetExtractor;
import gaiasky.scene.view.OctreeObjectView;
import gaiasky.util.Settings;
import gaiasky.util.tree.OctreeNode;

public class OctreeExtractor
extends AbstractExtractSystem {
    private final ParticleSetExtractor particleSetExtractor = new ParticleSetExtractor(null, 0);

    public OctreeExtractor(Family family, int priority) {
        super(family, priority);
    }

    @Override
    public void setRenderer(ISceneRenderer renderer) {
        super.setRenderer(renderer);
        this.particleSetExtractor.setRenderer(renderer);
    }

    protected void processEntity(Entity entity, float deltaTime) {
        Base base = (Base)Mapper.base.get(entity);
        Octant root = (Octant)Mapper.octant.get(entity);
        Octree octree = (Octree)Mapper.octree.get(entity);
        if (base.isVisible() && !base.copy) {
            this.extractParticleSet(octree);
            octree.roulette.clear();
            this.addToRenderLists(base, root.octant, this.camera);
        }
    }

    private void extractParticleSet(Octree octree) {
        int size = octree.roulette.size();
        for (int i = 0; i < size; ++i) {
            Entity entity = ((OctreeObjectView)octree.roulette.get(i)).getEntity();
            this.particleSetExtractor.extractEntity(entity);
        }
    }

    public void addToRenderLists(Base base, OctreeNode octant, ICamera camera) {
        boolean added;
        if (Settings.settings.runtime.drawOctree && this.mustRender(base) && (added = this.addToRender(octant, RenderGroup.LINE))) {
            for (int i = 0; i < 8; ++i) {
                OctreeNode child = octant.children[i];
                if (child == null) continue;
                this.addToRenderLists(base, child, camera);
            }
        }
    }
}

