/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.system.render.extract;

import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.core.Family;
import gaiasky.render.ComponentTypes;
import gaiasky.render.RenderGroup;
import gaiasky.scene.Mapper;
import gaiasky.scene.camera.ICamera;
import gaiasky.scene.component.Base;
import gaiasky.scene.component.Body;
import gaiasky.scene.component.Distance;
import gaiasky.scene.component.Hip;
import gaiasky.scene.component.Label;
import gaiasky.scene.component.ModelScaffolding;
import gaiasky.scene.component.ParticleExtra;
import gaiasky.scene.component.ProperMotion;
import gaiasky.scene.component.Render;
import gaiasky.scene.component.RenderType;
import gaiasky.scene.component.SolidAngle;
import gaiasky.scene.system.render.extract.AbstractExtractSystem;
import gaiasky.scene.view.FocusView;
import gaiasky.util.Settings;

public class ParticleExtractor
extends AbstractExtractSystem {
    private final FocusView view = new FocusView();

    public ParticleExtractor(Family family, int priority) {
        super(family, priority);
    }

    protected void processEntity(Entity entity, float deltaTime) {
        this.addToRenderLists(entity, this.camera);
    }

    private void addToRenderLists(Entity entity, ICamera camera) {
        this.view.setEntity(entity);
        Base base = (Base)Mapper.base.get(entity);
        camera.checkClosestParticle(this.view);
        if (this.mustRender(base)) {
            Body body = (Body)Mapper.body.get(entity);
            Render render = (Render)Mapper.render.get(entity);
            RenderType renderType = (RenderType)Mapper.renderType.get(entity);
            Hip hip = (Hip)Mapper.hip.get(entity);
            if (hip == null) {
                this.addToRenderParticle(camera, entity, body, render, renderType);
            } else {
                this.addToRenderStar(camera, entity, body, render, renderType);
            }
        }
    }

    private void addToRenderParticle(ICamera camera, Entity entity, Body body, Render render, RenderType renderType) {
        boolean hasPm;
        this.addToRender(render, renderType.renderGroup);
        boolean bl = hasPm = Mapper.pm.has(entity) && ((ProperMotion)Mapper.pm.get((Entity)entity)).hasPm;
        if (body.solidAngleApparent >= Settings.settings.scene.star.threshold.point / Settings.settings.scene.properMotion.number && hasPm) {
            this.addToRender(render, RenderGroup.LINE);
        }
        if (this.renderText(body, (SolidAngle)Mapper.sa.get(entity), (Label)Mapper.label.get(entity), (ParticleExtra)Mapper.extra.get(entity))) {
            this.addToRender(render, RenderGroup.FONT_LABEL);
        }
    }

    private void addToRenderStar(ICamera camera, Entity entity, Body body, Render render, RenderType renderType) {
        boolean hasPm;
        this.addToRender(render, RenderGroup.POINT_STAR);
        if (body.solidAngleApparent >= Settings.settings.scene.star.threshold.point) {
            this.addToRender(render, RenderGroup.BILLBOARD_STAR);
            if (Settings.settings.scene.star.renderStarSpheres && body.distToCamera < ((Distance)Mapper.distance.get((Entity)entity)).distance * (double)((ModelScaffolding)Mapper.modelScaffolding.get((Entity)entity)).sizeScaleFactor) {
                camera.checkClosestBody(entity);
                this.addToRender(render, RenderGroup.MODEL_VERT_STAR);
            }
        }
        boolean bl = hasPm = Mapper.pm.has(entity) && ((ProperMotion)Mapper.pm.get((Entity)entity)).hasPm;
        if (hasPm && body.solidAngleApparent >= Settings.settings.scene.star.threshold.point / Settings.settings.scene.properMotion.number) {
            this.addToRender(render, RenderGroup.LINE);
        }
        if (this.renderText(body, (SolidAngle)Mapper.sa.get(entity), (Label)Mapper.label.get(entity), (ParticleExtra)Mapper.extra.get(entity))) {
            this.addToRender(render, RenderGroup.FONT_LABEL);
        }
    }

    private boolean renderText(Body body, SolidAngle sa, Label label, ParticleExtra particleExtra) {
        return particleExtra.computedSize > 0.0 && label.renderLabel && this.renderer.isOn(ComponentTypes.ComponentType.Labels) && body.solidAngleApparent >= sa.thresholdLabel / (double)(label.labelBias * this.camera.getFovFactor());
    }
}

