/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.system.render.extract;

import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.core.Family;
import gaiasky.render.ComponentTypes;
import gaiasky.render.RenderGroup;
import gaiasky.scene.Mapper;
import gaiasky.scene.component.Base;
import gaiasky.scene.component.Octant;
import gaiasky.scene.component.ParticleSet;
import gaiasky.scene.component.Render;
import gaiasky.scene.component.StarSet;
import gaiasky.scene.system.render.extract.AbstractExtractSystem;
import gaiasky.util.Settings;
import net.jafama.FastMath;

public class ParticleSetExtractor
extends AbstractExtractSystem {
    public ParticleSetExtractor(Family family, int priority) {
        super(family, priority);
    }

    protected void processEntity(Entity entity, float deltaTime) {
        this.extractEntity(entity);
    }

    public void extractEntity(Entity entity) {
        Base base = (Base)Mapper.base.get(entity);
        if (this.mustRender(base)) {
            Render render = (Render)Mapper.render.get(entity);
            if (Mapper.starSet.has(entity)) {
                this.addToRenderLists(render, entity, (StarSet)Mapper.starSet.get(entity));
            } else {
                this.addToRenderLists(render);
            }
        }
    }

    private void addToRenderLists(Render render, Entity entity, StarSet starSet) {
        if (starSet.renderParticles) {
            if (starSet.variableStars) {
                this.addToRender(render, RenderGroup.VARIABLE_GROUP);
            } else {
                this.addToRender(render, RenderGroup.STAR_GROUP);
            }
            if (Settings.settings.scene.star.renderStarSpheres) {
                this.addToRender(render, RenderGroup.MODEL_VERT_STAR);
            }
            if (Settings.settings.scene.star.group.billboard) {
                this.addToRender(render, RenderGroup.BILLBOARD_STAR);
            }
        }
        if (this.renderer.isOn(ComponentTypes.ComponentType.VelocityVectors)) {
            if (Mapper.tagOctreeObject.has(entity)) {
                Octant octant = (Octant)Mapper.octant.get(entity);
                if (octant.octant.observed && octant.octant.viewAngle > FastMath.toRadians((double)117.0)) {
                    this.addToRender(render, RenderGroup.LINE);
                }
            } else {
                this.addToRender(render, RenderGroup.LINE);
            }
        }
        if (starSet.renderParticleLabels && starSet.numLabels > 0 || starSet.renderSetLabel) {
            this.addToRender(render, RenderGroup.FONT_LABEL);
        }
    }

    private void addToRenderLists(Render render) {
        ParticleSet set = (ParticleSet)Mapper.particleSet.get(render.entity);
        if (set.renderParticles) {
            if (set.isExtended) {
                if (set.isBillboard()) {
                    this.addToRender(render, RenderGroup.PARTICLE_GROUP_EXT_BILLBOARD);
                } else {
                    this.addToRender(render, RenderGroup.PARTICLE_GROUP_EXT_MODEL);
                }
            } else {
                this.addToRender(render, RenderGroup.PARTICLE_GROUP);
            }
        }
        if (set.renderParticleLabels && set.numLabels > 0 || set.renderSetLabel) {
            this.addToRender(render, RenderGroup.FONT_LABEL);
        }
    }
}

