/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.system.render.extract;

import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.core.Family;
import gaiasky.render.RenderGroup;
import gaiasky.scene.Mapper;
import gaiasky.scene.component.Base;
import gaiasky.scene.component.Label;
import gaiasky.scene.component.Model;
import gaiasky.scene.component.Render;
import gaiasky.scene.component.RenderType;
import gaiasky.scene.system.render.extract.AbstractExtractSystem;

public class ShapeExtractor
extends AbstractExtractSystem {
    public ShapeExtractor(Family family, int priority) {
        super(family, priority);
    }

    protected void processEntity(Entity entity, float deltaTime) {
        Base base = (Base)Mapper.base.get(entity);
        Render render = (Render)Mapper.render.get(entity);
        Label label = (Label)Mapper.label.get(entity);
        boolean mustRender = this.mustRender(base);
        if (mustRender) {
            RenderType renderType = (RenderType)Mapper.renderType.get(entity);
            Model model = (Model)Mapper.model.get(entity);
            if (model.model != null) {
                this.addToRender(render, renderType.renderGroup != null ? renderType.renderGroup : RenderGroup.MODEL_VERT_ADDITIVE);
            }
        }
        if (mustRender && label.renderLabel || label.forceLabel) {
            this.addToRender(render, RenderGroup.FONT_LABEL);
        }
    }
}

