/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.system.render.extract;

import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.core.Family;
import gaiasky.render.ComponentTypes;
import gaiasky.render.RenderGroup;
import gaiasky.scene.Mapper;
import gaiasky.scene.camera.ICamera;
import gaiasky.scene.component.Base;
import gaiasky.scene.component.Body;
import gaiasky.scene.component.Label;
import gaiasky.scene.component.Render;
import gaiasky.scene.component.Trajectory;
import gaiasky.scene.component.Verts;
import gaiasky.scene.entity.EntityUtils;
import gaiasky.scene.entity.TrajectoryUtils;
import gaiasky.scene.system.render.extract.AbstractExtractSystem;
import gaiasky.util.Settings;
import gaiasky.util.math.MathUtilsDouble;

public class TrajectoryExtractor
extends AbstractExtractSystem {
    protected static final float SHADER_MODEL_OVERLAP_FACTOR = 20.0f;
    private final TrajectoryUtils utils = new TrajectoryUtils();

    public TrajectoryExtractor(Family family, int priority) {
        super(family, priority);
    }

    protected void processEntity(Entity entity, float deltaTime) {
        this.extractEntity(entity);
    }

    public void extractEntity(Entity entity) {
        this.addToRenderLists(entity, this.camera);
    }

    protected void addToRenderLists(Entity entity, ICamera camera) {
        Base base = (Base)Mapper.base.get(entity);
        if (this.mustRender(base)) {
            Trajectory trajectory = (Trajectory)Mapper.trajectory.get(entity);
            Body body = (Body)Mapper.body.get(entity);
            Render render = (Render)Mapper.render.get(entity);
            Label label = (Label)Mapper.label.get(entity);
            if (trajectory.bodyRepresentation.isOrbit()) {
                Verts verts = (Verts)Mapper.verts.get(entity);
                if (trajectory.body != null && EntityUtils.isCoordinatesTimeOverflow(trajectory.body)) {
                    return;
                }
                boolean added = false;
                float angleLimit = (float)Settings.settings.scene.renderer.orbitSolidAngleThreshold * camera.getFovFactor();
                float angleLimitUp = angleLimit * 20.0f;
                if (body.solidAngle > (double)angleLimit) {
                    trajectory.alpha = body.solidAngle < (double)angleLimitUp ? MathUtilsDouble.flint(body.solidAngle, angleLimit, angleLimitUp, 0.0, body.color[3]) : (double)body.color[3];
                    if (trajectory.body == null) {
                        this.addToRender(render, verts.renderGroup);
                        added = true;
                    } else {
                        Body bodyBody = (Body)Mapper.body.get(trajectory.body);
                        if (bodyBody.distToCamera > (double)trajectory.distDown) {
                            if (bodyBody.distToCamera < (double)trajectory.distUp) {
                                trajectory.alpha *= MathUtilsDouble.lint(bodyBody.distToCamera, (double)(trajectory.distDown / camera.getFovFactor()), (double)(trajectory.distUp / camera.getFovFactor()), 0.0, 1.0);
                            }
                            this.addToRender(render, verts.renderGroup);
                            added = true;
                        }
                    }
                }
                if (verts.pointCloudData == null || added) {
                    this.utils.refreshOrbit(trajectory, verts, false);
                }
            }
            if (trajectory.body == null && !trajectory.isInOrbitalElementsGroup && base.ct.get(ComponentTypes.ComponentType.Asteroids.ordinal()) && this.renderer.isOn(ComponentTypes.ComponentType.Asteroids)) {
                this.addToRender(render, RenderGroup.ORBITAL_ELEMENTS_PARTICLE);
            }
            if (label.renderLabel && label.forceLabel) {
                this.addToRender(render, RenderGroup.FONT_LABEL);
            }
        }
    }
}

