/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.system.render.pass;

import com.badlogic.ashley.core.Entity;
import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.math.Vector3;
import gaiasky.GaiaSky;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.render.RenderAssets;
import gaiasky.render.RenderGroup;
import gaiasky.render.api.IRenderable;
import gaiasky.scene.Mapper;
import gaiasky.scene.api.IFocus;
import gaiasky.scene.camera.ICamera;
import gaiasky.scene.component.Model;
import gaiasky.scene.component.Render;
import gaiasky.scene.entity.EntityUtils;
import gaiasky.scene.system.render.SceneRenderer;
import gaiasky.scene.system.render.draw.model.ModelEntityRenderSystem;
import gaiasky.scene.system.render.pass.RenderPass;
import gaiasky.util.Settings;
import gaiasky.util.gdx.IntModelBatch;
import gaiasky.util.gdx.model.gltf.scene3d.lights.DirectionalShadowLight;
import gaiasky.util.gdx.model.gltf.scene3d.scene.CascadeShadowMap;
import gaiasky.util.gdx.shader.attribute.Attribute;
import gaiasky.util.math.Vector3Q;
import java.util.List;

public class CascadedShadowMapRenderPass
extends RenderPass {
    public static final int CASCADE_COUNT = 10;
    private static final double SPLIT_DIVISOR = 3.0;
    private static final double LIGHT_DEPTH_FACTOR = 1.8;
    private final ModelEntityRenderSystem modelRenderer;
    private final CascadeShadowMap cascadeShadowMap;
    private DirectionalShadowLight baseLight;
    private final Vector3Q aux1b = new Vector3Q();
    private final Vector3Q aux2b = new Vector3Q();
    private final Vector3 aux = new Vector3();
    private final Color color = new Color();
    private static boolean DEBUG_UI_VIEW = false;
    private static final int NUM_UI_VIEW = 9;

    public CascadedShadowMapRenderPass(SceneRenderer sceneRenderer) {
        super(sceneRenderer);
        this.modelRenderer = new ModelEntityRenderSystem(sceneRenderer);
        this.cascadeShadowMap = new CascadeShadowMap(10);
    }

    @Override
    protected void initializeRenderPass() {
        this.baseLight = new DirectionalShadowLight(Settings.settings.scene.renderer.shadow.resolution, Settings.settings.scene.renderer.shadow.resolution);
    }

    @Override
    protected void renderPass(ICamera camera, Object ... params) {
        RenderAssets renderAssets = this.sceneRenderer.getRenderAssets();
        List<IRenderable> models = this.sceneRenderer.getRenderLists().get(RenderGroup.MODEL_PIX.ordinal());
        List<IRenderable> modelsTess = this.sceneRenderer.getRenderLists().get(RenderGroup.MODEL_PIX_TESS.ordinal());
        IFocus l = camera.getCloseLightSource(0);
        l.getAbsolutePosition(this.aux1b);
        if (!models.isEmpty()) {
            Entity firstModel = ((Render)models.getFirst()).getEntity();
            EntityUtils.getAbsolutePosition(firstModel, this.aux2b);
            this.aux1b.sub(this.aux2b).nor().put(this.aux).scl(-1.0f);
            Camera cameraLight = this.baseLight.getCamera();
            this.baseLight.direction.set(this.aux);
            cameraLight.direction.set(this.aux);
            if (cameraLight.direction.y != 0.0f || cameraLight.direction.z != 0.0f) {
                this.aux.set(1.0f, 0.0f, 0.0f);
            } else {
                this.aux.set(0.0f, 1.0f, 0.0f);
            }
            cameraLight.up.set(cameraLight.direction).crs(this.aux);
            float[] col = l.getColor();
            this.color.set(col[0], col[1], col[2], 1.0f);
            this.baseLight.baseColor.set(this.color);
            this.baseLight.color.set(this.color);
            this.cascadeShadowMap.setCascades(camera, this.baseLight, 1.8, 3.0);
            for (DirectionalShadowLight light : this.cascadeShadowMap.lights) {
                light.begin();
                this.renderDepth(light, camera, renderAssets.mbPixelLightingDepth, models);
                this.renderDepth(light, camera, renderAssets.mbPixelLightingDepthTessellation, modelsTess);
                light.end();
            }
            if (DEBUG_UI_VIEW) {
                GaiaSky.postRunnable(() -> {
                    int i = 0;
                    for (DirectionalShadowLight light : this.cascadeShadowMap.lights) {
                        EventManager.publish(Event.SHOW_TEXTURE_WINDOW_ACTION, this, "CSM " + i, light.getDepthMap().texture, Float.valueOf(0.15f));
                        if (++i < 9) continue;
                        break;
                    }
                });
                DEBUG_UI_VIEW = false;
            }
        }
    }

    public void renderDepth(DirectionalShadowLight light, ICamera camera, IntModelBatch batch, List<IRenderable> list) {
        batch.begin(light.getCamera());
        for (IRenderable r : list) {
            Entity entity = ((Render)r).entity;
            Model model = (Model)Mapper.model.get(entity);
            if (!model.model.hasPointLight(0)) continue;
            this.modelRenderer.render(entity, batch, camera, 1.0f, 0.0, null, RenderGroup.MODEL_PIX, false);
            model.model.env.set((Attribute)this.cascadeShadowMap.attribute);
            model.model.env.shadowMap = light;
        }
        batch.end();
    }

    public void disposeCachedFrameBuffers() {
        this.cascadeShadowMap.dispose();
    }

    @Override
    public void dispose() {
        this.disposeCachedFrameBuffers();
    }
}

