/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.system.render.pass;

import com.badlogic.ashley.core.Entity;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.glutils.FrameBuffer;
import com.badlogic.gdx.graphics.glutils.GLFrameBuffer;
import com.badlogic.gdx.utils.Array;
import gaiasky.GaiaSky;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.render.RenderAssets;
import gaiasky.render.RenderGroup;
import gaiasky.render.api.IRenderable;
import gaiasky.render.process.RenderModeOpenXR;
import gaiasky.render.system.LightPositionUpdater;
import gaiasky.render.util.GaiaSkyFrameBuffer;
import gaiasky.scene.Mapper;
import gaiasky.scene.camera.ICamera;
import gaiasky.scene.component.Render;
import gaiasky.scene.system.render.SceneRenderer;
import gaiasky.scene.system.render.draw.BillboardRenderer;
import gaiasky.scene.system.render.pass.RenderPass;
import gaiasky.util.Settings;
import java.util.ArrayList;
import java.util.List;
import org.lwjgl.opengl.GL40;

public class LightGlowRenderPass
extends RenderPass {
    private FrameBuffer occlusionFrameBuffer;
    private final List<IRenderable> stars;
    private final LightPositionUpdater lpu;
    private final Array<Entity> controllers = new Array();
    private BillboardRenderer billboardStarsRenderer = null;
    private boolean DEBUG_UI_VIEW = false;

    public LightGlowRenderPass(SceneRenderer sceneRenderer) {
        super(sceneRenderer);
        this.stars = new ArrayList<IRenderable>();
        this.lpu = new LightPositionUpdater();
    }

    @Override
    protected void initializeRenderPass() {
        this.buildLightGlowData();
    }

    public void buildLightGlowData() {
        if (this.occlusionFrameBuffer == null) {
            GLFrameBuffer.FrameBufferBuilder fbb = new GLFrameBuffer.FrameBufferBuilder(1920, 1080);
            fbb.addBasicColorTextureAttachment(Pixmap.Format.RGBA8888);
            fbb.addBasicDepthRenderBuffer();
            this.occlusionFrameBuffer = new GaiaSkyFrameBuffer((GLFrameBuffer.GLFrameBufferBuilder<? extends GLFrameBuffer<Texture>>)fbb, 0, 1);
        }
    }

    @Override
    protected void renderPass(ICamera camera, Object ... params) {
        FrameBuffer frameBuffer = params == null || params.length == 0 ? this.occlusionFrameBuffer : (FrameBuffer)params[0];
        if (Settings.settings.postprocess.lightGlow.active && frameBuffer != null) {
            List<List<IRenderable>> renderLists = this.sceneRenderer.getRenderLists();
            RenderAssets renderAssets = this.sceneRenderer.getRenderAssets();
            List<IRenderable> billboardStars = renderLists.get(RenderGroup.BILLBOARD_STAR.ordinal());
            this.stars.clear();
            for (IRenderable st : billboardStars) {
                if (!(st instanceof Render) || !Mapper.hip.has(((Render)st).getEntity())) continue;
                this.stars.add(st);
            }
            List<IRenderable> models = renderLists.get(RenderGroup.MODEL_PIX.ordinal());
            List<IRenderable> modelsTess = renderLists.get(RenderGroup.MODEL_PIX_TESS.ordinal());
            if (Settings.settings.runtime.openXr) {
                RenderModeOpenXR sgrVR = this.sceneRenderer.getRenderModeOpenXR();
                if (this.sceneRenderer.getVrContext() != null) {
                    for (Entity m : sgrVR.controllerObjects) {
                        Render render = (Render)Mapper.render.get(m);
                        if (models.contains(render)) continue;
                        this.controllers.add((Object)m);
                    }
                }
            }
            if (this.billboardStarsRenderer == null) {
                this.billboardStarsRenderer = (BillboardRenderer)this.sceneRenderer.getOrInitializeRenderSystem(RenderGroup.BILLBOARD_STAR);
            }
            frameBuffer.begin();
            Gdx.gl.glClear(16640);
            renderAssets.mbPixelLightingOpaque.begin((Camera)camera.getCamera());
            for (IRenderable model : models) {
                this.sceneRenderer.renderModel(model, renderAssets.mbPixelLightingOpaque);
            }
            renderAssets.mbPixelLightingOpaque.end();
            if (!modelsTess.isEmpty()) {
                renderAssets.mbPixelLightingOpaqueTessellation.begin((Camera)camera.getCamera());
                for (IRenderable model : modelsTess) {
                    this.sceneRenderer.renderModel(model, renderAssets.mbPixelLightingOpaqueTessellation);
                }
                renderAssets.mbPixelLightingOpaqueTessellation.end();
            }
            if (this.billboardStarsRenderer != null) {
                Gdx.gl.glEnable(3042);
                GL40.glBlendFunc((int)1, (int)1);
                Gdx.gl.glEnable(2929);
                Gdx.gl.glDepthMask(false);
                this.billboardStarsRenderer.renderStud(this.stars, camera, 0.0);
                Gdx.gl.glDisable(3042);
                Gdx.gl.glDisable(2929);
                Gdx.gl.glDepthMask(true);
            }
            this.lpu.setOcclusionTexture((Texture)frameBuffer.getColorBufferTexture());
            frameBuffer.end();
            if (this.DEBUG_UI_VIEW) {
                GaiaSky.postRunnable(() -> EventManager.publish(Event.SHOW_TEXTURE_WINDOW_ACTION, this, "SVT tile detection", this.occlusionFrameBuffer, Float.valueOf(0.5f), false, true));
                this.DEBUG_UI_VIEW = false;
            }
        }
    }

    public FrameBuffer getOcclusionFrameBuffer() {
        return this.occlusionFrameBuffer;
    }

    public LightPositionUpdater getLpu() {
        return this.lpu;
    }

    @Override
    public void dispose() {
        if (this.occlusionFrameBuffer != null) {
            this.occlusionFrameBuffer.dispose();
        }
    }
}

