/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.system.render.pass;

import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.utils.Disposable;
import gaiasky.scene.camera.ICamera;
import gaiasky.scene.system.render.SceneRenderer;
import java.util.function.Supplier;

public abstract class RenderPass
implements Disposable {
    protected final SceneRenderer sceneRenderer;
    protected boolean enabled;
    protected Supplier<Boolean> condition;

    public RenderPass(SceneRenderer renderer, boolean enabled, Supplier<Boolean> condition) {
        this.sceneRenderer = renderer;
        this.enabled = enabled;
        this.condition = condition;
    }

    public RenderPass(SceneRenderer renderer, Supplier<Boolean> condition) {
        this(renderer, true, condition);
    }

    public RenderPass(SceneRenderer renderer) {
        this(renderer, true, null);
    }

    public void setCondition(Supplier<Boolean> condition) {
        this.condition = condition;
    }

    public void removeCondition() {
        this.condition = null;
    }

    public void enable() {
        this.setEnabled(true);
    }

    public void disable() {
        this.setEnabled(false);
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    protected abstract void initializeRenderPass();

    public void initialize() {
        if (this.enabled && (this.condition == null || this.condition.get().booleanValue())) {
            this.initializeRenderPass();
        }
    }

    public void doneLoading(AssetManager manager) {
    }

    protected abstract void renderPass(ICamera var1, Object ... var2);

    public final void render(ICamera camera, Object ... params) {
        if (this.enabled && (this.condition == null || this.condition.get().booleanValue())) {
            this.renderPass(camera, params);
        }
    }

    public abstract void dispose();
}

