/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.system.render.pass;

import com.badlogic.ashley.core.Entity;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.glutils.FrameBuffer;
import com.badlogic.gdx.graphics.glutils.GLFrameBuffer;
import com.badlogic.gdx.utils.Array;
import gaiasky.GaiaSky;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.render.BlendMode;
import gaiasky.render.RenderAssets;
import gaiasky.render.RenderGroup;
import gaiasky.render.api.IRenderable;
import gaiasky.render.util.GaiaSkyFrameBuffer;
import gaiasky.scene.Mapper;
import gaiasky.scene.camera.ICamera;
import gaiasky.scene.component.Base;
import gaiasky.scene.component.Cloud;
import gaiasky.scene.component.Model;
import gaiasky.scene.component.Render;
import gaiasky.scene.record.ModelComponent;
import gaiasky.scene.system.render.SceneRenderer;
import gaiasky.scene.system.render.pass.RenderPass;
import gaiasky.scene.view.ModelView;
import gaiasky.util.GaiaSkyAssets;
import gaiasky.util.Settings;
import gaiasky.util.svt.SVTManager;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL30;

public class SVTRenderPass
extends RenderPass {
    public static float SVT_TILE_DETECTION_REDUCTION_FACTOR = (float)Settings.settings.scene.renderer.virtualTextures.detectionBufferFactor;
    private final ModelView view;
    private final Array<IRenderable> candidates;
    private final Array<IRenderable> candidatesTess;
    private final Array<IRenderable> candidatesCloud;
    private FrameBuffer frameBuffer;
    private FloatBuffer pixels;
    private SVTManager svtManager;
    private final AtomicBoolean candidatesReady = new AtomicBoolean(false);
    private final AtomicBoolean frameBufferReady = new AtomicBoolean(false);
    private final AtomicBoolean pixelsReady = new AtomicBoolean(false);
    private boolean DEBUG_UI_VIEW = false;
    private final RenderGroup[] renderGroups = new RenderGroup[]{RenderGroup.MODEL_PIX, RenderGroup.MODEL_PIX_TESS};
    BlendMode blendBak = null;

    public SVTRenderPass(SceneRenderer sceneRenderer) {
        super(sceneRenderer);
        this.view = new ModelView();
        this.candidates = new Array();
        this.candidatesTess = new Array();
        this.candidatesCloud = new Array();
    }

    @Override
    protected void initializeRenderPass() {
        int w = (int)((float)Gdx.graphics.getWidth() / SVT_TILE_DETECTION_REDUCTION_FACTOR);
        int h = (int)((float)Gdx.graphics.getHeight() / SVT_TILE_DETECTION_REDUCTION_FACTOR);
        GLFrameBuffer.FrameBufferBuilder frameBufferBuilder = new GLFrameBuffer.FrameBufferBuilder(w, h);
        frameBufferBuilder.addFloatAttachment(34836, 6408, 5126, false);
        frameBufferBuilder.addDepthRenderBuffer(33189);
        this.frameBuffer = new GaiaSkyFrameBuffer((GLFrameBuffer.GLFrameBufferBuilder<? extends GLFrameBuffer<Texture>>)frameBufferBuilder, 0);
        this.pixels = BufferUtils.createFloatBuffer((int)(w * h * 4));
    }

    @Override
    public void doneLoading(AssetManager manager) {
        this.svtManager = ((GaiaSkyAssets)manager.get((String)"gaiasky-assets", GaiaSkyAssets.class)).svtManager;
    }

    private void fetchCandidates(RenderGroup renderGroup, Array<IRenderable> candidates) {
        List<IRenderable> models = this.sceneRenderer.getRenderLists().get(renderGroup.ordinal());
        candidates.clear();
        models.forEach(e -> {
            this.view.setEntity(((Render)e).getEntity());
            if (this.view.hasSVTNoCloud()) {
                candidates.add(e);
            }
        });
    }

    private void fetchCandidatesCloud(RenderGroup[] renderGroups, Array<IRenderable> candidates) {
        ArrayList models = new ArrayList();
        for (RenderGroup rg : renderGroups) {
            models.addAll(this.sceneRenderer.getRenderLists().get(rg.ordinal()));
        }
        candidates.clear();
        models.forEach(e -> {
            this.view.setEntity(((Render)e).getEntity());
            if (!this.view.hasSVTNoCloud() && this.view.hasSVTCloud()) {
                candidates.add(e);
            }
        });
    }

    @Override
    protected void renderPass(ICamera camera, Object ... params) {
        long f = GaiaSky.instance.frames % 5L;
        switch ((int)f) {
            case 0: {
                this.stage0();
                break;
            }
            case 1: {
                this.stage1(camera);
                break;
            }
            case 2: {
                this.stage2();
                break;
            }
            case 3: {
                this.stage3();
                break;
            }
            case 4: {
                this.stage4();
            }
        }
    }

    private void stage0() {
        this.fetchCandidates(this.renderGroups[0], this.candidates);
        this.fetchCandidates(this.renderGroups[1], this.candidatesTess);
        this.fetchCandidatesCloud(this.renderGroups, this.candidatesCloud);
        this.candidatesReady.set(!this.candidates.isEmpty() || !this.candidatesTess.isEmpty() || !this.candidatesCloud.isEmpty());
    }

    private void stage1(ICamera camera) {
        if (!this.candidatesReady.get()) {
            return;
        }
        int rendered = 0;
        RenderAssets renderAssets = this.sceneRenderer.getRenderAssets();
        this.frameBuffer.begin();
        Gdx.gl.glEnable(2929);
        Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        Gdx.gl.glClear(16640);
        if (!this.candidates.isEmpty() || !this.candidatesCloud.isEmpty()) {
            renderAssets.mbPixelLightingSvtDetection.begin((Camera)camera.getCamera());
            for (IRenderable candidate : this.candidates) {
                this.pushBlend(candidate);
                this.sceneRenderer.renderModel(candidate, renderAssets.mbPixelLightingSvtDetection);
                this.popBlend(candidate);
                ++rendered;
            }
            for (IRenderable candidate : this.candidatesCloud) {
                Entity e = ((Render)candidate).getEntity();
                Model m = (Model)Mapper.model.get(e);
                Cloud c = (Cloud)Mapper.cloud.get(e);
                if (!c.cloud.hasSVT()) continue;
                this.sceneRenderer.getModelRenderSystem().renderClouds(e, (Base)Mapper.base.get(e), m, c, renderAssets.mbPixelLightingSvtDetection, 1.0f, 0.0);
                ++rendered;
            }
            renderAssets.mbPixelLightingSvtDetection.end();
        }
        if (!this.candidatesTess.isEmpty()) {
            renderAssets.mbPixelLightingSvtDetectionTessellation.begin((Camera)camera.getCamera());
            for (IRenderable candidate : this.candidatesTess) {
                this.pushBlend(candidate);
                this.sceneRenderer.renderModel(candidate, renderAssets.mbPixelLightingSvtDetectionTessellation);
                this.popBlend(candidate);
                ++rendered;
            }
            renderAssets.mbPixelLightingSvtDetectionTessellation.end();
        }
        this.frameBuffer.end();
        if (rendered > 0) {
            this.frameBufferReady.set(true);
        }
        this.candidatesReady.set(false);
    }

    private void stage2() {
        if (!this.frameBufferReady.get()) {
            return;
        }
        ((Texture)this.frameBuffer.getColorBufferTexture()).bind();
        GL30.glGetTexImage((int)((Texture)this.frameBuffer.getColorBufferTexture()).glTarget, (int)0, (int)6408, (int)5126, (FloatBuffer)this.pixels);
        if (this.DEBUG_UI_VIEW) {
            GaiaSky.postRunnable(() -> EventManager.publish(Event.SHOW_TEXTURE_WINDOW_ACTION, this, "SVT tile detection", this.frameBuffer));
            this.DEBUG_UI_VIEW = false;
        }
        this.pixelsReady.set(true);
        this.frameBufferReady.set(false);
    }

    private void stage3() {
        if (!this.pixelsReady.get()) {
            return;
        }
        this.svtManager.updateObservedTiles(this.pixels);
        this.pixelsReady.set(false);
    }

    private void stage4() {
        this.svtManager.processObservedTiles();
    }

    private void pushBlend(IRenderable candidate) {
        Model modelComponent = (Model)Mapper.model.get(((Render)candidate).entity);
        ModelComponent model = modelComponent.model;
        this.blendBak = model.getBlendMode();
        model.setBlendMode(BlendMode.NONE);
    }

    private void popBlend(IRenderable candidate) {
        Model modelComponent = (Model)Mapper.model.get(((Render)candidate).entity);
        ModelComponent model = modelComponent.model;
        model.setBlendMode(this.blendBak);
    }

    @Override
    public void dispose() {
        if (this.frameBuffer != null) {
            this.frameBuffer.dispose();
        }
    }
}

