/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.system.render.pass;

import com.badlogic.ashley.core.Entity;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.PerspectiveCamera;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.glutils.FrameBuffer;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.IntSet;
import gaiasky.GaiaSky;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.render.RenderAssets;
import gaiasky.render.RenderGroup;
import gaiasky.render.RenderingContext;
import gaiasky.render.api.IRenderable;
import gaiasky.scene.Mapper;
import gaiasky.scene.camera.ICamera;
import gaiasky.scene.component.Base;
import gaiasky.scene.component.Body;
import gaiasky.scene.component.Model;
import gaiasky.scene.component.ModelScaffolding;
import gaiasky.scene.component.Render;
import gaiasky.scene.entity.EntityUtils;
import gaiasky.scene.system.render.SceneRenderer;
import gaiasky.scene.system.render.draw.model.ModelEntityRenderSystem;
import gaiasky.scene.system.render.pass.RenderPass;
import gaiasky.util.Constants;
import gaiasky.util.Settings;
import gaiasky.util.math.BoundingBoxDouble;
import gaiasky.util.math.IntersectorDouble;
import gaiasky.util.math.Vector3D;
import gaiasky.util.math.Vector3Q;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.jafama.FastMath;

public class ShadowMapRenderPass
extends RenderPass {
    private static final int NUM_SHADOW_CASTING_LIGHTS = 1;
    private static final boolean GLOBAL_SM = false;
    private final ModelEntityRenderSystem modelRenderer;
    private PerspectiveCamera cameraLightIndividual;
    private PerspectiveCamera cameraLightGlobal;
    private List<Entity> shadowCandidates;
    private Set<Entity> shadowMapEntities;
    private final BoundingBoxDouble box = new BoundingBoxDouble();
    private FrameBuffer globalFrameBuffer;
    private static boolean DEBUG_UI_VIEW_GLOBAL = false;
    private static final boolean DEBUG_UI_VIEW_LOCAL = false;
    private static final IntSet DEBUG_UI_VIEW_LOCAL_SET = new IntSet();
    private Vector3 aux1;
    private Vector3D aux1d;
    private Vector3D aux2d;
    private Vector3D aux3d;
    private Vector3Q aux1b;
    private Vector3Q aux2b;
    int prevCandidates = 0;

    public ShadowMapRenderPass(SceneRenderer sceneRenderer) {
        super(sceneRenderer);
        this.modelRenderer = new ModelEntityRenderSystem(sceneRenderer);
    }

    @Override
    protected void initializeRenderPass() {
        this.cameraLightIndividual = new PerspectiveCamera(0.5f, (float)Settings.settings.scene.renderer.shadow.resolution, (float)Settings.settings.scene.renderer.shadow.resolution);
        this.cameraLightGlobal = new PerspectiveCamera(0.5f, (float)Settings.settings.scene.renderer.shadow.resolution, (float)Settings.settings.scene.renderer.shadow.resolution);
        this.shadowMapEntities = new HashSet<Entity>();
        this.aux1 = new Vector3();
        this.aux1d = new Vector3D();
        this.aux2d = new Vector3D();
        this.aux3d = new Vector3D();
        this.aux1b = new Vector3Q();
        this.aux2b = new Vector3Q();
        this.buildShadowMapData();
    }

    public void buildShadowMapData() {
        this.shadowMapEntities.forEach(entity -> {
            ModelScaffolding scaffolding = (ModelScaffolding)Mapper.modelScaffolding.get(entity);
            if (scaffolding != null && scaffolding.shadowMapFb != null) {
                scaffolding.shadowMapFb.dispose();
                scaffolding.shadowMapFb = null;
            }
        });
        this.shadowMapEntities.clear();
        if (this.shadowCandidates == null) {
            this.shadowCandidates = new ArrayList<Entity>(Settings.settings.scene.renderer.shadow.number);
        }
        this.shadowCandidates.clear();
    }

    private FrameBuffer newShadowMapFrameBuffer(Entity entity) {
        if (entity != null) {
            this.shadowMapEntities.add(entity);
        }
        return new FrameBuffer(Pixmap.Format.RGBA8888, Settings.settings.scene.renderer.shadow.resolution, Settings.settings.scene.renderer.shadow.resolution, true);
    }

    private void renderShadowMapGlobal(List<IRenderable> candidates, ICamera camera) {
        if (!candidates.isEmpty()) {
            if (this.prevCandidates != candidates.size()) {
                System.out.println("Candidates: " + candidates.size());
                this.prevCandidates = candidates.size();
            }
            RenderAssets renderAssets = this.sceneRenderer.getRenderAssets();
            Entity first = ((Render)candidates.get((int)0)).entity;
            Model model = (Model)Mapper.model.get(first);
            this.box.inf();
            double greatestSpan = 0.0;
            for (IRenderable render : candidates) {
                Entity entity = ((Render)render).entity;
                Vector3Q entityAbsPos = EntityUtils.getAbsolutePosition(entity, this.aux1b);
                this.box.ext(entityAbsPos.put(this.aux1d));
                double entitySpan = EntityUtils.getModelSpan(entity);
                if (!(greatestSpan < entitySpan)) continue;
                greatestSpan = entitySpan;
            }
            Vector3D boxCenterAbsPos = this.box.getCenter(this.aux1d);
            Vector3 lightDir = this.aux1;
            if (model.model.hasDirLight(0)) {
                lightDir.set(model.model.dirLight((int)0).direction);
            } else if (model.model.hasPointLight(0)) {
                lightDir.set(model.model.pointLight((int)0).position);
                this.aux2b.set(boxCenterAbsPos).sub(lightDir).nor().put(lightDir);
            }
            double boxDimension = candidates.size() == 1 ? this.box.getGreatestDim() + greatestSpan : this.box.getGreatestDim();
            double distCamCenter = boxDimension / FastMath.tan((double)FastMath.toRadians((double)this.cameraLightGlobal.fieldOfView)) * 1.2;
            this.cameraLightGlobal.direction.set(lightDir);
            Vector3D camLightAbsPos = this.aux3d.set(lightDir).scl(-distCamCenter).add(boxCenterAbsPos);
            this.aux2d.set(camLightAbsPos).sub(camera.getPos()).put(this.cameraLightGlobal.position);
            double minDist = Double.MAX_VALUE;
            double maxDist = 0.0;
            for (IRenderable render : candidates) {
                Entity entity = ((Render)render).entity;
                Vector3Q entityAbsPos = EntityUtils.getAbsolutePosition(entity, this.aux1b);
                double r = EntityUtils.getRadius(entity) * 2.0;
                double d = camLightAbsPos.dst(entityAbsPos);
                double dMin = d - r;
                double dMax = d + r;
                if (minDist > dMin) {
                    minDist = dMin;
                }
                if (!(maxDist < dMax)) continue;
                maxDist = dMax;
            }
            if (this.cameraLightGlobal.direction.y != 0.0f || this.cameraLightGlobal.direction.z != 0.0f) {
                this.aux1.set(1.0f, 0.0f, 0.0f);
            } else {
                this.aux1.set(0.0f, 1.0f, 0.0f);
            }
            this.cameraLightGlobal.up.set(this.cameraLightGlobal.direction).crs(this.aux1);
            this.cameraLightGlobal.near = (float)FastMath.max((double)(100.0 * Constants.M_TO_U), (double)minDist);
            this.cameraLightGlobal.far = (float)FastMath.min((double)Constants.AU_TO_U, (double)maxDist);
            this.cameraLightGlobal.update(false);
            FrameBuffer fb = this.globalFrameBuffer == null ? this.newShadowMapFrameBuffer(null) : this.globalFrameBuffer;
            fb.begin();
            Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
            Gdx.gl.glClear(16640);
            renderAssets.mbPixelLightingDepth.begin((Camera)this.cameraLightGlobal);
            for (IRenderable iRenderable : candidates) {
                this.modelRenderer.render(((Render)iRenderable).entity, renderAssets.mbPixelLightingDepth, camera, 1.0f, 0.0, null, RenderGroup.MODEL_PIX, false);
            }
            renderAssets.mbPixelLightingDepth.end();
            fb.end();
            this.globalFrameBuffer = fb;
            if (!DEBUG_UI_VIEW_GLOBAL) {
                GaiaSky.postRunnable(() -> EventManager.publish(Event.SHOW_TEXTURE_WINDOW_ACTION, this, "Shadow map (GLOBAL)", this.globalFrameBuffer.getColorBufferTexture(), Float.valueOf(0.2f)));
                DEBUG_UI_VIEW_GLOBAL = false;
            }
        }
    }

    private void renderShadowMapCandidates(List<Entity> candidates, int shadowNRender, ICamera camera) {
        RenderAssets renderAssets = this.sceneRenderer.getRenderAssets();
        int nShadows = FastMath.min((int)candidates.size(), (int)Settings.settings.scene.renderer.shadow.number);
        for (int i = 0; i < nShadows; ++i) {
            Entity candidate = candidates.get(i);
            Model model = (Model)Mapper.model.get(candidate);
            ModelScaffolding scaffolding = (ModelScaffolding)Mapper.modelScaffolding.get(candidate);
            double entitySpan = EntityUtils.getModelSpan(candidate);
            double distCamCenter = entitySpan * 2.0 / FastMath.tan((double)FastMath.toRadians((double)this.cameraLightIndividual.fieldOfView));
            Vector3Q objPos = EntityUtils.getAbsolutePosition(candidate, this.aux1b);
            for (int j = 0; j < 1; ++j) {
                FrameBuffer fb;
                Vector3 lightDir = this.aux1;
                if (model.model.hasDirLight(j)) {
                    lightDir.set(model.model.dirLight((int)j).direction);
                } else if (model.model.hasPointLight(j)) {
                    lightDir.set(model.model.pointLight((int)j).position);
                    this.aux2b.set(objPos).sub(lightDir).nor().put(lightDir);
                }
                this.cameraLightIndividual.direction.set(lightDir);
                objPos.sub(camera.getPos()).sub(lightDir.nor().scl((float)distCamCenter));
                objPos.put(this.cameraLightIndividual.position);
                if (this.cameraLightIndividual.direction.y != 0.0f || this.cameraLightIndividual.direction.z != 0.0f) {
                    this.aux1.set(1.0f, 0.0f, 0.0f);
                } else {
                    this.aux1.set(0.0f, 1.0f, 0.0f);
                }
                this.cameraLightIndividual.up.set(this.cameraLightIndividual.direction).crs(this.aux1);
                this.cameraLightIndividual.near = (float)(distCamCenter - entitySpan);
                this.cameraLightIndividual.far = (float)(distCamCenter + entitySpan);
                this.cameraLightIndividual.update(false);
                scaffolding.shadowMapFb = fb = scaffolding.shadowMapFb == null ? this.newShadowMapFrameBuffer(candidate) : scaffolding.shadowMapFb;
                if (scaffolding.shadowMapCombined == null) {
                    scaffolding.shadowMapCombined = new Matrix4();
                }
                fb.begin();
                Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
                Gdx.gl.glClear(16640);
                renderAssets.mbPixelLightingDepth.begin((Camera)this.cameraLightIndividual);
                this.modelRenderer.render(candidate, renderAssets.mbPixelLightingDepth, camera, 1.0f, 0.0, null, RenderGroup.MODEL_PIX, false);
                renderAssets.mbPixelLightingDepth.end();
                scaffolding.shadow = shadowNRender;
                scaffolding.shadowMapCombined.set(this.cameraLightIndividual.combined);
                fb.end();
                Base base = (Base)Mapper.base.get(candidate);
                int n = base.getName().hashCode();
            }
        }
    }

    private void addCandidates(List<IRenderable> models, List<Entity> candidates) {
        if (candidates != null) {
            candidates.clear();
            int num = 0;
            for (IRenderable model : models) {
                Render render = (Render)model;
                ModelScaffolding scaffolding = (ModelScaffolding)Mapper.modelScaffolding.get(render.entity);
                if (scaffolding == null || !scaffolding.isSelfShadow()) continue;
                candidates.add(num, render.entity);
                scaffolding.shadow = 0;
                if (++num != Settings.settings.scene.renderer.shadow.number) continue;
                break;
            }
        }
    }

    private void renderShadowMapCandidatesTess(Array<Entity> candidates, int shadowNRender, ICamera camera, RenderingContext rc) {
        int i = 0;
        boolean j = false;
        RenderAssets renderAssets = this.sceneRenderer.getRenderAssets();
        for (Entity candidate : candidates) {
            Body body = (Body)Mapper.body.get(candidate);
            Model model = (Model)Mapper.model.get(candidate);
            ModelScaffolding scaffolding = (ModelScaffolding)Mapper.modelScaffolding.get(candidate);
            double radius = (double)body.size / 2.0 * (double)scaffolding.sizeScaleFactor;
            if (body.distToCamera < radius * 1.1) {
                scaffolding.shadow = shadowNRender;
                Vector3 shadowCameraDir = this.aux1.set(model.model.dirLight((int)0).direction);
                this.cameraLightIndividual.direction.set(shadowCameraDir);
                Vector3 shadowCamDir = this.aux1.set(model.model.dirLight((int)0).direction);
                this.cameraLightIndividual.direction.set(shadowCamDir);
                double entitySpan = EntityUtils.getModelSpan(candidate);
                double distCamCenter = entitySpan * 2.0 / FastMath.tan((double)FastMath.toRadians((double)this.cameraLightIndividual.fieldOfView));
                Vector3Q objPos = EntityUtils.getAbsolutePosition(candidate, this.aux1b);
                Vector3Q camPos = camera.getPos();
                Vector3D camDir = this.aux3d.set(camera.getDirection()).nor().scl(100.0 * Constants.KM_TO_U);
                boolean intersect = IntersectorDouble.checkIntersectSegmentSphere(camPos.tov3d(), this.aux3d.set(camPos).add(camDir), objPos.put(this.aux1d), radius);
                if (intersect) {
                    camDir.nor().scl(body.distToCamera - radius);
                }
                Vector3D objCam = this.aux2d.set(camPos).sub(objPos).nor().scl(-(body.distToCamera - radius)).add(camDir);
                objCam.add(shadowCamDir.nor().scl((float)(-distCamCenter)));
                objCam.put(this.cameraLightIndividual.position);
                if (this.cameraLightIndividual.direction.y != 0.0f || this.cameraLightIndividual.direction.z != 0.0f) {
                    this.aux1.set(1.0f, 0.0f, 0.0f);
                } else {
                    this.aux1.set(0.0f, 1.0f, 0.0f);
                }
                this.cameraLightIndividual.up.set(this.cameraLightIndividual.direction).crs(this.aux1);
                this.cameraLightIndividual.near = (float)(distCamCenter - entitySpan);
                this.cameraLightIndividual.far = (float)(distCamCenter + entitySpan);
                this.cameraLightIndividual.update(false);
                Gdx.gl.glClear(16640);
                renderAssets.mbPixelLightingDepthTessellation.begin((Camera)this.cameraLightIndividual);
                this.modelRenderer.render(candidate, renderAssets.mbPixelLightingDepthTessellation, camera, 1.0f, 0.0, rc, RenderGroup.MODEL_PIX, true);
                renderAssets.mbPixelLightingDepthTessellation.end();
                scaffolding.shadow = shadowNRender;
                ++i;
                continue;
            }
            scaffolding.shadow = -1;
        }
    }

    @Override
    protected void renderPass(ICamera camera, Object ... params) {
        List<IRenderable> models = this.sceneRenderer.getRenderLists().get(RenderGroup.MODEL_PIX.ordinal());
        models.sort(Comparator.comparingDouble(IRenderable::getDistToCamera));
        int shadowNRender = Settings.settings.program.modeStereo.active || Settings.settings.runtime.openXr ? 2 : (Settings.settings.program.modeCubemap.active ? 6 : 1);
        this.addCandidates(models, this.shadowCandidates);
        this.renderShadowMapCandidates(this.shadowCandidates, shadowNRender, camera);
    }

    public void disposeCachedFrameBuffers() {
        if (this.shadowMapEntities != null) {
            this.shadowMapEntities.forEach(entity -> {
                ModelScaffolding scaffolding = (ModelScaffolding)Mapper.modelScaffolding.get(entity);
                if (scaffolding != null && scaffolding.shadowMapFb != null) {
                    scaffolding.shadowMapFb.dispose();
                    scaffolding.shadowMapFb = null;
                }
            });
            this.shadowMapEntities.clear();
        }
    }

    @Override
    public void dispose() {
        this.disposeCachedFrameBuffers();
    }
}

