/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.system.update;

import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.core.Family;
import gaiasky.GaiaSky;
import gaiasky.scene.Mapper;
import gaiasky.scene.camera.ICamera;
import gaiasky.scene.component.Axis;
import gaiasky.scene.component.Body;
import gaiasky.scene.system.update.AbstractUpdateSystem;
import net.jafama.FastMath;

public class AxesUpdater
extends AbstractUpdateSystem {
    public static final double LINE_SIZE_RAD = FastMath.tan((double)Math.toRadians(2.9));

    public AxesUpdater(Family family, int priority) {
        super(family, priority);
    }

    protected void processEntity(Entity entity, float deltaTime) {
        this.updateEntity(entity, deltaTime);
    }

    @Override
    public void updateEntity(Entity entity, float deltaTime) {
        Body body = (Body)Mapper.body.get(entity);
        Axis axis = (Axis)Mapper.axis.get(entity);
        ICamera camera = GaiaSky.instance.getICamera();
        body.distToCamera = (float)camera.getPos().lenDouble();
        body.size = (float)(LINE_SIZE_RAD * body.distToCamera) * camera.getFovFactor();
        axis.o.set(camera.getInversePos());
        axis.x.set(axis.b0).scl(body.size).add(axis.o);
        axis.y.set(axis.b1).scl(body.size).add(axis.o);
        axis.z.set(axis.b2).scl(body.size).add(axis.o);
    }
}

