/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.system.update;

import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.core.Family;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.utils.reflect.ClassReflection;
import com.badlogic.gdx.utils.reflect.Method;
import com.badlogic.gdx.utils.reflect.ReflectionException;
import gaiasky.scene.Mapper;
import gaiasky.scene.component.Body;
import gaiasky.scene.component.GraphNode;
import gaiasky.scene.component.Model;
import gaiasky.scene.component.RefSysTransform;
import gaiasky.scene.system.update.AbstractUpdateSystem;
import gaiasky.util.Logger;
import gaiasky.util.coord.Coordinates;
import gaiasky.util.math.Matrix4D;

public class BackgroundUpdater
extends AbstractUpdateSystem {
    public BackgroundUpdater(Family family, int priority) {
        super(family, priority);
    }

    @Override
    public void updateEntity(Entity entity, float deltaTime) {
        this.processEntity(entity, deltaTime);
    }

    protected void processEntity(Entity entity, float deltaTime) {
        Body body = (Body)Mapper.body.get(entity);
        GraphNode graph = (GraphNode)Mapper.graph.get(entity);
        this.updateLocalTransform(entity, body, graph);
    }

    private void updateLocalTransform(Entity entity, Body body, GraphNode graph) {
        RefSysTransform transform = (RefSysTransform)Mapper.transform.get(entity);
        Model model = (Model)Mapper.model.get(entity);
        String transformName = transform.transformName;
        Matrix4 localTransform = graph.localTransform;
        localTransform.idt();
        localTransform.scl(body.size);
        if (transformName != null) {
            Class<Coordinates> c = Coordinates.class;
            try {
                Method m = ClassReflection.getMethod(c, (String)transformName, (Class[])new Class[0]);
                Matrix4D trf = (Matrix4D)m.invoke(null, new Object[0]);
                Matrix4 aux = trf.putIn(new Matrix4());
                localTransform.mul(aux);
            }
            catch (ReflectionException e) {
                Logger.getLogger(this.getClass()).error("Error getting/invoking method Coordinates." + transformName + "()");
            }
        }
        if (model.model != null && model.model.type.equalsIgnoreCase("sphere")) {
            localTransform.rotate(0.0f, 1.0f, 0.0f, 90.0f);
        }
    }
}

