/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.system.update;

import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.core.Family;
import com.badlogic.gdx.math.Matrix4;
import gaiasky.GaiaSky;
import gaiasky.scene.Mapper;
import gaiasky.scene.camera.ICamera;
import gaiasky.scene.component.Body;
import gaiasky.scene.component.Fade;
import gaiasky.scene.component.GraphNode;
import gaiasky.scene.component.RefSysTransform;
import gaiasky.scene.system.update.AbstractUpdateSystem;

public class BillboardSetUpdater
extends AbstractUpdateSystem {
    private final Matrix4 M41 = new Matrix4();

    public BillboardSetUpdater(Family family, int priority) {
        super(family, priority);
    }

    protected void processEntity(Entity entity, float deltaTime) {
        this.updateEntity(entity, deltaTime);
    }

    @Override
    public void updateEntity(Entity entity, float deltaTime) {
        GraphNode graph = (GraphNode)Mapper.graph.get(entity);
        Body body = (Body)Mapper.body.get(entity);
        RefSysTransform transform = (RefSysTransform)Mapper.transform.get(entity);
        Fade fade = (Fade)Mapper.fade.get(entity);
        graph.translation.setToTranslation(graph.localTransform).scl(body.size);
        graph.localTransform.mul(transform.matrix.putIn(this.M41));
        ICamera camera = GaiaSky.instance.getICamera();
        fade.currentDistance = camera.getDistance() * (double)camera.getFovFactor();
    }
}

