/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.system.update;

import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.core.Family;
import com.badlogic.gdx.math.Vector3;
import gaiasky.scene.Mapper;
import gaiasky.scene.component.Base;
import gaiasky.scene.component.Body;
import gaiasky.scene.component.Cluster;
import gaiasky.scene.component.GraphNode;
import gaiasky.scene.component.SolidAngle;
import gaiasky.scene.system.update.AbstractUpdateSystem;
import gaiasky.util.math.MathUtilsDouble;

public class ClusterUpdater
extends AbstractUpdateSystem {
    private final Vector3 F31 = new Vector3();

    public ClusterUpdater(Family family, int priority) {
        super(family, priority);
    }

    protected void processEntity(Entity entity, float deltaTime) {
        this.updateEntity(entity, deltaTime);
    }

    @Override
    public void updateEntity(Entity entity, float deltaTime) {
        Base base = (Base)Mapper.base.get(entity);
        if (base.opacity > 0.0f) {
            Body body = (Body)Mapper.body.get(entity);
            GraphNode graph = (GraphNode)Mapper.graph.get(entity);
            Cluster cluster = (Cluster)Mapper.cluster.get(entity);
            SolidAngle sa = (SolidAngle)Mapper.sa.get(entity);
            base.opacity *= 0.1f * base.getVisibilityOpacityFactor();
            cluster.fadeAlpha = (float)MathUtilsDouble.flint(body.solidAngleApparent, sa.thresholdPoint, sa.thresholdQuad, 0.0, 1.0);
            body.labelColor[3] = 8.0f * cluster.fadeAlpha;
            graph.localTransform.idt().translate(graph.translation.put(this.F31)).scl(body.size);
        }
    }
}

