/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.system.update;

import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.core.Family;
import gaiasky.GaiaSky;
import gaiasky.scene.Mapper;
import gaiasky.scene.camera.ICamera;
import gaiasky.scene.component.Body;
import gaiasky.scene.component.Constel;
import gaiasky.scene.component.Label;
import gaiasky.scene.system.update.AbstractUpdateSystem;
import gaiasky.util.Constants;
import gaiasky.util.coord.AstroUtils;
import gaiasky.util.math.Vector3D;
import gaiasky.util.tree.IPosition;

public class ConstellationUpdater
extends AbstractUpdateSystem {
    private final Vector3D D31 = new Vector3D();

    public ConstellationUpdater(Family family, int priority) {
        super(family, priority);
    }

    protected void processEntity(Entity entity, float deltaTime) {
        this.updateEntity(entity, deltaTime);
    }

    @Override
    public void updateEntity(Entity entity, float deltaTime) {
        ICamera camera = GaiaSky.instance.getICamera();
        Constel constel = (Constel)Mapper.constel.get(entity);
        Body body = (Body)Mapper.body.get(entity);
        Label label = (Label)Mapper.label.get(entity);
        constel.posd.setZero();
        Vector3D p = this.D31;
        int nStars = 0;
        for (IPosition[] line : constel.lines) {
            if (line == null) continue;
            p.set(line[0].getPosition()).add(camera.getInversePos());
            constel.posd.add(p);
            ++nStars;
        }
        if (nStars > 0) {
            constel.posd.scl(1.0 / (double)nStars);
            constel.posd.nor().scl(100.0 * Constants.PC_TO_U);
            body.pos.set(constel.posd);
            label.labelPosition.set(body.pos).add(camera.getPos());
            constel.deltaYears = AstroUtils.getMsSince(GaiaSky.instance.time.getTime(), AstroUtils.JD_J2015_5) * 3.168808781402895E-11;
        }
    }
}

