/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.scene.system.update;

import com.badlogic.ashley.core.Component;
import com.badlogic.ashley.core.Engine;
import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.core.Family;
import gaiasky.GaiaSky;
import gaiasky.scene.Mapper;
import gaiasky.scene.component.Base;
import gaiasky.scene.component.DatasetDescription;
import gaiasky.scene.component.GraphNode;
import gaiasky.scene.component.tag.TagNoProcess;
import gaiasky.scene.system.update.AbstractUpdateSystem;

public class DatasetDescriptionUpdater
extends AbstractUpdateSystem {
    public DatasetDescriptionUpdater(Family family, int priority) {
        super(family, priority);
    }

    protected void processEntity(Entity entity, float deltaTime) {
        this.updateEntity(entity, deltaTime);
    }

    @Override
    public void updateEntity(Entity entity, float deltaTime) {
        Base base = (Base)Mapper.base.get(entity);
        DatasetDescription ds = (DatasetDescription)Mapper.datasetDescription.get(entity);
        float alpha = GaiaSky.instance.alpha(base.ct);
        if (alpha == 0.0f && ds.previousAlpha != 0.0f) {
            this.enableChildrenProcessing(entity, false);
        } else if (alpha > 0.0f && ds.previousAlpha == 0.0f) {
            this.enableChildrenProcessing(entity, true);
        }
        ds.previousAlpha = alpha;
    }

    public void enableChildrenProcessing(Entity entity, boolean enable) {
        GraphNode graph = (GraphNode)Mapper.graph.get(entity);
        if (graph != null && graph.children != null && graph.children.size > 0) {
            for (Entity child : graph.children) {
                if (enable) {
                    child.remove(TagNoProcess.class);
                    continue;
                }
                Engine engine = this.getEngine();
                child.add((Component)(engine != null ? engine.createComponent(TagNoProcess.class) : new TagNoProcess()));
            }
        }
    }
}

